# 画面設計書: 勤務地一覧

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 101 |
| 画面名 | 勤務地一覧 |
| 画面種別 | 一覧画面 |
| 対応するソースファイル | `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/WorkLocationResource/Pages/ListWorkLocations.php` |
| リソースファイル | `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/WorkLocationResource.php` |
| 関連モデル | `Webkul\Employee\Models\WorkLocation` |
| URL | `/admin/employees/configurations/work-locations` |

## 2. 画面概要

従業員の勤務地情報を一覧表示・管理する画面。勤務地のCRUD操作（作成・参照・更新・削除）、検索・フィルタリング・グループ化・並べ替え機能を提供する。

## 3. 画面レイアウト

### 3.1 ヘッダー部
- 画面タイトル: Work Locations（勤務地）
- ナビゲーションアイコン: heroicon-o-map-pin
- クラスター: Configurations

### 3.2 テーブル表示部

| カラム名 | フィールド | 表示形式 | 検索可否 | ソート可否 | デフォルト表示 |
|----------|-----------|----------|----------|------------|----------------|
| ID | id | テキスト | 可 | 可 | 非表示 |
| 名前 | name | テキスト | 可 | - | 表示 |
| 勤務地タイプ | location_type | バッジ | 可 | - | 表示 |
| ステータス | is_active | アイコン（Boolean） | - | - | 表示 |
| 会社 | company.name | テキスト | - | 可 | 表示 |
| 勤務地番号 | location_number | テキスト | 可 | - | 非表示 |
| 作成者 | createdBy.name | テキスト | - | 可 | 非表示 |
| 作成日時 | created_at | 日時 | - | 可 | 非表示 |
| 更新日時 | updated_at | 日時 | - | 可 | 非表示 |
| 削除日時 | deleted_at | 日時 | - | 可 | 非表示 |

### 3.3 アクション部

#### ヘッダーアクション
- **新規作成ボタン**: モーダルダイアログで勤務地を新規作成

#### 行アクション
| アクション | 説明 | 条件 |
|------------|------|------|
| 表示 | 勤務地詳細をモーダル表示 | - |
| 編集 | 勤務地をモーダル編集 | - |
| 削除 | 勤務地を論理削除 | - |
| 復元 | 削除した勤務地を復元 | 削除済みの場合 |
| 完全削除 | 勤務地を物理削除 | 削除済みの場合 |

#### 一括アクション
- **一括削除**: 選択した勤務地を一括削除
- **一括完全削除**: 選択した勤務地を一括物理削除

## 4. 入力フォーム（モーダル）

### 4.1 フォームフィールド

| フィールド名 | 項目ID | 入力形式 | 必須 | 最大長 | 備考 |
|--------------|--------|----------|------|--------|------|
| 名前 | name | テキスト入力 | 必須 | 255 | - |
| 作成者ID | creator_id | 非表示 | 必須 | - | ログインユーザーIDが自動設定 |
| 勤務地タイプ | location_type | トグルボタン | 必須 | - | WorkLocationEnumの値から選択 |
| 勤務地番号 | location_number | テキスト入力 | - | - | - |
| 会社 | company_id | セレクト | 必須 | - | companyリレーションから選択、検索可能、プリロード |
| ステータス | is_active | トグル | 必須 | - | 有効/無効 |

## 5. フィルタ機能

### 5.1 基本フィルタ

| フィルタ名 | 種別 | 説明 |
|------------|------|------|
| ステータス | TernaryFilter | 有効/無効/すべて |

### 5.2 QueryBuilderフィルタ

| フィルタ名 | 種別 | アイコン |
|------------|------|----------|
| 名前 | TextConstraint | heroicon-o-user |
| 勤務地タイプ | TextConstraint | heroicon-o-map |
| 勤務地番号 | TextConstraint | heroicon-o-map |
| 会社 | RelationshipConstraint | heroicon-o-building-office |
| 作成者 | RelationshipConstraint | heroicon-o-user |
| 作成日時 | DateConstraint | - |
| 更新日時 | DateConstraint | - |

## 6. グループ化機能

| グループ名 | フィールド | 折りたたみ可否 |
|------------|-----------|----------------|
| 名前 | name | 可 |
| 作成者 | createdBy.name | 可 |
| 勤務地タイプ | location_type | 可 |
| 会社 | company.name | 可 |
| ステータス | is_active | 可 |
| 作成日時 | created_at | 可 |
| 更新日時 | updated_at | 可（日付グループ） |

## 7. 詳細表示（Infolist）

| 表示項目 | フィールド | アイコン |
|----------|-----------|----------|
| 名前 | name | heroicon-o-map |
| 勤務地タイプ | location_type | heroicon-o-map |
| 勤務地番号 | location_number | heroicon-o-map |
| 会社 | company.name | heroicon-o-building-office |
| ステータス | is_active | - (Boolean Icon) |

## 8. 通知メッセージ

| 操作 | 種別 | タイトルキー | 本文キー |
|------|------|--------------|----------|
| 編集成功 | success | table.actions.edit.notification.title | table.actions.edit.notification.body |
| 削除成功 | success | table.actions.delete.notification.title | table.actions.delete.notification.body |
| 復元成功 | success | table.actions.restore.notification.title | table.actions.restore.notification.body |
| 完全削除成功 | success | table.actions.force-delete.notification.title | table.actions.force-delete.notification.body |
| 一括削除成功 | success | table.bulk-actions.delete.notification.title | table.bulk-actions.delete.notification.body |
| 一括完全削除成功 | success | table.bulk-actions.force-delete.notification.title | table.bulk-actions.force-delete.notification.body |
| 空状態から作成 | success | table.actions.empty-state.notification.title | table.actions.empty-state.notification.body |

## 9. 画面遷移

### 9.1 遷移元
- 従業員設定メニュー

### 9.2 遷移先
- なし（モーダルベースの操作）

## 10. 権限・アクセス制御

- 従業員設定クラスターへのアクセス権限が必要
- 会社IDはログインユーザーのデフォルト会社に基づく

## 11. 技術仕様

### 11.1 使用コンポーネント
- Filament ListRecords
- Filament Tables
- Filament Forms (Modal)
- Filament Infolists
- QueryBuilder Filter

### 11.2 特殊機能
- カラム並べ替え可能（reorderableColumns）
- カラムマネージャー（columnManagerColumns: 2）
- ソフトデリート対応

### 11.3 言語ファイル
- `employees::filament/clusters/configurations/resources/work-location`
