# 画面設計書: 雇用形態一覧

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 102 |
| 画面名 | 雇用形態一覧 |
| 画面種別 | 一覧画面 |
| 対応するソースファイル | `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/EmploymentTypeResource/Pages/ListEmploymentTypes.php` |
| リソースファイル | `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/EmploymentTypeResource.php` |
| 関連モデル | `Webkul\Employee\Models\EmploymentType` |
| URL | `/admin/employees/configurations/employment-types` |

## 2. 画面概要

従業員の雇用形態（正社員、契約社員、パートタイムなど）を一覧表示・管理する画面。雇用形態のCRUD操作、検索・フィルタリング・グループ化・並べ替え機能を提供する。

## 3. 画面レイアウト

### 3.1 ヘッダー部
- 画面タイトル: Employment Types（雇用形態）
- ナビゲーションアイコン: heroicon-o-cube-transparent
- クラスター: Configurations

### 3.2 テーブル表示部

| カラム名 | フィールド | 表示形式 | 検索可否 | ソート可否 | デフォルト表示 |
|----------|-----------|----------|----------|------------|----------------|
| ID | id | テキスト | 可 | 可 | 非表示 |
| 名前 | name | テキスト | 可 | 可 | 表示 |
| コード | code | テキスト | 可 | 可 | 表示 |
| 国 | country.name | テキスト | 可 | 可 | 表示 |
| 作成者 | createdBy.name | テキスト | - | 可 | 非表示 |
| 作成日時 | created_at | 日時 | - | 可 | 非表示 |
| 更新日時 | updated_at | 日時 | - | 可 | 非表示 |

### 3.3 アクション部

#### ヘッダーアクション
- **新規作成ボタン**: モーダルダイアログで雇用形態を新規作成

#### 行アクション
| アクション | 説明 | 条件 |
|------------|------|------|
| 表示 | 雇用形態詳細をモーダル表示 | - |
| 編集 | 雇用形態をモーダル編集 | - |
| 削除 | 雇用形態を削除 | - |

#### 一括アクション
- **一括削除**: 選択した雇用形態を一括削除

## 4. 入力フォーム（モーダル）

### 4.1 フォームフィールド

| フィールド名 | 項目ID | 入力形式 | 必須 | 最大長 | 備考 |
|--------------|--------|----------|------|--------|------|
| 作成者ID | creator_id | 非表示 | - | - | ログインユーザーIDが自動設定 |
| 名前 | name | テキスト入力 | 必須 | 255 | ライブ入力（onBlur） |
| コード | code | テキスト入力 | - | - | - |
| 国 | country_id | セレクト | - | - | countryリレーションから選択、検索可能、プリロード |

### 4.2 フォームレイアウト
- 2カラムレイアウト（columns: 2）

## 5. フィルタ機能

### 5.1 QueryBuilderフィルタ

| フィルタ名 | 種別 | アイコン |
|------------|------|----------|
| 名前 | TextConstraint | heroicon-o-user |
| 国 | RelationshipConstraint | heroicon-o-map |
| 作成者 | RelationshipConstraint | heroicon-o-user |
| 作成日時 | DateConstraint | - |
| 更新日時 | DateConstraint | - |

### 5.2 フィルタ設定
- constraintPickerColumns: 2

## 6. グループ化機能

| グループ名 | フィールド | 折りたたみ可否 |
|------------|-----------|----------------|
| 名前 | name | 可 |
| コード | code | 可 |
| 国 | country.name | 可 |
| 作成者 | createdBy.name | 可 |
| 作成日時 | created_at | 可 |
| 更新日時 | updated_at | 可（日付グループ） |

## 7. 詳細表示（Infolist）

| 表示項目 | フィールド | アイコン | プレースホルダー |
|----------|-----------|----------|------------------|
| 名前 | name | heroicon-o-user | - |
| コード | code | heroicon-o-user | - |
| 国 | country.name | heroicon-o-map | - |

## 8. 通知メッセージ

| 操作 | 種別 | タイトルキー | 本文キー |
|------|------|--------------|----------|
| 編集成功 | success | table.actions.edit.notification.title | table.actions.edit.notification.body |
| 削除成功 | success | table.actions.delete.notification.title | table.actions.delete.notification.body |
| 一括削除成功 | success | table.bulk-actions.delete.notification.title | table.bulk-actions.delete.notification.body |
| 空状態から作成 | success | table.empty-state-actions.create.notification.title | table.empty-state-actions.create.notification.body |

## 9. 画面遷移

### 9.1 遷移元
- 従業員設定メニュー

### 9.2 遷移先
- なし（モーダルベースの操作）

## 10. 権限・アクセス制御

- 従業員設定クラスターへのアクセス権限が必要

## 11. 技術仕様

### 11.1 使用コンポーネント
- Filament ListRecords
- Filament Tables
- Filament Forms (Modal)
- Filament Infolists
- QueryBuilder Filter

### 11.2 特殊機能
- 並べ替え可能（reorderable: sort）
- デフォルトソート: sort DESC
- 編集時にcodeがnullの場合nameをcodeに設定（mutateDataUsing）

### 11.3 言語ファイル
- `employees::filament/clusters/configurations/resources/employment-type`

## 12. 特殊処理

### 12.1 編集時のデータ変換
```php
->mutateDataUsing(function (array $data): array {
    $data['code'] = $data['code'] ?? $data['name'];
    return $data;
})
```
- 編集時、codeが未設定の場合はnameの値をcodeに自動設定
