# 画面設計書: 従業員スキルレポート

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 103 |
| 画面名 | 従業員スキルレポート |
| 画面種別 | レポート画面（一覧） |
| 対応するソースファイル | `plugins/webkul/employees/src/Filament/Clusters/Reportings/Resources/EmployeeSkillResource/Pages/ListEmployeeSkills.php` |
| リソースファイル | `plugins/webkul/employees/src/Filament/Clusters/Reportings/Resources/EmployeeSkillResource.php` |
| 関連モデル | `Webkul\Employee\Models\EmployeeSkill` |
| URL | `/admin/employees/reportings/employees/skills` |

## 2. 画面概要

従業員のスキル情報をレポート形式で一覧表示する画面。従業員ごとのスキル、スキルレベル、スキルタイプを確認でき、熟練度をプログレスバーで視覚化する。フィルタリング・グループ化機能により、スキル分析が可能。

## 3. 画面レイアウト

### 3.1 ヘッダー部
- 画面タイトル: Skills（スキル）
- ナビゲーションアイコン: heroicon-o-academic-cap
- クラスター: Reportings

### 3.2 テーブル表示部

| カラム名 | フィールド | 表示形式 | 検索可否 | ソート可否 | デフォルト表示 |
|----------|-----------|----------|----------|------------|----------------|
| ID | id | テキスト | - | 可 | 非表示 |
| 従業員 | employee.name | テキスト | 可 | 可 | 表示 |
| スキル | skill.name | テキスト | 可 | 可 | 表示 |
| スキルレベル | skillLevel.name | バッジ（色分け） | - | - | 表示 |
| 熟練度 | skill_level_percentage | プログレスバー | - | - | 表示 |
| スキルタイプ | skillType.name | バッジ | 可 | 可 | 表示 |
| 作成者 | createdBy.name | テキスト | 可 | 可 | 非表示 |
| ユーザー | employee.user.name | テキスト | 可 | 可 | 非表示 |
| 作成日時 | created_at | 日時 | - | 可 | 非表示 |

### 3.3 スキルレベル色分け

| レベル名 | 色 |
|----------|-----|
| Beginner | gray |
| Intermediate | warning |
| Advanced | success |
| Expert | primary |
| その他 | secondary |

### 3.4 アクション部

#### 行アクション
| アクション | 説明 | 条件 |
|------------|------|------|
| 表示 | スキル詳細をモーダル表示 | ActionGroupで提供 |

## 4. フィルタ機能

### 4.1 セレクトフィルタ

| フィルタ名 | 種別 | リレーション |
|------------|------|--------------|
| 従業員 | SelectFilter | employee (name) |
| スキル | SelectFilter | skill (name) |
| スキルレベル | SelectFilter | skillLevel (name) |
| スキルタイプ | SelectFilter | skillType (name) |

すべて検索可能・プリロード設定あり。

### 4.2 QueryBuilderフィルタ

| フィルタ名 | 種別 | アイコン |
|------------|------|----------|
| 従業員 | RelationshipConstraint | heroicon-o-user |
| 作成者 | RelationshipConstraint | heroicon-o-user |
| ユーザー | RelationshipConstraint | heroicon-o-user |
| 作成日時 | DateConstraint | - |
| 更新日時 | DateConstraint | - |

### 4.3 フィルタ設定
- filtersFormColumns: 2
- constraintPickerColumns: 2

## 5. グループ化機能

| グループ名 | フィールド | 折りたたみ可否 | デフォルト |
|------------|-----------|----------------|------------|
| 従業員 | employee.name | 可 | デフォルトグループ |
| スキルタイプ | skillType.name | 可 | - |

## 6. 詳細表示（Infolist）

### 6.1 スキル詳細セクション

| 表示項目 | フィールド | アイコン | プレースホルダー |
|----------|-----------|----------|------------------|
| 従業員 | employee.name | heroicon-o-user | - |
| スキル | skill.name | heroicon-o-bolt | - |
| スキルレベル | skillLevel.name | heroicon-o-bolt | - |
| スキルタイプ | skillType.name | - | - |

2カラムレイアウト

### 6.2 追加情報セクション

| 表示項目 | フィールド | アイコン | プレースホルダー |
|----------|-----------|----------|------------------|
| 作成者 | createdBy.name | heroicon-o-user | - |
| 更新者 | employee.user.name | heroicon-o-user | - |

2カラムレイアウト

## 7. 画面遷移

### 7.1 遷移元
- 従業員レポートメニュー

### 7.2 遷移先
- なし（閲覧専用画面）

## 8. 権限・アクセス制御

- 従業員レポートクラスターへのアクセス権限が必要

## 9. 技術仕様

### 9.1 使用コンポーネント
- Filament ListRecords
- Filament Tables
- Filament Infolists
- Custom ProgressBarEntry（カスタムコンポーネント）
- QueryBuilder Filter
- SelectFilter

### 9.2 特殊機能
- カラム並べ替え可能（reorderableColumns）
- カラムマネージャー（columnManagerColumns: 2）
- デフォルトソート: created_at DESC
- デフォルトグループ: employee.name

### 9.3 カスタムコンポーネント
- `CustomTables\Columns\ProgressBarEntry`: スキルレベルの熟練度をプログレスバーで表示
  - skillLevel.levelの値を使用（0-100の範囲を想定）

### 9.4 スラッグ設定
- カスタムスラッグ: `employees/skills`

### 9.5 言語ファイル
- `employees::filament/clusters/reportings/resources/employee-skill`

## 10. 備考

- この画面はレポート目的のため、作成・編集機能は提供しない
- 熟練度はskillLevelのlevelプロパティから取得される
- ViewActionのみ提供（参照専用）
