# 画面設計書: カスタムフィールド一覧

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 104 |
| 画面名 | カスタムフィールド一覧 |
| 画面種別 | 一覧画面 |
| 対応するソースファイル | `plugins/webkul/fields/src/Filament/Resources/FieldResource/Pages/ListFields.php` |
| リソースファイル | `plugins/webkul/fields/src/Filament/Resources/FieldResource.php` |
| 関連モデル | `Webkul\Field\Models\Field` |
| URL | `/admin/fields` |

## 2. 画面概要

アプリケーション全体で使用されるカスタムフィールドを一覧表示・管理する画面。各リソースに対して動的に追加できるカスタムフィールドの作成・編集・削除機能を提供する。ソフトデリート対応。

## 3. 画面レイアウト

### 3.1 ヘッダー部
- 画面タイトル: Custom Fields（カスタムフィールド）
- ナビゲーションソート: 5

### 3.2 テーブル表示部

| カラム名 | フィールド | 表示形式 | 検索可否 | ソート可否 | デフォルト表示 |
|----------|-----------|----------|----------|------------|----------------|
| コード | code | テキスト | 可 | 可 | 表示 |
| 名前 | name | テキスト | 可 | 可 | 表示 |
| タイプ | type | テキスト | - | 可 | 表示 |
| リソース | customizable_type | テキスト（説明付き） | - | 可 | 表示 |
| 作成日時 | created_at | 日時 | - | 可 | 表示 |

### 3.3 リソース列の説明表示
- customizable_typeからリソース名を抽出して「XXXResource」形式で表示

### 3.4 アクション部

#### ヘッダーアクション
- **新規作成**: カスタムフィールド作成画面へ遷移

#### 行アクション
| アクション | 説明 | 条件 |
|------------|------|------|
| 編集 | カスタムフィールド編集画面へ遷移 | 削除済みでない場合 |
| 復元 | 削除したフィールドを復元 | 削除済みの場合 |
| 削除 | フィールドを論理削除 | - |
| 完全削除 | フィールドを物理削除（DBカラムも削除） | - |

#### 一括アクション
- **一括復元**: 選択したフィールドを一括復元
- **一括削除**: 選択したフィールドを一括論理削除
- **一括完全削除**: 選択したフィールドを一括物理削除（DBカラムも削除）

## 4. フィルタ機能

### 4.1 セレクトフィルタ

| フィルタ名 | フィールド | オプション |
|------------|-----------|-----------|
| タイプ | type | text, textarea, select, checkbox, radio, toggle, checkbox_list, datetime, editor, markdown, color |
| リソース | customizable_type | HasCustomFieldsトレイトを使用しているリソースから動的生成 |

## 5. 通知メッセージ

| 操作 | 種別 | タイトルキー | 本文キー |
|------|------|--------------|----------|
| 復元成功 | success | table.actions.restore.notification.title | table.actions.restore.notification.body |
| 削除成功 | success | table.actions.delete.notification.title | table.actions.delete.notification.body |
| 完全削除成功 | success | table.actions.force-delete.notification.title | table.actions.force-delete.notification.body |
| 一括復元成功 | success | table.bulk-actions.restore.notification.title | table.bulk-actions.restore.notification.body |
| 一括削除成功 | success | table.bulk-actions.delete.notification.title | table.bulk-actions.delete.notification.body |
| 一括完全削除成功 | success | table.bulk-actions.force-delete.notification.title | table.bulk-actions.force-delete.notification.body |

## 6. 画面遷移

### 6.1 遷移元
- メインナビゲーション

### 6.2 遷移先
| 操作 | 遷移先 |
|------|--------|
| 新規作成 | カスタムフィールド作成画面（105） |
| 編集 | カスタムフィールド編集画面（106） |

## 7. 権限・アクセス制御

- システム管理者権限が必要

## 8. 技術仕様

### 8.1 使用コンポーネント
- Filament ListRecords
- Filament Tables
- SelectFilter

### 8.2 特殊機能
- デフォルトソート: created_at DESC
- ソフトデリート対応
- 完全削除時にDBカラムも削除（FieldsColumnManager::deleteColumn）

### 8.3 フィールドタイプ一覧

| タイプ | 説明 |
|--------|------|
| text | テキスト入力 |
| textarea | テキストエリア |
| select | セレクトボックス |
| checkbox | チェックボックス |
| radio | ラジオボタン |
| toggle | トグルスイッチ |
| checkbox_list | チェックボックスリスト |
| datetime | 日時選択 |
| editor | リッチテキストエディタ |
| markdown | Markdownエディタ |
| color | カラーピッカー |

### 8.4 言語ファイル
- `fields::filament/resources/field`

## 9. 特殊処理

### 9.1 完全削除時のカラム削除
```php
ForceDeleteAction::make()
    ->before(function ($record) {
        FieldsColumnManager::deleteColumn($record);
    })
```
- 完全削除前にDBテーブルから対応するカラムを削除
- 一括完全削除時も同様の処理を実行

### 9.2 リソースフィルタの動的生成
```php
SelectFilter::make('customizable_type')
    ->options(fn () => collect(Filament::getResources())
        ->filter(fn ($resource) => in_array('Webkul\Field\Filament\Traits\HasCustomFields', class_uses($resource)))
        ->mapWithKeys(fn ($resource) => [
            $resource::getModel() => str($resource)->afterLast('\\')->toString(),
        ]))
```
- HasCustomFieldsトレイトを使用しているリソースのみを対象としてフィルタオプションを生成
