# 画面設計書: カスタムフィールド作成

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 105 |
| 画面名 | カスタムフィールド作成 |
| 画面種別 | 作成画面 |
| 対応するソースファイル | `plugins/webkul/fields/src/Filament/Resources/FieldResource/Pages/CreateField.php` |
| リソースファイル | `plugins/webkul/fields/src/Filament/Resources/FieldResource.php` |
| 関連モデル | `Webkul\Field\Models\Field` |
| URL | `/admin/fields/create` |

## 2. 画面概要

新しいカスタムフィールドを作成する画面。フィールドの基本情報、タイプ、バリデーション、フォーム設定、テーブル設定、詳細表示設定を定義できる。作成されたフィールドは指定されたリソースに動的に追加される。

## 3. 画面レイアウト

### 3.1 レイアウト構成
- 3カラムレイアウト
- 左側2カラム: メイン設定
- 右側1カラム: サイドバー設定

## 4. 入力フォーム

### 4.1 メインエリア（左側2カラム）

#### 4.1.1 基本セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 最大長 | 備考 |
|--------------|--------|----------|------|--------|------|
| 名前 | name | テキスト入力 | 必須 | 255 | - |
| コード | code | テキスト入力 | 必須 | 255 | 編集時無効化、ユニーク、既存カラム名使用不可、正規表現バリデーション |

- コードのバリデーション: `/^[a-zA-Z_][a-zA-Z0-9_]*$/`
- コードのヘルパーテキスト表示

#### 4.1.2 オプションセクション（条件付き表示）

表示条件: type が select, checkbox_list, radio の場合

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| オプション | options | Repeater | - | シンプルテキスト入力、追加アクションラベルあり |

#### 4.1.3 フォーム設定セクション

| フィールドセット | 内容 |
|------------------|------|
| バリデーション | タイプ別バリデーション設定（Repeater） |
| 追加設定 | タイプ別フォーム設定（Repeater） |

**バリデーションRepeater構成:**
- バリデーション選択（Select）
- フィールド（条件付き表示）
- 値（条件付き表示）

**追加設定Repeater構成:**
- 設定選択（Select）
- 値（設定に応じた入力形式）

#### 4.1.4 テーブル設定セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| テーブルで使用 | use_in_table | トグル | 必須 | ライブ更新 |
| テーブル設定 | table_settings | Repeater | - | use_in_tableがtrueの場合のみ表示 |

#### 4.1.5 詳細表示設定セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| 詳細表示設定 | infolist_settings | Repeater | - | - |

### 4.2 サイドバーエリア（右側1カラム）

#### 4.2.1 設定セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| タイプ | type | セレクト | 必須 | 編集時無効化、検索可能、ネイティブ無効、ライブ更新 |
| 入力タイプ | input_type | セレクト | 必須 | typeがtextの場合のみ表示 |
| 複数選択 | is_multiselect | トグル | 必須 | typeがselectの場合のみ表示 |
| ソート順 | sort | テキスト入力（整数） | 必須 | 最大長255 |

#### 4.2.2 リソースセクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| リソース | customizable_type | セレクト | 必須 | 編集時無効化、検索可能、ネイティブ無効 |

## 5. フィールドタイプ

| タイプ | 説明 |
|--------|------|
| text | テキスト入力 |
| textarea | テキストエリア |
| select | セレクトボックス |
| checkbox | チェックボックス |
| radio | ラジオボタン |
| toggle | トグルスイッチ |
| checkbox_list | チェックボックスリスト |
| datetime | 日時選択 |
| editor | リッチテキストエディタ |
| markdown | Markdownエディタ |
| color | カラーピッカー |

## 6. 入力タイプ（textタイプ選択時）

| 入力タイプ | 説明 |
|------------|------|
| text | 通常テキスト |
| email | メールアドレス |
| numeric | 数値 |
| integer | 整数 |
| password | パスワード |
| tel | 電話番号 |
| url | URL |
| color | 色コード |

## 7. タイプ別バリデーション

### 7.1 共通バリデーション
- gt, gte, lt, lte
- maxSize, minSize, multipleOf
- nullable, prohibited, prohibitedIf, prohibitedUnless, prohibits
- required, requiredIf, requiredIfAccepted, requiredUnless
- requiredWith, requiredWithAll, requiredWithout, requiredWithoutAll
- rules, unique

### 7.2 textタイプ固有
- alphaDash, alphaNum, ascii
- doesntEndWith, doesntStartWith, endsWith, startsWith
- filled, ip, ipv4, ipv6
- length, maxLength, minLength
- macAddress, regex
- ulid, uuid

### 7.3 textareaタイプ固有
- filled, maxLength, minLength

### 7.4 selectタイプ固有
- different, exists, in, notIn, same

### 7.5 checkbox/toggleタイプ固有
- accepted, declined

### 7.6 checkbox_listタイプ固有
- in, maxItems, minItems

### 7.7 datetimeタイプ固有
- after, afterOrEqual, before, beforeOrEqual

### 7.8 editor/markdownタイプ固有
- filled, maxLength, minLength

### 7.9 colorタイプ固有
- hexColor

## 8. 画面遷移

### 8.1 遷移元
| 画面 | 操作 |
|------|------|
| カスタムフィールド一覧（104） | 新規作成ボタン押下 |

### 8.2 遷移先
| 操作 | 遷移先 |
|------|--------|
| 作成完了 | カスタムフィールド一覧（104） |
| キャンセル | カスタムフィールド一覧（104） |

## 9. 権限・アクセス制御

- システム管理者権限が必要

## 10. 技術仕様

### 10.1 使用コンポーネント
- Filament CreateRecord
- Filament Forms
- TextInput, Select, Toggle, Repeater
- Group, Section, Fieldset

### 10.2 リソースオプション生成ロジック
```php
Select::make('customizable_type')
    ->options(fn () => collect(Filament::getResources())
        ->filter(fn ($resource) => in_array('Webkul\Field\Filament\Traits\HasCustomFields', class_uses($resource)))
        ->mapWithKeys(fn ($resource) => [
            $resource::getModel() => str($resource)->afterLast('\\')->toString(),
        ]))
```

### 10.3 コード重複チェックロジック
```php
->notIn(function (Get $get) {
    if ($get('id') || ! $get('customizable_type')) {
        return [];
    }
    $table = app($get('customizable_type'))->getTable();
    return Schema::getColumnListing($table);
})
```

### 10.4 言語ファイル
- `fields::filament/resources/field`

## 11. 備考

- 作成時にDBテーブルに対応するカラムが自動的に追加される
- codeは既存のDBカラム名と重複できない
- codeは英字またはアンダースコアで始まり、英数字とアンダースコアのみ使用可能
