# 画面設計書: カスタムフィールド編集

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 106 |
| 画面名 | カスタムフィールド編集 |
| 画面種別 | 編集画面 |
| 対応するソースファイル | `plugins/webkul/fields/src/Filament/Resources/FieldResource/Pages/EditField.php` |
| リソースファイル | `plugins/webkul/fields/src/Filament/Resources/FieldResource.php` |
| 関連モデル | `Webkul\Field\Models\Field` |
| URL | `/admin/fields/{record}/edit` |

## 2. 画面概要

既存のカスタムフィールドを編集する画面。作成画面と同じフォーム構成だが、一部のフィールド（code, type, customizable_type）は変更不可。フィールドの設定、バリデーション、表示オプションを更新できる。

## 3. 画面レイアウト

### 3.1 レイアウト構成
- 3カラムレイアウト
- 左側2カラム: メイン設定
- 右側1カラム: サイドバー設定

## 4. 入力フォーム

### 4.1 メインエリア（左側2カラム）

#### 4.1.1 基本セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 最大長 | 編集可否 |
|--------------|--------|----------|------|--------|----------|
| 名前 | name | テキスト入力 | 必須 | 255 | 可 |
| コード | code | テキスト入力 | 必須 | 255 | **不可** |

- codeは編集時に無効化される（disabledOn: 'edit'）

#### 4.1.2 オプションセクション（条件付き表示）

表示条件: type が select, checkbox_list, radio の場合

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| オプション | options | Repeater | - | オプション値の追加・編集・削除 |

#### 4.1.3 フォーム設定セクション

| フィールドセット | 内容 |
|------------------|------|
| バリデーション | タイプ別バリデーション設定（Repeater） |
| 追加設定 | タイプ別フォーム設定（Repeater） |

#### 4.1.4 テーブル設定セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| テーブルで使用 | use_in_table | トグル | 必須 | ライブ更新 |
| テーブル設定 | table_settings | Repeater | - | use_in_tableがtrueの場合のみ表示 |

#### 4.1.5 詳細表示設定セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| 詳細表示設定 | infolist_settings | Repeater | - | - |

### 4.2 サイドバーエリア（右側1カラム）

#### 4.2.1 設定セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 編集可否 |
|--------------|--------|----------|------|----------|
| タイプ | type | セレクト | 必須 | **不可** |
| 入力タイプ | input_type | セレクト | 必須 | **不可**（typeがtextの場合のみ表示） |
| 複数選択 | is_multiselect | トグル | 必須 | 可（typeがselectの場合のみ表示） |
| ソート順 | sort | テキスト入力（整数） | 必須 | 可 |

#### 4.2.2 リソースセクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 編集可否 |
|--------------|--------|----------|------|----------|
| リソース | customizable_type | セレクト | 必須 | **不可** |

## 5. 編集不可フィールド

以下のフィールドは作成後に変更できません：

| フィールド | 理由 |
|------------|------|
| code | DBカラム名として使用されるため |
| type | フィールドタイプ変更はデータ整合性に影響するため |
| input_type | textタイプの入力形式変更は影響があるため |
| customizable_type | 関連するリソース変更はデータ整合性に影響するため |

## 6. 編集可能な設定

### 6.1 基本設定
- フィールド名（name）
- ソート順（sort）
- 複数選択（is_multiselect）※selectタイプのみ

### 6.2 オプション設定
- オプション値の追加・編集・削除（select, checkbox_list, radioタイプ）

### 6.3 バリデーション設定
- 各種バリデーションルールの追加・編集・削除

### 6.4 フォーム表示設定
- プレースホルダー、ヘルパーテキスト、ヒントなど

### 6.5 テーブル表示設定
- テーブルでの表示有無
- 表示形式、色、アイコンなど

### 6.6 詳細表示設定
- 詳細画面での表示形式、色、アイコンなど

## 7. 画面遷移

### 7.1 遷移元
| 画面 | 操作 |
|------|------|
| カスタムフィールド一覧（104） | 編集アクション押下 |

### 7.2 遷移先
| 操作 | 遷移先 |
|------|--------|
| 保存 | カスタムフィールド一覧（104） |
| キャンセル | カスタムフィールド一覧（104） |

## 8. 権限・アクセス制御

- システム管理者権限が必要
- 論理削除済みのフィールドは編集画面にアクセス不可

## 9. 技術仕様

### 9.1 使用コンポーネント
- Filament EditRecord
- Filament Forms
- TextInput, Select, Toggle, Repeater
- Group, Section, Fieldset

### 9.2 無効化実装
```php
TextInput::make('code')
    ->disabledOn('edit')

Select::make('type')
    ->disabledOn('edit')

Select::make('customizable_type')
    ->disabledOn('edit')
```

### 9.3 言語ファイル
- `fields::filament/resources/field`

## 10. 備考

- フィールドタイプの変更が必要な場合は、既存フィールドを削除して新規作成する必要がある
- codeやtypeの変更は既存データに影響を与える可能性があるため、意図的に無効化されている
- 編集画面は作成画面と同じformメソッドを共有し、disabledOn('edit')で制御
