# 画面設計書: 倉庫一覧

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 107 |
| 画面名 | 倉庫一覧 |
| 画面種別 | 一覧画面 |
| 対応するソースファイル | `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource/Pages/ListWarehouses.php` |
| リソースファイル | `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource.php` |
| 関連モデル | `Webkul\Inventory\Models\Warehouse` |
| URL | `/admin/inventories/configurations/warehouses` |

## 2. 画面概要

在庫管理システムの倉庫を一覧表示・管理する画面。倉庫のCRUD操作（作成・参照・更新・削除）、検索・フィルタリング・グループ化機能を提供する。ソフトデリート対応。カスタムフィールドにも対応。

## 3. 画面レイアウト

### 3.1 ヘッダー部
- 画面タイトル: Warehouses（倉庫）
- ナビゲーションアイコン: heroicon-o-building-storefront
- ナビゲーションソート: 1
- クラスター: Configurations

### 3.2 テーブル表示部

| カラム名 | フィールド | 表示形式 | 検索可否 | ソート可否 | デフォルト表示 |
|----------|-----------|----------|----------|------------|----------------|
| 名前 | name | テキスト | 可 | - | 表示 |
| コード | code | テキスト | 可 | - | 表示 |
| 会社 | company.name | テキスト | - | 可 | 表示 |
| 住所 | partnerAddress.name | テキスト | - | 可 | 表示 |
| 削除日時 | deleted_at | 日時 | - | 可 | 非表示 |
| 作成日時 | created_at | 日時 | - | 可 | 非表示 |
| 更新日時 | updated_at | 日時 | - | 可 | 非表示 |

### 3.3 アクション部

#### ヘッダーアクション
- **新規作成**: 倉庫作成画面へ遷移

#### 行アクション
| アクション | 説明 | 条件 |
|------------|------|------|
| 表示 | 倉庫詳細画面へ遷移 | 削除済みでない場合 |
| 編集 | 倉庫編集画面へ遷移 | 削除済みでない場合 |
| 復元 | 削除した倉庫を復元 | 削除済みの場合 |
| 削除 | 倉庫を論理削除 | - |
| 完全削除 | 倉庫を物理削除 | 削除済みの場合 |

#### 一括アクション
- **一括復元**: 選択した倉庫を一括復元
- **一括削除**: 選択した倉庫を一括論理削除
- **一括完全削除**: 選択した倉庫を一括物理削除

#### 空状態アクション
- **作成**: 新規倉庫作成画面へ遷移（アイコン: heroicon-o-plus-circle）

## 4. フィルタ機能

### 4.1 セレクトフィルタ

| フィルタ名 | フィールド | リレーション |
|------------|-----------|--------------|
| 会社 | company_id | company (name) |

検索可能・プリロード設定あり。

## 5. グループ化機能

| グループ名 | フィールド | 折りたたみ可否 |
|------------|-----------|----------------|
| 会社 | company.name | 可 |
| 作成日時 | created_at | 可 |
| 更新日時 | updated_at | 可（日付グループ） |

## 6. 通知メッセージ

| 操作 | 種別 | タイトルキー | 本文キー |
|------|------|--------------|----------|
| 復元成功 | success | table.actions.restore.notification.title | table.actions.restore.notification.body |
| 削除成功 | success | table.actions.delete.notification.title | table.actions.delete.notification.body |
| 完全削除成功 | success | table.actions.force-delete.notification.success.title | table.actions.force-delete.notification.success.body |
| 完全削除エラー | danger | table.actions.force-delete.notification.error.title | table.actions.force-delete.notification.error.body |
| 一括復元成功 | success | table.bulk-actions.restore.notification.title | table.bulk-actions.restore.notification.body |
| 一括削除成功 | success | table.bulk-actions.delete.notification.title | table.bulk-actions.delete.notification.body |
| 一括完全削除成功 | success | table.bulk-actions.force-delete.notification.success.title | table.bulk-actions.force-delete.notification.success.body |
| 一括完全削除エラー | danger | table.bulk-actions.force-delete.notification.error.title | table.bulk-actions.force-delete.notification.error.body |

## 7. 画面遷移

### 7.1 遷移元
- 在庫設定メニュー

### 7.2 遷移先
| 操作 | 遷移先 |
|------|--------|
| 新規作成 | 倉庫作成画面（108） |
| 表示 | 倉庫詳細画面（110） |
| 編集 | 倉庫編集画面（109） |

## 8. 権限・アクセス制御

- 在庫設定クラスターへのアクセス権限が必要

## 9. 技術仕様

### 9.1 使用コンポーネント
- Filament ListRecords
- Filament Tables
- SelectFilter

### 9.2 特殊機能
- カラム並べ替え可能（reorderableColumns）
- ソフトデリート対応
- レコードタイトル属性: name
- グローバル検索無効（isGloballySearchable: false）
- サブナビゲーション位置: Start（一覧表示時）

### 9.3 完全削除時のエラーハンドリング
```php
ForceDeleteAction::make()
    ->action(function (Warehouse $record, $action) {
        try {
            $record->forceDelete();
        } catch (QueryException $e) {
            Notification::make()
                ->danger()
                ->title(...)
                ->body(...)
                ->send();
        }
    })
```
- 外部キー制約などでエラーが発生した場合、エラー通知を表示

### 9.4 カスタムフィールド対応
- HasCustomFieldsトレイトを使用
- カスタムフィールドをフォームに追加可能

### 9.5 言語ファイル
- `inventories::filament/clusters/configurations/resources/warehouse`

## 10. サブナビゲーション

一覧画面ではサブナビゲーション位置がStartに設定される。詳細・編集画面ではTopに切り替わる。

### サブナビゲーション項目
- 詳細（ViewWarehouse）
- 編集（EditWarehouse）
- ルート管理（ManageRoutes）
