# 画面設計書: 倉庫作成

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 108 |
| 画面名 | 倉庫作成 |
| 画面種別 | 作成画面 |
| 対応するソースファイル | `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource/Pages/CreateWarehouse.php` |
| リソースファイル | `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource.php` |
| 関連モデル | `Webkul\Inventory\Models\Warehouse` |
| URL | `/admin/inventories/configurations/warehouses/create` |

## 2. 画面概要

新しい倉庫を作成する画面。倉庫の基本情報（名前、コード、会社、住所）と出荷管理設定（入荷・出荷ステップ、補充元倉庫）を定義できる。設定に応じて条件付きでフィールドが表示される。

## 3. 画面レイアウト

### 3.1 レイアウト構成
- 3カラムレイアウト
- 左側2カラム: 基本情報・追加情報
- 右側1カラム: 設定セクション（条件付き表示）

## 4. 入力フォーム

### 4.1 左側エリア（2カラム）

#### 4.1.1 基本セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 最大長 | 備考 |
|--------------|--------|----------|------|--------|------|
| 名前 | name | テキスト入力 | 必須 | 255 | オートフォーカス、プレースホルダーあり、ユニーク、スタイル設定（大きいフォント） |
| コード | code | テキスト入力 | 必須 | 255 | プレースホルダーあり、ヒントツールチップあり、ユニーク |
| 会社 | company_id | セレクト | 必須 | - | companyリレーション、ログインユーザーのデフォルト会社で固定可能 |
| 住所 | partner_address_id | セレクト | - | - | partnerAddressリレーション、検索可能、プリロード、作成オプション付き |

**会社フィールドの特殊処理:**
- ログインユーザーにdefault_company_idが設定されている場合は無効化
- デフォルト値としてログインユーザーのdefault_company_idを設定

**住所フィールドの作成オプション:**
- PartnerResourceのフォームを使用して新規パートナー（住所）を作成可能

#### 4.1.2 追加情報セクション（条件付き表示）

表示条件: カスタムフィールドが定義されている場合

- カスタムフィールドを動的に表示

### 4.2 右側エリア（1カラム）- 条件付き表示

表示条件: WarehouseSettings.enable_multi_steps_routes が true の場合

#### 4.2.1 設定セクション

##### 出荷管理フィールドセット

| フィールド名 | 項目ID | 入力形式 | 必須 | デフォルト | 備考 |
|--------------|--------|----------|------|------------|------|
| 入荷ステップ | reception_steps | ラジオボタン | - | ONE_STEP | ReceptionStepEnum、ヒントツールチップあり |
| 出荷ステップ | delivery_steps | ラジオボタン | - | ONE_STEP | DeliveryStepEnum、ヒントツールチップあり |

表示条件: WarehouseSettings.enable_multi_steps_routes が true

##### 補充管理フィールドセット

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| 補充元倉庫 | supplierWarehouses | チェックボックスリスト | - | supplierWarehousesリレーション |

表示条件: 既存の倉庫が2つ以上ある場合（Warehouse::count() > 1）

## 5. 入荷ステップ（ReceptionStep）

| 値 | 説明 |
|----|------|
| ONE_STEP | 1ステップ（直接入荷） |
| TWO_STEPS | 2ステップ（入荷→在庫） |
| THREE_STEPS | 3ステップ（入荷→品質検査→在庫） |

## 6. 出荷ステップ（DeliveryStep）

| 値 | 説明 |
|----|------|
| ONE_STEP | 1ステップ（直接出荷） |
| TWO_STEPS | 2ステップ（在庫→出荷） |
| THREE_STEPS | 3ステップ（在庫→梱包→出荷） |

## 7. 画面遷移

### 7.1 遷移元
| 画面 | 操作 |
|------|------|
| 倉庫一覧（107） | 新規作成ボタン押下 |
| 倉庫一覧（107） | 空状態の作成ボタン押下 |

### 7.2 遷移先
| 操作 | 遷移先 |
|------|--------|
| 作成完了 | 倉庫一覧（107） または 倉庫詳細（110） |
| キャンセル | 倉庫一覧（107） |

## 8. 権限・アクセス制御

- 在庫設定クラスターへのアクセス権限が必要
- 会社フィールドはユーザーのデフォルト会社設定に従う

## 9. 技術仕様

### 9.1 使用コンポーネント
- Filament CreateRecord
- Filament Forms
- TextInput, Select, Radio, CheckboxList
- Group, Section, Fieldset

### 9.2 条件付き表示ロジック

```php
// 設定セクション全体
->visible(static::getWarehouseSettings()->enable_multi_steps_routes)

// 出荷管理フィールドセット
->visible(static::getWarehouseSettings()->enable_multi_steps_routes)

// 補充管理フィールドセット
->visible(Warehouse::count() > 1)
```

### 9.3 倉庫設定の取得
```php
static public function getWarehouseSettings(): WarehouseSettings
{
    return once(fn () => app(WarehouseSettings::class));
}
```

### 9.4 カスタムフィールド対応
```php
Section::make(__('...additional...'))
    ->visible(! empty($customFormFields = static::getCustomFormFields()))
    ->schema($customFormFields)
```

### 9.5 言語ファイル
- `inventories::filament/clusters/configurations/resources/warehouse`

## 10. 備考

- 名前とコードはシステム全体でユニーク
- 会社フィールドは組織管理の一環として制御される
- マルチステップルートが有効な場合のみ、入荷・出荷ステップ設定が表示される
- 補充元倉庫の設定は、複数の倉庫が存在する場合のみ可能
