# 画面設計書: 倉庫編集

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 109 |
| 画面名 | 倉庫編集 |
| 画面種別 | 編集画面 |
| 対応するソースファイル | `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource/Pages/EditWarehouse.php` |
| リソースファイル | `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource.php` |
| 関連モデル | `Webkul\Inventory\Models\Warehouse` |
| URL | `/admin/inventories/configurations/warehouses/{record}/edit` |

## 2. 画面概要

既存の倉庫情報を編集する画面。作成画面と同じフォーム構成を持ち、倉庫の基本情報と出荷管理設定を変更できる。サブナビゲーションにより詳細画面・ルート管理画面への遷移が可能。

## 3. 画面レイアウト

### 3.1 サブナビゲーション
- 位置: Top
- 項目:
  - 詳細（ViewWarehouse）
  - 編集（EditWarehouse）- 現在のページ
  - ルート管理（ManageRoutes）

### 3.2 レイアウト構成
- 3カラムレイアウト
- 左側2カラム: 基本情報・追加情報
- 右側1カラム: 設定セクション（条件付き表示）

## 4. 入力フォーム

### 4.1 左側エリア（2カラム）

#### 4.1.1 基本セクション

| フィールド名 | 項目ID | 入力形式 | 必須 | 最大長 | 備考 |
|--------------|--------|----------|------|--------|------|
| 名前 | name | テキスト入力 | 必須 | 255 | オートフォーカス、ユニーク |
| コード | code | テキスト入力 | 必須 | 255 | ユニーク、ヒントツールチップあり |
| 会社 | company_id | セレクト | 必須 | - | ログインユーザーのデフォルト会社で固定可能 |
| 住所 | partner_address_id | セレクト | - | - | 検索可能、プリロード、作成オプション付き |

#### 4.1.2 追加情報セクション（条件付き表示）

表示条件: カスタムフィールドが定義されている場合

- カスタムフィールドを動的に表示

### 4.2 右側エリア（1カラム）- 条件付き表示

表示条件: WarehouseSettings.enable_multi_steps_routes が true の場合

#### 4.2.1 設定セクション

##### 出荷管理フィールドセット

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| 入荷ステップ | reception_steps | ラジオボタン | - | ReceptionStepEnum、ヒントツールチップあり |
| 出荷ステップ | delivery_steps | ラジオボタン | - | DeliveryStepEnum、ヒントツールチップあり |

表示条件: WarehouseSettings.enable_multi_steps_routes が true

##### 補充管理フィールドセット

| フィールド名 | 項目ID | 入力形式 | 必須 | 備考 |
|--------------|--------|----------|------|------|
| 補充元倉庫 | supplierWarehouses | チェックボックスリスト | - | supplierWarehousesリレーション |

表示条件: 既存の倉庫が2つ以上ある場合

## 5. 作成画面との差異

| 項目 | 作成画面 | 編集画面 |
|------|----------|----------|
| サブナビゲーション | なし | あり（Top位置） |
| 名前・コードのデフォルト値 | なし | 既存データから読み込み |
| 会社フィールド | デフォルト会社設定 | 既存データまたはデフォルト会社 |
| 入荷・出荷ステップ | デフォルト: ONE_STEP | 既存データから読み込み |
| 補充元倉庫 | 空 | 既存の関連データから読み込み |

## 6. 画面遷移

### 6.1 遷移元
| 画面 | 操作 |
|------|------|
| 倉庫一覧（107） | 編集アクション押下 |
| 倉庫詳細（110） | サブナビゲーション「編集」押下 |
| ルート管理 | サブナビゲーション「編集」押下 |

### 6.2 遷移先
| 操作 | 遷移先 |
|------|--------|
| 保存 | 倉庫詳細（110） または 倉庫一覧（107） |
| キャンセル | 遷移元に戻る |
| サブナビ「詳細」 | 倉庫詳細（110） |
| サブナビ「ルート」 | ルート管理画面 |

## 7. 権限・アクセス制御

- 在庫設定クラスターへのアクセス権限が必要
- 論理削除済みの倉庫は編集不可（一覧画面で非表示）

## 8. 技術仕様

### 8.1 使用コンポーネント
- Filament EditRecord
- Filament Forms
- TextInput, Select, Radio, CheckboxList
- Group, Section, Fieldset

### 8.2 サブナビゲーション
```php
public static function getRecordSubNavigation(Page $page): array
{
    return $page->generateNavigationItems([
        ViewWarehouse::class,
        EditWarehouse::class,
        ManageRoutes::class,
    ]);
}
```

### 8.3 サブナビゲーション位置
```php
public static function getSubNavigationPosition(): SubNavigationPosition
{
    // 一覧画面以外ではTop
    return SubNavigationPosition::Top;
}
```

### 8.4 フォーム共有
- 作成画面と編集画面は同じformメソッドを使用
- 特別な編集時制限（disabledOn）は設定されていない

### 8.5 言語ファイル
- `inventories::filament/clusters/configurations/resources/warehouse`

## 9. 備考

- 編集画面と作成画面はほぼ同一のフォーム構成
- サブナビゲーションにより関連画面への素早いアクセスが可能
- 名前とコードの一意性は編集時も検証される（ignoreRecord: trueにより自身を除外）
