# 画面設計書 11-現金丸め一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける「現金丸め一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

現金丸め一覧画面は、会計モジュールにおいて現金取引時の端数処理ルールを管理するための画面である。

**業務上の目的・背景**：現金取引において、最小通貨単位未満の金額を処理する必要がある。例えば、日本円では1円未満の端数は存在しないが、海外通貨や特定の業務要件によっては端数処理が必要となる。本画面は、これらの現金丸め設定を一元管理し、請求書や支払処理時に適切な端数処理を自動適用するための基盤を提供する。

**画面へのアクセス方法**：会計モジュールの設定メニューから「現金丸め」を選択してアクセスする。ナビゲーションには直接表示されない設定画面（shouldRegisterNavigation = false）であるため、設定画面経由でのアクセスとなる。

**主要な操作・処理内容**：
1. 現金丸め設定の一覧表示（名前、丸め戦略、丸め方法、作成者でのソート・検索）
2. 新規現金丸め設定の作成（ヘッダーの「作成」ボタン）
3. 既存設定の詳細表示・編集・削除（各行のアクション）
4. 複数設定の一括削除（バルクアクション）
5. グループ化表示（名前、丸め戦略、丸め方法、作成者別）

**画面遷移**：
- 現金丸め作成画面へ遷移可能（作成ボタン）
- 現金丸め詳細画面へ遷移可能（表示アクション）
- 現金丸め編集画面へ遷移可能（編集アクション）

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、リソースへのアクセス権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-015 | 現金端数処理管理 | 主機能 | 現金丸め設定のCRUD操作全般 |
| FN-ACC-028 | 現金端数処理管理 | 主機能 | 作成/編集/削除 |

## 画面種別

一覧

## URL/ルーティング

`/admin/accounts/cash-roundings`

## 画面構成

1. **ヘッダーエリア**
   - ページタイトル
   - 「作成」ボタン（heroicon-o-plus-circleアイコン付き）

2. **テーブルエリア**
   - カラム：名前、丸め戦略、丸め方法、作成者
   - 各行アクション：表示、編集、削除
   - グループ化機能
   - 検索・ソート機能

3. **バルクアクションエリア**
   - 一括削除機能

## 入出力項目

該当なし（一覧画面のため入力項目なし）

## 表示項目

| 項目名 | 物理名 | データ型 | 説明 |
|--------|--------|----------|------|
| 名前 | name | string | 現金丸め設定の名称 |
| 丸め戦略 | strategy | enum | 丸め戦略（BIGGEST_TAX等） |
| 丸め方法 | rounding_method | enum | 丸め方法（HALF_UP等） |
| 作成者 | createdBy.name | string | 設定を作成したユーザー名 |

## イベント仕様

### 1-作成ボタン押下

ヘッダーの「作成」ボタン押下時、現金丸め作成画面（CreateCashRounding）へ遷移する。

### 2-表示アクション

各行の「表示」アクション選択時、該当レコードの詳細画面（ViewCashRounding）へ遷移する。

### 3-編集アクション

各行の「編集」アクション選択時、該当レコードの編集画面（EditCashRounding）へ遷移する。

### 4-削除アクション

各行の「削除」アクション選択時、確認後にレコードを削除し、成功通知を表示する。

### 5-一括削除

バルクアクションの「削除」選択時、選択された複数レコードを一括削除し、成功通知を表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | accounts_cash_roundings | DELETE | 選択レコードの削除 |
| 一括削除 | accounts_cash_roundings | DELETE | 複数レコードの一括削除 |

### テーブル別更新項目詳細

#### accounts_cash_roundings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = 選択ID | 物理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 削除成功通知（タイトル・本文） | 削除アクション成功時 |
| 成功 | 一括削除成功通知（タイトル・本文） | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データなし | 空のテーブルを表示 |
| 権限不足 | Filament標準の権限エラー表示 |

## 備考

- 丸め戦略（RoundingStrategy）とし丸め方法（RoundingMethod）はEnumで定義されており、表示時は`options()`メソッドで取得したラベルに変換される
- ナビゲーションに直接表示されない設定画面であるため、会計モジュールの設定メニューからアクセスする
