# 画面設計書: 倉庫詳細

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 110 |
| 画面名 | 倉庫詳細 |
| 画面種別 | 詳細画面（ViewRecord） |
| 対応するソースファイル | `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource/Pages/ViewWarehouse.php` |
| リソースファイル | `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource.php` |
| 関連モデル | `Webkul\Inventory\Models\Warehouse` |
| URL | `/admin/inventories/configurations/warehouses/{record}` |

## 2. 画面概要

倉庫の詳細情報を表示する画面。基本情報、出荷設定、レコード情報を3カラムレイアウトで表示する。サブナビゲーションにより編集画面・ルート管理画面への遷移が可能。

## 3. 画面レイアウト

### 3.1 サブナビゲーション
- 位置: Top
- 項目:
  - 詳細（ViewWarehouse）- 現在のページ
  - 編集（EditWarehouse）
  - ルート管理（ManageRoutes）

### 3.2 レイアウト構成
- 3カラムレイアウト
- 左側2カラム: 基本情報・設定情報
- 右側1カラム: レコード情報

## 4. 表示内容

### 4.1 左側エリア（2カラム）

#### 4.1.1 基本情報セクション

| 表示項目 | フィールド | アイコン | サイズ/スタイル |
|----------|-----------|----------|-----------------|
| 名前 | name | heroicon-o-building-storefront | Large, Bold |
| コード | code | heroicon-m-hashtag | - |
| 会社 | company.name | heroicon-o-building-office | - |
| 住所 | partnerAddress.name | heroicon-o-map | - |

**名前フィールドの特殊スタイル:**
- サイズ: TextSize::Large
- フォントウェイト: FontWeight::Bold

**会社・住所フィールドのグループ:**
- 2カラムレイアウト

#### 4.1.2 設定セクション

##### 出荷管理フィールドセット

| 表示項目 | フィールド | アイコン |
|----------|-----------|----------|
| 入荷ステップ | reception_steps | heroicon-o-truck |
| 出荷ステップ | delivery_steps | heroicon-o-paper-airplane |

##### 補充管理フィールドセット

| 表示項目 | フィールド | アイコン | プレースホルダー |
|----------|-----------|----------|------------------|
| 補充元倉庫 | supplierWarehouses.name | heroicon-o-arrow-path | - |

### 4.2 右側エリア（1カラム）

#### 4.2.1 レコード情報セクション

| 表示項目 | フィールド | 表示形式 | アイコン |
|----------|-----------|----------|----------|
| 作成日時 | created_at | 日時 | heroicon-m-calendar |
| 作成者 | creator.name | テキスト | heroicon-m-user |
| 最終更新日時 | updated_at | 日時 | heroicon-m-calendar-days |

## 5. 画面遷移

### 5.1 遷移元
| 画面 | 操作 |
|------|------|
| 倉庫一覧（107） | 表示アクション押下 |
| 倉庫編集（109） | サブナビゲーション「詳細」押下 |
| ルート管理 | サブナビゲーション「詳細」押下 |

### 5.2 遷移先
| 操作 | 遷移先 |
|------|--------|
| サブナビ「編集」 | 倉庫編集（109） |
| サブナビ「ルート」 | ルート管理画面 |
| 戻る | 倉庫一覧（107） |

## 6. 権限・アクセス制御

- 在庫設定クラスターへのアクセス権限が必要
- 論理削除済みの倉庫は詳細表示不可（一覧画面でViewAction非表示）

## 7. 技術仕様

### 7.1 使用コンポーネント
- Filament ViewRecord
- Filament Infolists
- TextEntry
- Group, Section, Fieldset

### 7.2 Infolist定義
```php
public static function infolist(Schema $schema): Schema
{
    return $schema
        ->components([
            Group::make()
                ->schema([
                    Section::make(__('...general...'))
                        ->schema([...]),
                    Section::make(__('...settings...'))
                        ->schema([...]),
                ])
                ->columnSpan(['lg' => 2]),
            Group::make()
                ->schema([
                    Section::make(__('...record-information...'))
                        ->schema([...]),
                ])
                ->columnSpan(['lg' => 1]),
        ])
        ->columns(3);
}
```

### 7.3 サブナビゲーション
```php
public static function getRecordSubNavigation(Page $page): array
{
    return $page->generateNavigationItems([
        ViewWarehouse::class,
        EditWarehouse::class,
        ManageRoutes::class,
    ]);
}
```

### 7.4 言語ファイル
- `inventories::filament/clusters/configurations/resources/warehouse`

## 8. 表示形式詳細

### 8.1 日時フィールド
- `->dateTime()` メソッドにより日時形式で表示

### 8.2 アイコン表示
- 各TextEntryに適切なアイコンを設定
- Heroiconsを使用

### 8.3 プレースホルダー
- 補充元倉庫フィールドに `->placeholder('—')` を設定
- データがない場合はダッシュを表示

## 9. 備考

- 詳細画面は読み取り専用
- サブナビゲーションにより関連画面への素早いアクセスが可能
- 設定セクションはフォーム画面の条件付き表示とは独立して常に表示
- レコード情報セクションで監査情報を確認可能
