# 画面設計書 111-倉庫ルート管理

## 概要

本ドキュメントは、Aureus ERPシステムにおける「倉庫ルート管理」画面の設計仕様を定義したものです。

### 本画面の処理概要

倉庫ルート管理画面は、特定の倉庫に関連付けられたルート情報を管理するための画面です。

**業務上の目的・背景**：在庫管理において、商品の移動経路（ルート）を倉庫単位で管理することで、入出庫や内部移動の効率化を図ります。この画面により、倉庫ごとにどのルートが適用されるかを一元管理でき、マルチステップルート機能が有効な場合に複雑な在庫フローを構築できます。

**画面へのアクセス方法**：在庫モジュール > 設定 > 倉庫 > 倉庫詳細画面 > サブナビゲーション「ルート」タブをクリック

**主要な操作・処理内容**：
1. 倉庫に関連付けられたルートの一覧表示
2. 新規ルートの作成（倉庫IDが自動設定される）
3. 既存ルートの編集・削除
4. ルートの表示・復元操作

**画面遷移**：
- 遷移元：倉庫詳細画面、倉庫編集画面
- 遷移先：ルート詳細画面、ルート編集画面

**権限による表示制御**：マルチステップルート機能（enable_multi_steps_routes）が有効な場合のみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-023 | 倉庫管理 | 主機能 | 倉庫レコードへのルート関連付け |
| FN-INV-026 | ルート管理 | 主機能 | ルートCRUD操作 |

## 画面種別

関連レコード管理（ManageRelatedRecords）

## URL/ルーティング

`/inventories/configurations/warehouses/{record}/routes`

## 画面構成

- ヘッダー部：サブナビゲーションタブ（詳細、編集、ルート）
- メイン部：
  - ヘッダーアクション：新規作成ボタン
  - データテーブル：ルート一覧
- アクションボタン：表示、編集、復元、削除、完全削除

## 入出力項目

### ルート作成・編集フォーム

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ルート名 | name | string | ○ | ルートの名称（最大255文字） |
| 会社 | company_id | select | - | 所属会社 |
| 商品カテゴリで選択可能 | product_category_selectable | boolean | - | 商品カテゴリに適用するか |
| 商品で選択可能 | product_selectable | boolean | - | 商品に適用するか |
| パッケージングで選択可能 | packaging_selectable | boolean | - | パッケージングに適用するか |

## 表示項目

### テーブルカラム

| 項目名 | 項目ID | 型 | ソート | 検索 | 説明 |
|--------|--------|-----|--------|------|------|
| ルート名 | name | string | - | ○ | ルートの名称 |
| 会社 | company.name | string | - | ○ | 所属会社名 |
| 削除日時 | deleted_at | datetime | ○ | - | 論理削除日時（非表示） |
| 作成日時 | created_at | datetime | ○ | - | レコード作成日時（非表示） |
| 更新日時 | updated_at | datetime | ○ | - | レコード更新日時（非表示） |

## イベント仕様

### 1-新規作成ボタン押下

- warehouse_selectableをtrueに設定
- 現在の倉庫IDを倉庫リストに自動設定
- creator_idにログインユーザーIDを設定
- company_idにユーザーのデフォルト会社IDを設定
- 作成成功時に成功通知を表示

### 2-行アクション

- 表示：詳細画面への遷移（削除済みレコードは非表示）
- 編集：編集画面への遷移（削除済みレコードは非表示）
- 復元：論理削除レコードの復元
- 削除：論理削除
- 完全削除：物理削除（外部キー制約エラー時はエラー通知）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | inventories_routes | INSERT | ルートレコードの追加 |
| 新規作成 | inventories_route_warehouses | INSERT | 倉庫との関連付け |
| 編集 | inventories_routes | UPDATE | ルート情報の更新 |
| 削除 | inventories_routes | UPDATE | deleted_atに日時を設定 |
| 復元 | inventories_routes | UPDATE | deleted_atをnullに設定 |
| 完全削除 | inventories_routes | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### inventories_routes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | warehouse_selectable | true | 自動設定 |
| INSERT | company_id | フォーム入力値またはユーザーデフォルト | - |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| UPDATE | deleted_at | null/現在日時 | 復元/削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| create.success | 成功 | ルートが正常に作成されました | 作成成功時 |
| edit.success | 成功 | ルートが正常に更新されました | 更新成功時 |
| delete.success | 成功 | ルートが正常に削除されました | 削除成功時 |
| restore.success | 成功 | ルートが正常に復元されました | 復元成功時 |
| force-delete.error | エラー | 関連するデータがあるため削除できません | 外部キー制約エラー時 |

## 例外処理

- 外部キー制約違反時：エラー通知を表示し、完全削除を中断
- 認証エラー：ログイン画面へリダイレクト
- マルチステップルート機能無効時：画面自体が非表示（アクセス不可）

## 備考

- 本画面はWarehouseResourceのサブナビゲーションとして機能
- RouteResourceのフォーム定義とテーブル定義を再利用
- ManageRoutesページクラスでwarehouse_selectableの設定を隠す処理を実施
