# 画面設計書 112-ルート一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ルート一覧」画面の設計仕様を定義したものです。

### 本画面の処理概要

ルート一覧画面は、在庫管理における商品移動経路（ルート）を一覧表示・管理するための画面です。

**業務上の目的・背景**：在庫管理において、商品の入出庫や内部移動の経路を体系的に管理する必要があります。ルートは商品カテゴリ、商品、パッケージング、倉庫に対して適用でき、マルチステップの在庫フローを実現します。この画面でルートを一元管理することで、複雑な物流オペレーションを効率的に構築できます。

**画面へのアクセス方法**：在庫モジュール > 設定 > ルート一覧（サイドナビゲーション）

**主要な操作・処理内容**：
1. ルートの一覧表示（検索、フィルター、ソート）
2. 新規ルートの作成
3. 既存ルートの表示・編集・削除
4. 削除済みルートの表示（アーカイブタブ）と復元
5. ルートの並び順変更（ドラッグ&ドロップ）

**画面遷移**：
- 遷移元：ダッシュボード、倉庫設定画面
- 遷移先：ルート作成画面、ルート詳細画面、ルート編集画面

**権限による表示制御**：マルチステップルート機能（enable_multi_steps_routes）が有効な場合のみナビゲーションに表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-026 | ルート管理 | 主機能 | ルートCRUD操作、一覧表示 |
| FN-INV-027 | ルール管理 | 遷移先機能 | ルートに紐づくルール管理への遷移 |

## 画面種別

一覧（ListRecords）

## URL/ルーティング

`/inventories/configurations/routes`

## 画面構成

- ヘッダー部：
  - ページタイトル
  - 新規作成ボタン
- タブ部：
  - 全て（all）タブ：有効なルートを表示
  - アーカイブ済み（archived）タブ：論理削除済みルートを表示
- メイン部：
  - フィルター：会社
  - データテーブル：ルート一覧
- フッター部：ページネーション

## 入出力項目

### フィルター

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 会社 | company_id | select | 会社による絞り込み |

## 表示項目

### テーブルカラム

| 項目名 | 項目ID | 型 | ソート | 検索 | 説明 |
|--------|--------|-----|--------|------|------|
| ルート名 | name | string | - | ○ | ルートの名称 |
| 会社 | company.name | string | - | ○ | 所属会社名 |
| 削除日時 | deleted_at | datetime | ○ | - | 論理削除日時（デフォルト非表示） |
| 作成日時 | created_at | datetime | ○ | - | レコード作成日時（デフォルト非表示） |
| 更新日時 | updated_at | datetime | ○ | - | レコード更新日時（デフォルト非表示） |

### タブバッジ

| タブ名 | バッジ内容 |
|--------|-----------|
| 全て | Route::count() - 有効なルート総数 |
| アーカイブ済み | Route::onlyTrashed()->count() - 削除済みルート数 |

## イベント仕様

### 1-新規作成ボタン押下

- ルート作成画面へ遷移
- creator_idにログインユーザーIDを設定
- company_idにユーザーのデフォルト会社IDを設定
- 作成成功時に成功通知を表示

### 2-行アクション

- 表示：ルート詳細画面への遷移（削除済みレコードは非表示）
- 編集：ルート編集画面への遷移（削除済みレコードは非表示）
- 復元：論理削除レコードの復元（成功通知表示）
- 削除：論理削除（成功通知表示）
- 完全削除：物理削除（外部キー制約エラー時はエラー通知）

### 3-一括アクション

- 復元：選択したレコードを一括復元
- 削除：選択したレコードを一括論理削除
- 完全削除：選択したレコードを一括物理削除

### 4-並び替え

- テーブル行のドラッグ&ドロップでsortカラムを更新
- デフォルトはsort降順でソート

### 5-タブ切り替え

- 「アーカイブ済み」タブ選択時：onlyTrashed()クエリを適用

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | inventories_routes | INSERT | ルートレコードの追加 |
| 編集 | inventories_routes | UPDATE | ルート情報の更新 |
| 削除 | inventories_routes | UPDATE | deleted_atに日時を設定 |
| 復元 | inventories_routes | UPDATE | deleted_atをnullに設定 |
| 完全削除 | inventories_routes | DELETE | レコードの物理削除 |
| 並び替え | inventories_routes | UPDATE | sortカラムの更新 |

### テーブル別更新項目詳細

#### inventories_routes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | company_id | ユーザーのデフォルト会社ID | 自動設定 |
| INSERT | sort | 自動採番 | SortableTrait |
| UPDATE | sort | ドラッグ位置に応じた値 | 並び替え時 |
| UPDATE | deleted_at | null/現在日時 | 復元/削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| create.success | 成功 | ルートが正常に作成されました | 作成成功時 |
| edit.success | 成功 | ルートが正常に更新されました | 更新成功時 |
| delete.success | 成功 | ルートが正常に削除されました | 削除成功時 |
| restore.success | 成功 | ルートが正常に復元されました | 復元成功時 |
| force-delete.success | 成功 | ルートが完全に削除されました | 完全削除成功時 |
| force-delete.error | エラー | 関連するデータがあるため削除できません | 外部キー制約エラー時 |
| bulk-delete.success | 成功 | 選択したルートが削除されました | 一括削除成功時 |
| bulk-restore.success | 成功 | 選択したルートが復元されました | 一括復元成功時 |

## 例外処理

- 外部キー制約違反時：エラー通知を表示し、完全削除を中断
- 認証エラー：ログイン画面へリダイレクト
- マルチステップルート機能無効時：ナビゲーションから非表示（アクセス不可）

## 備考

- ナビゲーショングループ：「倉庫管理」配下
- ナビゲーションアイコン：heroicon-o-arrow-path
- ナビゲーション順序：3
- Spatie/EloquentSortableを使用した並び替え機能
- グローバル検索は無効（isGloballySearchable = false）
