# 画面設計書 113-ルート作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ルート作成」画面の設計仕様を定義したものです。

### 本画面の処理概要

ルート作成画面は、在庫管理における商品移動経路（ルート）を新規登録するための画面です。

**業務上の目的・背景**：在庫の入出庫や内部移動において、商品がどのような経路で移動するかを定義する必要があります。ルートを作成することで、商品カテゴリ、商品、パッケージング、倉庫に対して特定の移動経路を適用でき、マルチステップの在庫オペレーションを実現します。

**画面へのアクセス方法**：
- 在庫モジュール > 設定 > ルート一覧 > 「新規作成」ボタン
- または、ルート一覧画面の空状態アクション

**主要な操作・処理内容**：
1. ルート基本情報の入力（名称、会社）
2. 適用対象の設定（商品カテゴリ、商品、パッケージング、倉庫）
3. 倉庫選択（倉庫適用を有効にした場合）
4. ルートの保存

**画面遷移**：
- 遷移元：ルート一覧画面
- 遷移先：作成成功後はルート詳細画面

**権限による表示制御**：マルチステップルート機能（enable_multi_steps_routes）が有効な場合のみアクセス可能です。パッケージング設定はenable_packagingsが有効な場合のみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-026 | ルート管理 | 主機能 | ルート新規作成 |

## 画面種別

作成（CreateRecord）

## URL/ルーティング

`/inventories/configurations/routes/create`

## 画面構成

- ヘッダー部：
  - ページタイトル
  - サブナビゲーション（クラスター内コンポーネント）
- メイン部：
  - 基本情報セクション
  - 適用対象セクション
- フッター部：
  - キャンセルボタン
  - 作成ボタン

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ルート名 | name | text | ○ | ルートの名称（最大255文字）、フォントサイズ拡大表示 |
| 会社 | company_id | select | - | 所属会社（デフォルト：ログインユーザーのデフォルト会社） |

### 適用対象セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 商品カテゴリで選択可能 | product_category_selectable | toggle | - | 商品カテゴリに適用するかのフラグ |
| 商品で選択可能 | product_selectable | toggle | - | 商品に適用するかのフラグ |
| パッケージングで選択可能 | packaging_selectable | toggle | - | パッケージングに適用するか（enable_packagings設定時のみ表示） |
| 倉庫で選択可能 | warehouse_selectable | toggle | - | 倉庫に適用するかのフラグ |
| 倉庫 | warehouses | multiselect | - | 適用する倉庫（warehouse_selectableがtrue時のみ表示） |

## 表示項目

表示専用項目なし（作成画面のため）

## イベント仕様

### 1-ルート名入力

- 最大255文字
- 必須バリデーション
- オートフォーカス設定

### 2-会社選択

- 検索可能なセレクトボックス
- プリロード有効
- 削除済み会社も表示（ただし選択不可）
- ライブ更新（他フィールドへの影響なし）

### 3-倉庫選択トグル

- ライブ更新
- オンにすると倉庫マルチセレクトが表示

### 4-作成ボタン押下

- バリデーション実行
- creator_idにログインユーザーIDを自動設定
- company_idが未設定の場合、ユーザーのデフォルト会社IDを設定
- レコード作成後、ルート詳細画面へリダイレクト
- 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成 | inventories_routes | INSERT | ルートレコードの追加 |
| 作成（倉庫選択時） | inventories_route_warehouses | INSERT | 倉庫との関連レコード追加 |

### テーブル別更新項目詳細

#### inventories_routes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | company_id | フォーム入力値またはデフォルト会社ID | - |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | product_selectable | フォーム入力値（boolean） | デフォルトfalse |
| INSERT | product_category_selectable | フォーム入力値（boolean） | デフォルトfalse |
| INSERT | warehouse_selectable | フォーム入力値（boolean） | デフォルトfalse |
| INSERT | packaging_selectable | フォーム入力値（boolean） | デフォルトfalse |
| INSERT | sort | 自動採番 | SortableTrait |

#### inventories_route_warehouses

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | route_id | 作成されたルートID | 外部キー |
| INSERT | warehouse_id | 選択された倉庫ID | 外部キー |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| notification.title | 成功 | ルートが正常に作成されました | 作成成功時 |
| notification.body | 成功 | 新しいルートが登録されました | 作成成功時 |

## 例外処理

- 必須バリデーションエラー：フィールド下にエラーメッセージ表示
- 認証エラー：ログイン画面へリダイレクト
- マルチステップルート機能無効時：アクセス不可

## 備考

- SubNavigationPosition：Start（サイドにサブナビゲーション表示）
- 作成成功後のリダイレクト先：ルート詳細画面（view）
- 削除済み会社は選択肢に表示されるが、"(Deleted)"マークが付き選択不可
- ヒントアイコンによるツールチップで各項目の説明を表示
