# 画面設計書 114-ルート編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ルート編集」画面の設計仕様を定義したものです。

### 本画面の処理概要

ルート編集画面は、既存の在庫移動経路（ルート）の情報を変更するための画面です。

**業務上の目的・背景**：在庫オペレーションの変更に伴い、既存のルート設定を変更する必要が生じることがあります。適用対象の変更や関連倉庫の変更など、運用に合わせてルート設定を柔軟に調整できます。

**画面へのアクセス方法**：
- 在庫モジュール > 設定 > ルート一覧 > 対象ルートの編集アクション
- ルート詳細画面 > サブナビゲーション「編集」タブ

**主要な操作・処理内容**：
1. ルート基本情報の変更（名称、会社）
2. 適用対象の変更（商品カテゴリ、商品、パッケージング、倉庫）
3. 倉庫選択の変更
4. 変更の保存
5. ルートの削除

**画面遷移**：
- 遷移元：ルート一覧画面、ルート詳細画面
- 遷移先：保存後は同画面に留まる、削除後はルート一覧画面

**権限による表示制御**：マルチステップルート機能（enable_multi_steps_routes）が有効な場合のみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-026 | ルート管理 | 主機能 | ルート編集・削除 |

## 画面種別

編集（EditRecord）

## URL/ルーティング

`/inventories/configurations/routes/{record}/edit`

## 画面構成

- ヘッダー部：
  - ページタイトル
  - 削除ボタン
- サブナビゲーション部：
  - 詳細タブ
  - 編集タブ（現在地）
  - ルールタブ
- メイン部：
  - 基本情報セクション
  - 適用対象セクション
- フッター部：
  - キャンセルボタン
  - 保存ボタン

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ルート名 | name | text | ○ | ルートの名称（最大255文字） |
| 会社 | company_id | select | - | 所属会社 |

### 適用対象セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 商品カテゴリで選択可能 | product_category_selectable | toggle | - | 商品カテゴリに適用するかのフラグ |
| 商品で選択可能 | product_selectable | toggle | - | 商品に適用するかのフラグ |
| パッケージングで選択可能 | packaging_selectable | toggle | - | パッケージングに適用するか |
| 倉庫で選択可能 | warehouse_selectable | toggle | - | 倉庫に適用するかのフラグ |
| 倉庫 | warehouses | multiselect | - | 適用する倉庫 |

## 表示項目

編集フォームに現在値が表示されます。

## イベント仕様

### 1-保存ボタン押下

- バリデーション実行
- レコード更新
- 成功通知を表示
- 同画面に留まる

### 2-削除ボタン押下

- 確認ダイアログ表示
- 論理削除実行（deleted_atに日時を設定）
- 成功通知を表示
- ルート一覧画面へリダイレクト

### 3-倉庫選択トグル

- ライブ更新
- オンにすると倉庫マルチセレクトが表示
- オフにすると倉庫選択がクリア

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | inventories_routes | UPDATE | ルート情報の更新 |
| 保存（倉庫変更時） | inventories_route_warehouses | SYNC | 倉庫との関連レコード同期 |
| 削除 | inventories_routes | UPDATE | deleted_atに日時を設定 |

### テーブル別更新項目詳細

#### inventories_routes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | company_id | フォーム入力値 | - |
| UPDATE | product_selectable | フォーム入力値（boolean） | - |
| UPDATE | product_category_selectable | フォーム入力値（boolean） | - |
| UPDATE | warehouse_selectable | フォーム入力値（boolean） | - |
| UPDATE | packaging_selectable | フォーム入力値（boolean） | - |
| UPDATE | deleted_at | 現在日時 | 削除時のみ |
| UPDATE | updated_at | 現在日時 | 自動設定 |

#### inventories_route_warehouses

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SYNC | route_id | 対象ルートID | 外部キー |
| SYNC | warehouse_id | 選択された倉庫ID | 外部キー |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| notification.title | 成功 | ルートが正常に更新されました | 保存成功時 |
| notification.body | 成功 | ルート情報が更新されました | 保存成功時 |
| delete.notification.title | 成功 | ルートが正常に削除されました | 削除成功時 |
| delete.notification.body | 成功 | ルートがアーカイブされました | 削除成功時 |

## 例外処理

- 必須バリデーションエラー：フィールド下にエラーメッセージ表示
- レコード未存在：404エラー画面表示
- 認証エラー：ログイン画面へリダイレクト
- マルチステップルート機能無効時：アクセス不可

## 備考

- HasRecordNavigationTabsトレイトを使用してサブナビゲーション生成
- サブナビゲーション：詳細（ViewRoute）、編集（EditRoute）、ルール（ManageRules）
- 削除は論理削除（SoftDeletes）
- 削除済みレコードは編集画面にアクセス不可（一覧のarchivedタブから復元が必要）
