# 画面設計書 115-ルート詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ルート詳細」画面の設計仕様を定義したものです。

### 本画面の処理概要

ルート詳細画面は、登録済みの在庫移動経路（ルート）の詳細情報を表示するための画面です。

**業務上の目的・背景**：登録されたルートの設定内容を確認することで、在庫移動経路の構成を把握できます。どの商品カテゴリや倉庫に適用されているか、いつ誰が作成したかなどの情報を一目で確認できます。

**画面へのアクセス方法**：
- 在庫モジュール > 設定 > ルート一覧 > 対象ルートの表示アクション
- ルート作成画面から作成成功後のリダイレクト

**主要な操作・処理内容**：
1. ルート基本情報の表示
2. 適用対象設定の表示
3. レコード情報（作成日時、作成者、更新日時）の表示
4. 削除操作

**画面遷移**：
- 遷移元：ルート一覧画面、ルート作成画面
- 遷移先：ルート編集画面、ルール管理画面

**権限による表示制御**：マルチステップルート機能（enable_multi_steps_routes）が有効な場合のみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-026 | ルート管理 | 主機能 | ルート詳細表示 |
| FN-INV-027 | ルール管理 | 遷移先機能 | ルールタブへの遷移 |

## 画面種別

詳細（ViewRecord）

## URL/ルーティング

`/inventories/configurations/routes/{record}`

## 画面構成

- ヘッダー部：
  - ページタイトル
  - 削除ボタン
- サブナビゲーション部：
  - 詳細タブ（現在地）
  - 編集タブ
  - ルールタブ
- メイン部（3カラムレイアウト）：
  - 左側（2カラム幅）：
    - 基本情報セクション
    - 適用対象セクション
  - 右側（1カラム幅）：
    - レコード情報セクション

## 入出力項目

詳細画面のため入力項目なし

## 表示項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ルート名 | name | text | ルートの名称（アイコン：heroicon-o-arrow-path） |
| 会社 | company.name | text | 所属会社名（アイコン：heroicon-o-building-office） |

### 適用対象セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 商品カテゴリ | product_category_selectable | icon | 適用フラグ（○/×アイコン） |
| 商品 | product_selectable | icon | 適用フラグ（○/×アイコン） |
| パッケージング | packaging_selectable | icon | 適用フラグ（○/×アイコン） |
| 倉庫 | warehouse_selectable | icon | 適用フラグ（○/×アイコン） |
| 倉庫名 | warehouses.name | text | 適用倉庫一覧（warehouse_selectableがtrueの場合のみ表示） |

### レコード情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 作成日時 | created_at | datetime | レコード作成日時（アイコン：heroicon-m-calendar） |
| 作成者 | creator.name | text | レコード作成者名（アイコン：heroicon-m-user） |
| 最終更新日時 | updated_at | datetime | 最終更新日時（アイコン：heroicon-m-calendar-days） |

## イベント仕様

### 1-削除ボタン押下

- 確認ダイアログ表示
- 論理削除実行（deleted_atに日時を設定）
- 成功通知を表示
- ルート一覧画面へリダイレクト

### 2-サブナビゲーション遷移

- 編集タブ：ルート編集画面へ遷移
- ルールタブ：ルール管理画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | inventories_routes | UPDATE | deleted_atに日時を設定 |

### テーブル別更新項目詳細

#### inventories_routes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在日時 | 削除時のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| delete.notification.title | 成功 | ルートが正常に削除されました | 削除成功時 |
| delete.notification.body | 成功 | ルートがアーカイブされました | 削除成功時 |

## 例外処理

- レコード未存在：404エラー画面表示
- 認証エラー：ログイン画面へリダイレクト
- マルチステップルート機能無効時：アクセス不可
- 削除済みレコードへのアクセス：一覧の表示ボタンが非表示のため通常はアクセス不可

## 備考

- HasRecordNavigationTabsトレイトを使用してサブナビゲーション生成
- サブナビゲーション：詳細（ViewRoute）、編集（EditRoute）、ルール（ManageRules）
- 3カラムレイアウト（columns(3)）
- ルート名は大きなフォントサイズで太字表示（TextSize::Large, FontWeight::Bold）
- 適用対象はアイコンで視覚的に表示（check-circle / x-circle）
- 倉庫リストは改行区切りで表示（listWithLineBreaks）
