# 画面設計書 116-ルートルール管理

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ルートルール管理」画面の設計仕様を定義したものです。

### 本画面の処理概要

ルートルール管理画面は、特定のルートに関連付けられたルール情報を管理するための画面です。

**業務上の目的・背景**：ルートは商品の移動経路を定義しますが、その経路において具体的にどのような在庫移動（Pull/Push操作）を行うかはルールによって定義されます。この画面により、ルートごとにどのルールが適用されるかを一元管理でき、複雑な在庫フローを構築できます。

**画面へのアクセス方法**：在庫モジュール > 設定 > ルート > ルート詳細画面 > サブナビゲーション「ルール」タブをクリック

**主要な操作・処理内容**：
1. ルートに関連付けられたルールの一覧表示
2. 新規ルールの作成（ルートIDが自動設定される）
3. 既存ルールの編集・削除
4. ルールの表示・復元操作

**画面遷移**：
- 遷移元：ルート詳細画面、ルート編集画面
- 遷移先：ルール詳細画面、ルール編集画面

**権限による表示制御**：マルチステップルート機能（enable_multi_steps_routes）が有効な場合のみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-026 | ルート管理 | 親機能 | ルートレコードへのルール関連付け |
| FN-INV-027 | ルール管理 | 主機能 | ルールCRUD操作 |

## 画面種別

関連レコード管理（ManageRelatedRecords）

## URL/ルーティング

`/inventories/configurations/routes/{record}/rules`

## 画面構成

- ヘッダー部：サブナビゲーションタブ（詳細、編集、ルール）
- メイン部：
  - ヘッダーアクション：新規作成ボタン
  - データテーブル：ルール一覧
- アクションボタン：表示、編集、復元、削除、完全削除

## 入出力項目

### ルール作成・編集フォーム

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ルール名 | name | string | ○ | ルールの名称（最大255文字） |
| アクション | action | select | ○ | Pull/Push/Pull & Push/Buy |
| オペレーションタイプ | operation_type_id | select | ○ | 適用するオペレーションタイプ |
| 元ロケーション | source_location_id | select | ○ | 移動元ロケーション |
| 先ロケーション | destination_location_id | select | ○ | 移動先ロケーション |
| パートナー住所 | partner_address_id | select | - | 購買時のパートナー住所 |
| リードタイム | delay | integer | - | リードタイム（日数） |
| 会社 | company_id | select | - | 所属会社 |

## 表示項目

### テーブルカラム

| 項目名 | 項目ID | 型 | 検索 | 説明 |
|--------|--------|-----|------|------|
| アクション | action | string | ○ | Pull/Push等のアクション種別 |
| 元ロケーション | sourceLocation.full_name | string | ○ | 移動元ロケーションのフルパス名 |
| 先ロケーション | destinationLocation.full_name | string | ○ | 移動先ロケーションのフルパス名 |

## イベント仕様

### 1-新規作成ボタン押下

- route_idに現在のルートIDを自動設定
- creator_idにログインユーザーIDを設定
- company_idにユーザーのデフォルト会社IDを設定（未指定時）
- 作成成功時に成功通知を表示

### 2-オペレーションタイプ選択時

- afterStateUpdatedで元ロケーションと先ロケーションを自動設定
- オペレーションタイプのデフォルトロケーションを取得

### 3-行アクション

- 表示：ルール詳細画面への遷移（削除済みレコードは非表示）
- 編集：ルール編集画面への遷移（削除済みレコードは非表示）
- 復元：論理削除レコードの復元
- 削除：論理削除
- 完全削除：物理削除（外部キー制約エラー時はエラー通知）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | inventories_rules | INSERT | ルールレコードの追加 |
| 編集 | inventories_rules | UPDATE | ルール情報の更新 |
| 削除 | inventories_rules | UPDATE | deleted_atに日時を設定 |
| 復元 | inventories_rules | UPDATE | deleted_atをnullに設定 |
| 完全削除 | inventories_rules | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### inventories_rules

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | route_id | 現在のルートID | 自動設定 |
| INSERT | action | フォーム選択値 | 必須 |
| INSERT | operation_type_id | フォーム選択値 | 必須 |
| INSERT | source_location_id | フォーム選択値 | 必須 |
| INSERT | destination_location_id | フォーム選択値 | 必須 |
| INSERT | company_id | フォーム入力値またはデフォルト | - |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| UPDATE | deleted_at | null/現在日時 | 復元/削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| create.success | 成功 | ルールが正常に作成されました | 作成成功時 |
| edit.success | 成功 | ルールが正常に更新されました | 更新成功時 |
| delete.success | 成功 | ルールが正常に削除されました | 削除成功時 |
| restore.success | 成功 | ルールが正常に復元されました | 復元成功時 |
| force-delete.error | エラー | 関連するデータがあるため削除できません | 外部キー制約エラー時 |

## 例外処理

- 外部キー制約違反時：エラー通知を表示し、完全削除を中断
- 認証エラー：ログイン画面へリダイレクト
- マルチステップルート機能無効時：画面自体が非表示

## 備考

- 本画面はRouteResourceのサブナビゲーションとして機能
- RuleResourceのフォーム定義とテーブル定義を再利用
- ManageRulesページクラスでroute_idの設定処理とroute選択フィールドの非表示化を実施
- ナビゲーションアイコン：heroicon-o-clipboard-document-check
- テーブルカラムはルート管理画面専用にaction, sourceLocation, destinationLocationの3列に限定
