# 画面設計書 117-パッケージタイプ一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける「パッケージタイプ一覧」画面の設計仕様を定義したものです。

### 本画面の処理概要

パッケージタイプ一覧画面は、在庫管理における荷姿（パッケージタイプ）を一覧表示・管理するための画面です。

**業務上の目的・背景**：在庫管理において、商品を梱包する際の荷姿情報（寸法、重量など）を管理する必要があります。パッケージタイプを定義することで、配送時の梱包計画や在庫のパッケージ単位での管理が可能になります。

**画面へのアクセス方法**：在庫モジュール > 設定 > パッケージタイプ一覧（サイドナビゲーション）

**主要な操作・処理内容**：
1. パッケージタイプの一覧表示（検索、ソート）
2. 新規パッケージタイプの作成
3. 既存パッケージタイプの表示・編集・削除

**画面遷移**：
- 遷移元：ダッシュボード、在庫設定画面
- 遷移先：パッケージタイプ作成画面、パッケージタイプ詳細画面、パッケージタイプ編集画面

**権限による表示制御**：パッケージ機能（enable_packages）が有効な場合のみナビゲーションに表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-030 | パッケージタイプ管理 | 主機能 | パッケージタイプCRUD操作、一覧表示 |

## 画面種別

一覧（ListRecords）

## URL/ルーティング

`/inventories/configurations/package-types`

## 画面構成

- ヘッダー部：
  - ページタイトル
  - 新規作成ボタン
- メイン部：
  - データテーブル：パッケージタイプ一覧
- フッター部：ページネーション

## 入出力項目

フィルターなし

## 表示項目

### テーブルカラム

| 項目名 | 項目ID | 型 | ソート | 検索 | 説明 |
|--------|--------|-----|--------|------|------|
| 名称 | name | string | - | ○ | パッケージタイプの名称 |
| 高さ | height | decimal | ○ | - | 高さ（cm） |
| 幅 | width | decimal | ○ | - | 幅（cm） |
| 長さ | length | decimal | ○ | - | 長さ（cm） |
| バーコード | barcode | string | ○ | - | バーコード（デフォルト非表示） |
| 作成日時 | created_at | datetime | ○ | - | レコード作成日時（デフォルト非表示） |
| 更新日時 | updated_at | datetime | ○ | - | レコード更新日時（デフォルト非表示） |

## イベント仕様

### 1-新規作成ボタン押下

- パッケージタイプ作成画面へ遷移
- creator_idにログインユーザーIDを設定
- company_idにユーザーのデフォルト会社IDを設定
- 作成成功時に成功通知を表示

### 2-行アクション

- 表示：パッケージタイプ詳細画面への遷移
- 編集：パッケージタイプ編集画面への遷移
- 削除：物理削除（成功通知表示）

### 3-一括アクション

- 削除：選択したレコードを一括物理削除

### 4-空状態アクション

- 新規作成ボタン表示（データがない場合）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | inventories_package_types | INSERT | パッケージタイプレコードの追加 |
| 編集 | inventories_package_types | UPDATE | パッケージタイプ情報の更新 |
| 削除 | inventories_package_types | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### inventories_package_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | company_id | ユーザーのデフォルト会社ID | 自動設定 |
| INSERT | sort | 自動採番 | SortableTrait |
| DELETE | - | 物理削除 | SoftDeletes未使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| create.success | 成功 | パッケージタイプが正常に作成されました | 作成成功時 |
| delete.success | 成功 | パッケージタイプが正常に削除されました | 削除成功時 |
| bulk-delete.success | 成功 | 選択したパッケージタイプが削除されました | 一括削除成功時 |

## 例外処理

- 認証エラー：ログイン画面へリダイレクト
- パッケージ機能無効時：ナビゲーションから非表示（アクセス不可）

## 備考

- ナビゲーショングループ：「製品」配下
- ナビゲーションアイコン：heroicon-o-archive-box
- ナビゲーション順序：10
- Spatie/EloquentSortableを使用した並び替え機能（ドラッグ&ドロップはなし）
- グローバル検索は無効（isGloballySearchable = false）
- SoftDeletes未使用（物理削除のみ）
- バーコードはデフォルトで非表示（toggleable）
- バーコードがnullの場合は「-」を表示（placeholder）
