# 画面設計書 118-パッケージタイプ作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「パッケージタイプ作成」画面の設計仕様を定義したものです。

### 本画面の処理概要

パッケージタイプ作成画面は、在庫管理における荷姿（パッケージタイプ）を新規登録するための画面です。

**業務上の目的・背景**：配送や在庫管理において、商品を梱包する際の荷姿情報を定義する必要があります。パッケージタイプには寸法（縦・横・高さ）、重量（基本重量・最大重量）、バーコードなどの情報を設定でき、これにより梱包計画や配送コスト計算に活用できます。

**画面へのアクセス方法**：
- 在庫モジュール > 設定 > パッケージタイプ一覧 > 「新規作成」ボタン
- または、パッケージタイプ一覧画面の空状態アクション

**主要な操作・処理内容**：
1. パッケージタイプ基本情報の入力（名称、バーコード）
2. 寸法情報の入力（長さ、幅、高さ）
3. 重量情報の入力（基本重量、最大重量）
4. 会社の選択
5. パッケージタイプの保存

**画面遷移**：
- 遷移元：パッケージタイプ一覧画面
- 遷移先：作成成功後はパッケージタイプ詳細画面

**権限による表示制御**：パッケージ機能（enable_packages）が有効な場合のみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-030 | パッケージタイプ管理 | 主機能 | パッケージタイプ新規作成 |

## 画面種別

作成（CreateRecord）

## URL/ルーティング

`/inventories/configurations/package-types/create`

## 画面構成

- ヘッダー部：
  - ページタイトル
  - サブナビゲーション（クラスター内コンポーネント）
- メイン部：
  - 基本情報セクション
    - 名称
    - サイズフィールドセット（長さ、幅、高さ）
    - 基本重量
    - 最大重量
    - バーコード
    - 会社
- フッター部：
  - キャンセルボタン
  - 作成ボタン

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 名称 | name | text | ○ | パッケージタイプの名称（最大255文字）、フォントサイズ拡大表示 |
| 長さ | length | decimal | ○ | 長さ（cm）、デフォルト0.0000、最小0、最大99999999999 |
| 幅 | width | decimal | ○ | 幅（cm）、デフォルト0.0000、最小0、最大99999999999 |
| 高さ | height | decimal | ○ | 高さ（cm）、デフォルト0.0000、最小0、最大99999999999 |
| 基本重量 | base_weight | decimal | ○ | パッケージ自体の重量（kg）、デフォルト0.0000 |
| 最大重量 | max_weight | decimal | ○ | 最大積載重量（kg）、デフォルト0.0000 |
| バーコード | barcode | text | - | バーコード（最大255文字）、一意制約 |
| 会社 | company_id | select | - | 所属会社 |

## 表示項目

表示専用項目なし（作成画面のため）

## イベント仕様

### 1-名称入力

- 最大255文字
- 必須バリデーション
- オートフォーカス設定

### 2-サイズ入力（長さ、幅、高さ）

- 数値入力（decimal）
- 最小値：0
- 最大値：99999999999
- デフォルト値：0.0000
- 必須バリデーション

### 3-重量入力（基本重量、最大重量）

- 数値入力（decimal）
- 最小値：0
- 最大値：99999999999
- デフォルト値：0.0000
- 必須バリデーション

### 4-会社選択

- 検索可能なセレクトボックス
- プリロード有効

### 5-作成ボタン押下

- バリデーション実行
- creator_idにログインユーザーIDを自動設定
- company_idにユーザーのデフォルト会社IDを設定
- レコード作成後、パッケージタイプ詳細画面へリダイレクト
- 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成 | inventories_package_types | INSERT | パッケージタイプレコードの追加 |

### テーブル別更新項目詳細

#### inventories_package_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | length | フォーム入力値 | 必須、デフォルト0.0000 |
| INSERT | width | フォーム入力値 | 必須、デフォルト0.0000 |
| INSERT | height | フォーム入力値 | 必須、デフォルト0.0000 |
| INSERT | base_weight | フォーム入力値 | 必須、デフォルト0.0000 |
| INSERT | max_weight | フォーム入力値 | 必須、デフォルト0.0000 |
| INSERT | barcode | フォーム入力値 | 一意制約 |
| INSERT | company_id | フォーム入力値またはデフォルト | - |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | sort | 自動採番 | SortableTrait |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| notification.title | 成功 | パッケージタイプが正常に作成されました | 作成成功時 |
| notification.body | 成功 | 新しいパッケージタイプが登録されました | 作成成功時 |

## 例外処理

- 必須バリデーションエラー：フィールド下にエラーメッセージ表示
- バーコード重複エラー：フィールド下にエラーメッセージ表示
- 認証エラー：ログイン画面へリダイレクト
- パッケージ機能無効時：アクセス不可

## 備考

- サイズフィールドは3カラムのFieldsetでグループ化
- 作成成功後のリダイレクト先：パッケージタイプ詳細画面（view）
- バーコードはデータベースレベルで一意制約あり
- 重量の単位はkgを想定
- サイズの単位はcmを想定
