# 画面設計書 119-パッケージタイプ編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける「パッケージタイプ編集」画面の設計仕様を定義したものです。

### 本画面の処理概要

パッケージタイプ編集画面は、既存の荷姿（パッケージタイプ）の情報を変更するための画面です。

**業務上の目的・背景**：配送や在庫管理の運用変更に伴い、既存のパッケージタイプ設定を変更する必要が生じることがあります。寸法や重量の修正、バーコードの変更など、運用に合わせてパッケージタイプ設定を柔軟に調整できます。

**画面へのアクセス方法**：
- 在庫モジュール > 設定 > パッケージタイプ一覧 > 対象パッケージタイプの編集アクション
- パッケージタイプ詳細画面 > ヘッダーの「編集」ボタン

**主要な操作・処理内容**：
1. パッケージタイプ基本情報の変更（名称、バーコード）
2. 寸法情報の変更（長さ、幅、高さ）
3. 重量情報の変更（基本重量、最大重量）
4. 会社の変更
5. 変更の保存
6. パッケージタイプの削除

**画面遷移**：
- 遷移元：パッケージタイプ一覧画面、パッケージタイプ詳細画面
- 遷移先：保存後は同画面に留まる、削除後はパッケージタイプ一覧画面

**権限による表示制御**：パッケージ機能（enable_packages）が有効な場合のみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-030 | パッケージタイプ管理 | 主機能 | パッケージタイプ編集・削除 |

## 画面種別

編集（EditRecord）

## URL/ルーティング

`/inventories/configurations/package-types/{record}/edit`

## 画面構成

- ヘッダー部：
  - ページタイトル
  - 表示ボタン
  - 削除ボタン
- メイン部：
  - 基本情報セクション
    - 名称
    - サイズフィールドセット（長さ、幅、高さ）
    - 基本重量
    - 最大重量
    - バーコード
    - 会社
- フッター部：
  - キャンセルボタン
  - 保存ボタン

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 名称 | name | text | ○ | パッケージタイプの名称（最大255文字） |
| 長さ | length | decimal | ○ | 長さ（cm） |
| 幅 | width | decimal | ○ | 幅（cm） |
| 高さ | height | decimal | ○ | 高さ（cm） |
| 基本重量 | base_weight | decimal | ○ | パッケージ自体の重量（kg） |
| 最大重量 | max_weight | decimal | ○ | 最大積載重量（kg） |
| バーコード | barcode | text | - | バーコード（一意制約） |
| 会社 | company_id | select | - | 所属会社 |

## 表示項目

編集フォームに現在値が表示されます。

## イベント仕様

### 1-保存ボタン押下

- バリデーション実行
- レコード更新
- 成功通知を表示
- 同画面に留まる

### 2-表示ボタン押下

- パッケージタイプ詳細画面へ遷移

### 3-削除ボタン押下

- 確認ダイアログ表示
- 物理削除実行
- 成功通知を表示
- パッケージタイプ一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | inventories_package_types | UPDATE | パッケージタイプ情報の更新 |
| 削除 | inventories_package_types | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### inventories_package_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | length | フォーム入力値 | 必須 |
| UPDATE | width | フォーム入力値 | 必須 |
| UPDATE | height | フォーム入力値 | 必須 |
| UPDATE | base_weight | フォーム入力値 | 必須 |
| UPDATE | max_weight | フォーム入力値 | 必須 |
| UPDATE | barcode | フォーム入力値 | 一意制約 |
| UPDATE | company_id | フォーム入力値 | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| DELETE | - | 物理削除 | SoftDeletes未使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| notification.title | 成功 | パッケージタイプが正常に更新されました | 保存成功時 |
| notification.body | 成功 | パッケージタイプ情報が更新されました | 保存成功時 |
| delete.notification.title | 成功 | パッケージタイプが正常に削除されました | 削除成功時 |
| delete.notification.body | 成功 | パッケージタイプが削除されました | 削除成功時 |

## 例外処理

- 必須バリデーションエラー：フィールド下にエラーメッセージ表示
- バーコード重複エラー：フィールド下にエラーメッセージ表示
- レコード未存在：404エラー画面表示
- 認証エラー：ログイン画面へリダイレクト
- パッケージ機能無効時：アクセス不可

## 備考

- ヘッダーアクションに「表示」ボタン（ViewAction）と「削除」ボタン（DeleteAction）を配置
- 削除は物理削除（SoftDeletes未使用）
- サイズフィールドは3カラムのFieldsetでグループ化
- バーコードはデータベースレベルで一意制約あり
