# 画面設計書 12-現金丸め作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「現金丸め作成」画面の設計仕様を定義するものである。

### 本画面の処理概要

現金丸め作成画面は、会計モジュールにおいて新しい現金丸め設定を登録するための画面である。

**業務上の目的・背景**：現金取引における端数処理ルールを新規に定義する必要がある場合に使用する。企業の会計方針や取引先との契約条件に応じて、異なる丸め方式（四捨五入、切り上げ、切り捨て等）を設定できる。これにより、請求書や支払処理時に適切な端数処理が自動的に適用される。

**画面へのアクセス方法**：現金丸め一覧画面のヘッダーにある「作成」ボタンをクリックしてアクセスする。URL直接入力でもアクセス可能。

**主要な操作・処理内容**：
1. 現金丸め設定の名前を入力
2. 丸め精度（rounding precision）を数値で入力
3. 丸め戦略（BIGGEST_TAX等）を選択
4. 丸め方法（HALF_UP等）を選択
5. 保存ボタンで登録を確定

**画面遷移**：
- 保存成功時：現金丸め詳細画面（ViewCashRounding）へ自動遷移
- キャンセル時：現金丸め一覧画面へ戻る

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、作成権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-015 | 現金端数処理管理 | 主機能 | 現金丸め設定の新規作成 |
| FN-ACC-028 | 現金端数処理管理 | 主機能 | 作成処理 |

## 画面種別

登録

## URL/ルーティング

`/admin/accounts/cash-roundings/create`

## 画面構成

1. **フォームセクション**
   - 2カラムレイアウトのGroupコンポーネント内にフォームフィールドを配置

2. **入力フィールドエリア**
   - 名前（TextInput）
   - 丸め精度（TextInput - 数値）
   - 丸め戦略（Select）
   - 丸め方法（Select）

3. **アクションエリア**
   - 保存ボタン（Filament標準）
   - キャンセルボタン（Filament標準）

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| 名前 | name | string | 必須 | なし | 現金丸め設定の名称 |
| 丸め精度 | rounding | numeric | 必須 | 0.01 | 丸め精度（0〜99999999999） |
| 丸め戦略 | strategy | enum | 任意 | BIGGEST_TAX | 丸め戦略の種類 |
| 丸め方法 | rounding_method | enum | 必須 | HALF_UP | 丸め方法の種類 |

## 表示項目

該当なし（登録画面のため出力専用項目なし）

## イベント仕様

### 1-保存ボタン押下

フォームの入力内容をバリデーション後、データベースに新規レコードを作成する。作成成功時は成功通知を表示し、詳細画面へ遷移する。

### 2-キャンセル

入力内容を破棄し、一覧画面へ戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_cash_roundings | INSERT | 新規レコードの作成 |

### テーブル別更新項目詳細

#### accounts_cash_roundings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | rounding | フォーム入力値 | デフォルト0.01 |
| INSERT | strategy | フォーム選択値 | デフォルトBIGGEST_TAX |
| INSERT | rounding_method | フォーム選択値 | デフォルトHALF_UP |
| INSERT | creator_id | Auth::user()->id | mutateFormDataBeforeCreateで自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 作成成功通知（タイトル・本文） | レコード作成成功時 |
| エラー | バリデーションエラー | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バリデーションエラー | エラーメッセージを該当フィールドに表示 |
| データベースエラー | Filament標準のエラー処理 |
| 権限不足 | アクセス拒否エラー表示 |

## 備考

- 名前フィールドにはautofocusが設定されており、画面表示時に自動的にフォーカスされる
- 丸め精度の最小値は0、最大値は99999999999
- 作成者IDは`mutateFormDataBeforeCreate`メソッドで現在ログインユーザーのIDが自動設定される
- 保存成功後のリダイレクト先は詳細画面（view）
