# 画面設計書 120-パッケージタイプ詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける「パッケージタイプ詳細」画面の設計仕様を定義したものです。

### 本画面の処理概要

パッケージタイプ詳細画面は、登録済みの荷姿（パッケージタイプ）の詳細情報を表示するための画面です。

**業務上の目的・背景**：登録されたパッケージタイプの寸法や重量などの設定内容を確認することで、梱包計画や配送コスト計算の参照情報として活用できます。

**画面へのアクセス方法**：
- 在庫モジュール > 設定 > パッケージタイプ一覧 > 対象パッケージタイプの表示アクション
- パッケージタイプ作成画面から作成成功後のリダイレクト

**主要な操作・処理内容**：
1. パッケージタイプ基本情報の表示（名称、寸法、重量）
2. バーコードの表示
3. 会社情報の表示
4. レコード情報（作成日時、作成者、更新日時）の表示
5. 編集画面への遷移

**画面遷移**：
- 遷移元：パッケージタイプ一覧画面、パッケージタイプ作成画面
- 遷移先：パッケージタイプ編集画面

**権限による表示制御**：パッケージ機能（enable_packages）が有効な場合のみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-030 | パッケージタイプ管理 | 主機能 | パッケージタイプ詳細表示 |

## 画面種別

詳細（ViewRecord）

## URL/ルーティング

`/inventories/configurations/package-types/{record}`

## 画面構成

- ヘッダー部：
  - ページタイトル
  - 編集ボタン
- メイン部（3カラムレイアウト）：
  - 左側（2カラム幅）：
    - 基本情報セクション
      - 名称
      - サイズセクション（長さ、幅、高さ）
      - 重量情報（基本重量、最大重量）
      - バーコード
      - 会社
  - 右側（1カラム幅）：
    - レコード情報セクション

## 入出力項目

詳細画面のため入力項目なし

## 表示項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 名称 | name | text | パッケージタイプの名称（アイコン：heroicon-o-tag）、太字・大きなフォント |

### サイズセクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 長さ | length | decimal | 長さ（アイコン：heroicon-o-arrows-right-left）、単位：cm |
| 幅 | width | decimal | 幅（アイコン：heroicon-o-arrows-up-down）、単位：cm |
| 高さ | height | decimal | 高さ（アイコン：heroicon-o-arrows-up-down）、単位：cm |

### 重量情報

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 基本重量 | base_weight | decimal | パッケージ自体の重量（アイコン：heroicon-o-scale）、単位：kg |
| 最大重量 | max_weight | decimal | 最大積載重量（アイコン：heroicon-o-scale）、単位：kg |

### その他

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| バーコード | barcode | text | バーコード（アイコン：heroicon-o-bars-4）、未設定時は「-」表示 |
| 会社 | company.name | text | 所属会社名（アイコン：heroicon-o-building-office） |

### レコード情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 作成日時 | created_at | datetime | レコード作成日時（アイコン：heroicon-m-calendar） |
| 作成者 | creator.name | text | レコード作成者名（アイコン：heroicon-m-user） |
| 最終更新日時 | updated_at | datetime | 最終更新日時（アイコン：heroicon-m-calendar-days） |

## イベント仕様

### 1-編集ボタン押下

- パッケージタイプ編集画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

詳細画面のためデータベース更新なし

## メッセージ仕様

詳細画面のためメッセージなし

## 例外処理

- レコード未存在：404エラー画面表示
- 認証エラー：ログイン画面へリダイレクト
- パッケージ機能無効時：アクセス不可

## 備考

- 3カラムレイアウト（columns(3)）
- 名称は大きなフォントサイズで太字表示（TextSize::Large, FontWeight::Bold）
- サイズセクションは3カラムグリッドで表示
- 重量情報は2カラムグリッドで表示
- 数値は単位（cm、kg）をsuffixとして表示
- バーコードがnullの場合は「-」を表示（placeholder）
- ヘッダーに編集ボタン（EditAction）のみ配置
- 削除機能は詳細画面では提供せず、編集画面から実行
