# 画面設計書 121-オペレーションタイプ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるオペレーションタイプ一覧画面の設計を定義します。

### 本画面の処理概要

オペレーションタイプ一覧画面は、在庫管理における各種オペレーション（入庫、出庫、内部移動など）のタイプを一覧形式で表示・管理するための画面です。

**業務上の目的・背景**：在庫管理業務において、入庫・出庫・内部移動などのオペレーションを適切に分類・管理することは、在庫の正確なトレーサビリティを維持する上で不可欠です。オペレーションタイプを定義することで、各倉庫や会社ごとに異なるワークフローや予約方法、ロット管理設定を柔軟に設定できます。

**画面へのアクセス方法**：ダッシュボードから「在庫」モジュールを選択し、「設定」クラスタ内の「オペレーションタイプ」メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. オペレーションタイプの一覧表示（名前、会社、倉庫等の情報を含む）
2. タブ切り替えによる全件/アーカイブ済みの絞り込み表示
3. 検索・フィルタ機能による絞り込み
4. グループ化機能による倉庫別・タイプ別・日付別の表示切り替え
5. 新規オペレーションタイプの作成
6. 既存オペレーションタイプの編集・詳細表示・削除・復元・完全削除

**画面遷移**：この画面からオペレーションタイプ作成画面、詳細画面、編集画面に遷移できます。設定クラスタの他のリソース（倉庫、ルート、ロケーション等）からも遷移可能です。

**権限による表示制御**：ログインユーザーの所属会社に基づいてデフォルトの会社IDが設定されます。削除されたレコードは「アーカイブ済み」タブでのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-025 | オペレーションタイプ管理 | 主機能 | オペレーションタイプの一覧表示・作成・編集・削除 |
| FN-INV-023 | 倉庫管理 | 関連機能 | オペレーションタイプと倉庫の紐付け |
| FN-INV-024 | ロケーション管理 | 関連機能 | ソースロケーション・宛先ロケーションの参照 |

## 画面種別

一覧

## URL/ルーティング

`/inventories/configurations/operation-types`

## 画面構成

- ヘッダーアクション：新規作成ボタン
- タブナビゲーション：「すべて」「アーカイブ済み」
- データテーブル：オペレーションタイプ一覧
- フィルタパネル：タイプ、倉庫、会社によるフィルタ
- グループ化オプション：倉庫別、タイプ別、作成日別、更新日別
- 行アクション：表示、編集、復元、削除、完全削除
- 一括アクション：一括復元、一括削除、一括完全削除
- 空状態アクション：新規作成

## 入出力項目

| 項目名 | 項目種別 | 入力/出力 | 必須 | 説明 |
|--------|----------|-----------|------|------|
| オペレーションタイプ名 | テキスト | 入力（作成モーダル） | はい | オペレーションタイプの名前 |

## 表示項目

| 項目名 | データ型 | 説明 | 備考 |
|--------|----------|------|------|
| 名前 | 文字列 | オペレーションタイプの名前 | 検索可能 |
| 会社 | 文字列 | 所属会社名 | リレーション |
| 倉庫 | 文字列 | 関連倉庫名 | リレーション |
| 作成日時 | 日時 | レコード作成日時 | デフォルト非表示、トグル可能 |
| 更新日時 | 日時 | レコード更新日時 | デフォルト非表示、トグル可能 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「新規作成」ボタンをクリックすると、インラインで新規作成フォームが表示されます。作成者IDと会社IDはログインユーザーから自動設定されます。作成成功時には成功通知が表示され、一覧が更新されます。

### 2-タブ切り替え

「すべて」タブでは全オペレーションタイプが表示され、「アーカイブ済み」タブでは削除済み（ソフトデリート）のオペレーションタイプのみが表示されます。各タブにはレコード件数がバッジで表示されます。

### 3-表示アクション押下

選択したレコードの詳細表示画面に遷移します。削除済みレコードでは非表示になります。

### 4-編集アクション押下

選択したレコードの編集画面に遷移します。削除済みレコードでは非表示になります。

### 5-削除アクション押下

選択したレコードをソフトデリートします。成功時には成功通知が表示されます。

### 6-復元アクション押下

削除済みのレコードを復元します。成功時には成功通知が表示されます。

### 7-完全削除アクション押下

選択したレコードをデータベースから完全に削除します。外部キー制約違反時にはエラー通知が表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | inventories_operation_types | INSERT | オペレーションタイプの新規登録 |
| 削除 | inventories_operation_types | UPDATE | deleted_atカラムにタイムスタンプを設定（ソフトデリート） |
| 復元 | inventories_operation_types | UPDATE | deleted_atカラムをNULLに設定 |
| 完全削除 | inventories_operation_types | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### inventories_operation_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | オペレーションタイプ名 |
| INSERT | creator_id | Auth::user()->id | 作成者ID |
| INSERT | company_id | Auth::user()->default_company_id | 所属会社ID |
| INSERT | created_at | 現在日時 | 自動設定 |
| UPDATE | deleted_at | 現在日時/NULL | ソフトデリート/復元 |

## メッセージ仕様

| メッセージID | メッセージ種別 | タイトル | 本文 | 表示条件 |
|-------------|---------------|---------|------|----------|
| MSG-001 | 成功 | 作成成功 | オペレーションタイプが正常に作成されました | 新規作成成功時 |
| MSG-002 | 成功 | 復元成功 | オペレーションタイプが正常に復元されました | 復元成功時 |
| MSG-003 | 成功 | 削除成功 | オペレーションタイプが正常に削除されました | 削除成功時 |
| MSG-004 | 成功 | 完全削除成功 | オペレーションタイプが完全に削除されました | 完全削除成功時 |
| MSG-005 | エラー | 完全削除エラー | このオペレーションタイプは使用中のため削除できません | 外部キー制約違反時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データ未存在 | 空状態表示と新規作成ボタンの表示 |
| 外部キー制約違反（完全削除時） | エラー通知を表示し、削除をキャンセル |
| 権限不足 | 該当メニューが表示されない |

## 備考

- オペレーションタイプはFilament ResourceのListRecordsページを継承して実装されています。
- ソフトデリート機能（SoftDeletes）が有効であり、削除されたレコードは「アーカイブ済み」タブで管理されます。
- タブのバッジカウントは、各条件に該当するレコード数をリアルタイムで表示します。
