# 画面設計書 122-オペレーションタイプ作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるオペレーションタイプ作成画面の設計を定義します。

### 本画面の処理概要

オペレーションタイプ作成画面は、新規のオペレーションタイプ（入庫、出庫、内部移動等のワークフロー定義）を登録するための画面です。

**業務上の目的・背景**：在庫管理業務において、各倉庫や会社固有の入出庫ワークフローを定義するために、オペレーションタイプの作成が必要です。オペレーションタイプにより、予約方法、ロット管理、バックオーダー作成ポリシー、ソース/宛先ロケーションなどを設定できます。

**画面へのアクセス方法**：オペレーションタイプ一覧画面の「新規作成」ボタンをクリック、または一覧画面の空状態時の「新規作成」アクションからアクセスします。

**主要な操作・処理内容**：
1. オペレーションタイプの基本情報（名前、シーケンスコード）の入力
2. オペレーションタイプ（入庫/出庫/内部移動など）の選択
3. 倉庫・会社の選択
4. 予約方法の設定
5. ソースロケーション・宛先ロケーションの設定
6. ロット管理設定（新規作成/既存使用）
7. バックオーダー作成ポリシーの設定

**画面遷移**：作成完了後はオペレーションタイプ詳細画面に自動遷移します。キャンセル時は一覧画面に戻ります。

**権限による表示制御**：ログインユーザーのデフォルト会社が自動設定されます。トレーサビリティ設定や倉庫設定に応じて、ロット管理やロケーション設定のフィールドが表示/非表示になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-025 | オペレーションタイプ管理 | 主機能 | オペレーションタイプの新規作成 |
| FN-INV-023 | 倉庫管理 | 関連機能 | 倉庫選択時のロケーション連動 |
| FN-INV-024 | ロケーション管理 | 関連機能 | ソースロケーション・宛先ロケーションの選択 |

## 画面種別

登録

## URL/ルーティング

`/inventories/configurations/operation-types/create`

## 画面構成

- サブナビゲーション：設定クラスタのコンポーネント
- メインフォーム
  - セクション：オペレーションタイプ名入力（大きなテキスト入力）
  - タブ：一般設定
    - 左グループ：タイプ、シーケンスプレフィックス、配送ラベル生成、倉庫、予約方法、レセプションレポート表示
    - 右グループ：会社、返品タイプ、バックオーダー作成、移動タイプ
    - フィールドセット：ロット設定（新規作成、既存使用）
    - フィールドセット：ロケーション設定（ソースロケーション、宛先ロケーション）

## 入出力項目

| 項目名 | 項目種別 | 入力/出力 | 必須 | 説明 |
|--------|----------|-----------|------|------|
| オペレーションタイプ名 | テキスト | 入力 | はい | オペレーションタイプの名前（最大255文字） |
| タイプ | セレクト | 入力 | はい | INCOMING/OUTGOING/INTERNAL/DROPSHIP |
| シーケンスプレフィックス | テキスト | 入力 | はい | シーケンス番号のプレフィックス（最大255文字） |
| 配送ラベル生成 | トグル | 入力 | いいえ | 出庫/内部移動時のみ表示 |
| 倉庫 | セレクト | 入力 | いいえ | 関連付ける倉庫 |
| 予約方法 | ラジオ | 入力 | はい | 確認時/手動/注文日前 (入庫以外で表示) |
| レセプションレポート表示 | トグル | 入力 | いいえ | 入庫/内部移動時のみ表示 |
| 会社 | セレクト | 入力 | いいえ | 所属会社 |
| 返品タイプ | セレクト | 入力 | いいえ | 返品時のオペレーションタイプ (ドロップシップ以外で表示) |
| バックオーダー作成 | セレクト | 入力 | はい | 確認/なし/常に |
| 移動タイプ | セレクト | 入力 | いいえ | 内部移動時のみ表示 |
| 新規ロット作成 | トグル | 入力 | いいえ | ロット管理有効時のみ表示 |
| 既存ロット使用 | トグル | 入力 | いいえ | ロット管理有効時のみ表示 |
| ソースロケーション | セレクト | 入力 | はい | 在庫の取得元ロケーション |
| 宛先ロケーション | セレクト | 入力 | はい | 在庫の配送先ロケーション |

## 表示項目

なし（登録画面のため入力項目のみ）

## イベント仕様

### 1-タイプ変更時

オペレーションタイプを変更すると、以下が自動更新されます：
- 配送ラベル生成フラグがリセット
- ソースロケーションがタイプに応じて自動設定（入庫→仕入先ロケーション、出庫/内部移動→倉庫の補充ロケーション）
- 宛先ロケーションがタイプに応じて自動設定（入庫→補充ロケーション、出庫→顧客ロケーション、内部移動→倉庫内ロケーション）

### 2-倉庫変更時

倉庫を変更すると、ソースロケーションと宛先ロケーションのデフォルト値が選択された倉庫に基づいて再計算されます。

### 3-オペレーションタイプ選択変更時

オペレーションタイプIDが変更されると、紐づいたソースロケーションと宛先ロケーションが自動設定されます。

### 4-作成ボタン押下

フォームデータを検証し、以下の処理を行います：
- reservation_methodをAT_CONFIRMに設定
- creator_idをログインユーザーIDに設定
- データベースにINSERT
- 成功通知を表示
- 作成したレコードの詳細画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | inventories_operation_types | INSERT | オペレーションタイプの新規登録 |

### テーブル別更新項目詳細

#### inventories_operation_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | type | フォーム選択値 | Enum値 |
| INSERT | sequence_code | フォーム入力値 | 必須 |
| INSERT | print_label | フォーム入力値 | ブール値 |
| INSERT | warehouse_id | フォーム選択値 | 倉庫リレーション |
| INSERT | reservation_method | ReservationMethod::AT_CONFIRM | 自動設定 |
| INSERT | auto_show_reception_report | フォーム入力値 | ブール値 |
| INSERT | company_id | フォーム選択値 | 会社リレーション |
| INSERT | return_operation_type_id | フォーム選択値 | 自己参照リレーション |
| INSERT | create_backorder | フォーム選択値 | Enum値 |
| INSERT | move_type | フォーム選択値 | Enum値（内部移動のみ） |
| INSERT | use_create_lots | フォーム入力値 | ブール値 |
| INSERT | use_existing_lots | フォーム入力値 | ブール値 |
| INSERT | source_location_id | フォーム選択値 | ロケーションリレーション |
| INSERT | destination_location_id | フォーム選択値 | ロケーションリレーション |
| INSERT | creator_id | Auth::id() | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | タイトル | 本文 | 表示条件 |
|-------------|---------------|---------|------|----------|
| MSG-001 | 成功 | 作成成功 | オペレーションタイプが正常に作成されました | 作成成功時 |
| MSG-002 | エラー | 検証エラー | 必須項目を入力してください | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 必須項目未入力 | フォームバリデーションエラーを表示 |
| 倉庫が削除済み | 選択肢のラベルに「(Deleted)」を表示し、選択不可にする |
| ロケーションが削除済み | 選択肢のラベルに「(Deleted)」を表示し、選択不可にする |

## 備考

- Filament ResourceのCreateRecordページを継承して実装されています。
- タイプ選択によって表示されるフィールドが動的に変化します（liveバインディング使用）。
- トレーサビリティ設定（enable_lots_serial_numbers）が有効な場合のみロット管理フィールドセットが表示されます。
- 倉庫設定（enable_locations）が有効な場合のみロケーションフィールドセットが表示されます。
- オペレーション設定（enable_reception_report）が有効かつ入庫/内部移動タイプの場合のみレセプションレポート表示フィールドが表示されます。
- 削除済みの倉庫・ロケーションも選択肢に表示されますが、選択不可になります。
