# 画面設計書 123-オペレーションタイプ編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるオペレーションタイプ編集画面の設計を定義します。

### 本画面の処理概要

オペレーションタイプ編集画面は、既存のオペレーションタイプ（入庫、出庫、内部移動等のワークフロー定義）の設定を変更するための画面です。

**業務上の目的・背景**：在庫管理業務において、倉庫運営の変化に応じてオペレーションタイプの設定（予約方法、ロケーション、ロット管理等）を適宜更新する必要があります。

**画面へのアクセス方法**：オペレーションタイプ一覧画面または詳細画面から「編集」アクションをクリックしてアクセスします。

**主要な操作・処理内容**：
1. オペレーションタイプの基本情報の編集
2. 予約方法・ロット管理設定の変更
3. ソースロケーション・宛先ロケーションの変更
4. 既存レコードの削除

**画面遷移**：保存成功後は詳細画面に遷移します。削除後は一覧画面に戻ります。ヘッダーから詳細画面にも遷移可能です。

**権限による表示制御**：作成画面と同様に、トレーサビリティ設定や倉庫設定に応じてフィールドの表示/非表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-025 | オペレーションタイプ管理 | 主機能 | オペレーションタイプの編集・削除 |
| FN-INV-023 | 倉庫管理 | 関連機能 | 倉庫選択時のロケーション連動 |
| FN-INV-024 | ロケーション管理 | 関連機能 | ソースロケーション・宛先ロケーションの選択 |

## 画面種別

更新

## URL/ルーティング

`/inventories/configurations/operation-types/{record}/edit`

## 画面構成

- ヘッダーアクション：詳細表示ボタン、削除ボタン
- サブナビゲーション：レコードナビゲーション（詳細画面、編集画面）
- メインフォーム
  - セクション：オペレーションタイプ名入力（大きなテキスト入力）
  - タブ：一般設定
    - 左グループ：タイプ、シーケンスプレフィックス、配送ラベル生成、倉庫、予約方法、レセプションレポート表示
    - 右グループ：会社、返品タイプ、バックオーダー作成、移動タイプ
    - フィールドセット：ロット設定（新規作成、既存使用）
    - フィールドセット：ロケーション設定（ソースロケーション、宛先ロケーション）

## 入出力項目

| 項目名 | 項目種別 | 入力/出力 | 必須 | 説明 |
|--------|----------|-----------|------|------|
| オペレーションタイプ名 | テキスト | 入力 | はい | オペレーションタイプの名前（最大255文字） |
| タイプ | セレクト | 入力 | はい | INCOMING/OUTGOING/INTERNAL/DROPSHIP |
| シーケンスプレフィックス | テキスト | 入力 | はい | シーケンス番号のプレフィックス（最大255文字） |
| 配送ラベル生成 | トグル | 入力 | いいえ | 出庫/内部移動時のみ表示 |
| 倉庫 | セレクト | 入力 | いいえ | 関連付ける倉庫 |
| 予約方法 | ラジオ | 入力 | はい | 確認時/手動/注文日前 (入庫以外で表示) |
| レセプションレポート表示 | トグル | 入力 | いいえ | 入庫/内部移動時のみ表示 |
| 会社 | セレクト | 入力 | いいえ | 所属会社 |
| 返品タイプ | セレクト | 入力 | いいえ | 返品時のオペレーションタイプ (ドロップシップ以外で表示) |
| バックオーダー作成 | セレクト | 入力 | はい | 確認/なし/常に |
| 移動タイプ | セレクト | 入力 | いいえ | 内部移動時のみ表示 |
| 新規ロット作成 | トグル | 入力 | いいえ | ロット管理有効時のみ表示 |
| 既存ロット使用 | トグル | 入力 | いいえ | ロット管理有効時のみ表示 |
| ソースロケーション | セレクト | 入力 | はい | 在庫の取得元ロケーション |
| 宛先ロケーション | セレクト | 入力 | はい | 在庫の配送先ロケーション |

## 表示項目

なし（編集画面のため入力項目のみ）

## イベント仕様

### 1-保存ボタン押下

フォームデータを検証し、以下の処理を行います：
- データベースをUPDATE
- 成功通知を表示
- 編集後は同画面に留まる

### 2-詳細表示ボタン押下

編集中のレコードの詳細画面に遷移します。

### 3-削除ボタン押下

確認ダイアログの後、選択したレコードをソフトデリートします。成功時には成功通知が表示され、一覧画面に戻ります。

### 4-タイプ変更時

オペレーションタイプを変更すると、作成画面と同様にロケーション関連フィールドが自動更新されます。

### 5-倉庫変更時

倉庫を変更すると、ソースロケーションと宛先ロケーションのデフォルト値が再計算されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_operation_types | UPDATE | オペレーションタイプの更新 |
| 削除ボタン押下 | inventories_operation_types | UPDATE | deleted_atカラムにタイムスタンプを設定（ソフトデリート） |

### テーブル別更新項目詳細

#### inventories_operation_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | type | フォーム選択値 | Enum値 |
| UPDATE | sequence_code | フォーム入力値 | 必須 |
| UPDATE | print_label | フォーム入力値 | ブール値 |
| UPDATE | warehouse_id | フォーム選択値 | 倉庫リレーション |
| UPDATE | reservation_method | フォーム選択値 | Enum値 |
| UPDATE | auto_show_reception_report | フォーム入力値 | ブール値 |
| UPDATE | company_id | フォーム選択値 | 会社リレーション |
| UPDATE | return_operation_type_id | フォーム選択値 | 自己参照リレーション |
| UPDATE | create_backorder | フォーム選択値 | Enum値 |
| UPDATE | move_type | フォーム選択値 | Enum値（内部移動のみ） |
| UPDATE | use_create_lots | フォーム入力値 | ブール値 |
| UPDATE | use_existing_lots | フォーム入力値 | ブール値 |
| UPDATE | source_location_id | フォーム選択値 | ロケーションリレーション |
| UPDATE | destination_location_id | フォーム選択値 | ロケーションリレーション |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| UPDATE | deleted_at | 現在日時 | ソフトデリート時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | タイトル | 本文 | 表示条件 |
|-------------|---------------|---------|------|----------|
| MSG-001 | 成功 | 更新成功 | オペレーションタイプが正常に更新されました | 保存成功時 |
| MSG-002 | 成功 | 削除成功 | オペレーションタイプが正常に削除されました | 削除成功時 |
| MSG-003 | エラー | 検証エラー | 必須項目を入力してください | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 必須項目未入力 | フォームバリデーションエラーを表示 |
| レコード未存在 | 404エラーページを表示 |
| 倉庫が削除済み | 選択肢のラベルに「(Deleted)」を表示し、選択不可にする |
| ロケーションが削除済み | 選択肢のラベルに「(Deleted)」を表示し、選択不可にする |

## 備考

- Filament ResourceのEditRecordページを継承して実装されています。
- フォーム構成は作成画面と同一です（OperationTypeResource::form()を共有）。
- サブナビゲーションでは、詳細画面と編集画面の切り替えが可能です。
- 削除済みの倉庫・ロケーションも選択肢に表示されますが、選択不可になります（既存の関連付けは保持）。
