# 画面設計書 124-オペレーションタイプ詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるオペレーションタイプ詳細画面の設計を定義します。

### 本画面の処理概要

オペレーションタイプ詳細画面は、既存のオペレーションタイプの設定内容を読み取り専用で表示するための画面です。

**業務上の目的・背景**：オペレーションタイプの現在の設定を確認し、必要に応じて編集画面に遷移して変更を行うための参照画面として使用されます。

**画面へのアクセス方法**：オペレーションタイプ一覧画面から「表示」アクションをクリック、または作成・編集完了後の自動遷移先としてアクセスします。

**主要な操作・処理内容**：
1. オペレーションタイプの基本情報の表示
2. 予約設定・ロット設定の表示
3. ロケーション設定の表示
4. 編集画面への遷移

**画面遷移**：ヘッダーから編集画面に遷移可能です。サブナビゲーションでも画面切り替えが可能です。

**権限による表示制御**：読み取り専用画面のため特別な権限制御はありませんが、編集アクションは適切な権限がある場合のみ利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-025 | オペレーションタイプ管理 | 主機能 | オペレーションタイプの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/configurations/operation-types/{record}`

## 画面構成

- ヘッダーアクション：編集ボタン
- サブナビゲーション：レコードナビゲーション（詳細画面、編集画面）
- メインコンテンツ（3カラムレイアウト）
  - 左側（2カラム幅）：一般情報セクション
    - オペレーションタイプ名（大きなテキスト、太字）
    - タイプ、シーケンスコード、倉庫、会社
    - フィールドセット：ロケーション（ソースロケーション、宛先ロケーション）
    - セクション：予約設定
      - 予約方法、予約日数、バックオーダー作成、移動タイプ
    - セクション：ロット設定
      - 新規ロット作成、既存ロット使用
  - 右側（1カラム幅）：レコード情報セクション
    - 作成日時、作成者、最終更新日時

## 入出力項目

なし（詳細表示画面のため）

## 表示項目

| 項目名 | データ型 | 説明 | 備考 |
|--------|----------|------|------|
| オペレーションタイプ名 | 文字列 | オペレーションタイプの名前 | 大きなテキスト、太字、アイコン付き |
| タイプ | バッジ | オペレーションタイプ（入庫/出庫/内部移動等） | アイコン付き |
| シーケンスコード | 文字列 | シーケンス番号のプレフィックス | アイコン付き |
| 倉庫 | 文字列 | 関連付けられた倉庫名 | アイコン付き |
| 会社 | 文字列 | 所属会社名 | アイコン付き |
| ソースロケーション | 文字列 | 在庫の取得元ロケーション名 | アイコン付き |
| 宛先ロケーション | 文字列 | 在庫の配送先ロケーション名 | アイコン付き |
| 予約方法 | バッジ | 予約方法（確認時/手動/注文日前） | アイコン付き |
| 予約日数 | 数値 | 予約前日数 | 日単位 |
| バックオーダー作成 | バッジ | バックオーダー作成ポリシー | アイコン付き |
| 移動タイプ | バッジ | 内部移動タイプ | 内部移動時のみ表示 |
| 新規ロット作成 | アイコン | 新規ロット作成可否 | チェックアイコン |
| 既存ロット使用 | アイコン | 既存ロット使用可否 | チェックアイコン |
| 作成日時 | 日時 | レコード作成日時 | カレンダーアイコン付き |
| 作成者 | 文字列 | レコード作成者名 | ユーザーアイコン付き |
| 最終更新日時 | 日時 | レコード最終更新日時 | カレンダーアイコン付き |

## イベント仕様

### 1-編集ボタン押下

編集画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

なし（読み取り専用画面のため）

## メッセージ仕様

なし（読み取り専用画面のため）

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコード未存在 | 404エラーページを表示 |

## 備考

- Filament ResourceのViewRecordページを継承して実装されています。
- infolist（情報リスト）メソッドを使用して読み取り専用表示を構成しています。
- 各テキストエントリにはHeroiconアイコンが付与され、視覚的なわかりやすさを向上させています。
- バッジスタイルのエントリ（タイプ、予約方法、バックオーダー作成）はEnum値から自動的にラベルと色が設定されます。
- サブナビゲーションでは、詳細画面と編集画面の切り替えが可能です（getRecordSubNavigation）。
