# 画面設計書 126-ルール作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるルール作成画面の設計を定義します。

### 本画面の処理概要

ルール作成画面は、新規の補充ルール（プル/プッシュ/購買ルール）を登録するための画面です。

**業務上の目的・背景**：在庫補充を自動化するために、ルールを定義してロケーション間の在庫移動を制御します。プルルールは需要発生時に在庫を引き寄せ、プッシュルールは在庫到着時に次のロケーションへ送ります。

**画面へのアクセス方法**：ルール一覧画面の「新規作成」ボタンをクリック、または一覧画面の空状態時の「新規作成」アクションからアクセスします。

**主要な操作・処理内容**：
1. ルールの基本情報（名前）の入力
2. アクション（プル/プッシュ/プルプッシュ/購買）の選択
3. オペレーションタイプの選択
4. ソースロケーション・宛先ロケーションの設定
5. パートナー住所、リードタイムの設定
6. ルートと会社の設定

**画面遷移**：作成完了後はルール詳細画面に自動遷移します。キャンセル時は一覧画面に戻ります。

**権限による表示制御**：ログインユーザーのデフォルト会社が自動設定されます。アクションの選択によって一部のフィールドが表示/非表示になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-026 | ルール管理 | 主機能 | ルールの新規作成 |
| FN-INV-027 | ルート管理 | 関連機能 | ルートの選択 |
| FN-INV-024 | ロケーション管理 | 関連機能 | ソースロケーション・宛先ロケーションの選択 |
| FN-INV-025 | オペレーションタイプ管理 | 関連機能 | オペレーションタイプの選択 |

## 画面種別

登録

## URL/ルーティング

`/inventories/configurations/rules/create`

## 画面構成

- サブナビゲーション：設定クラスタのコンポーネント
- メインフォーム（3カラムレイアウト）
  - 左側（2カラム幅）：一般セクション
    - ルール名入力（大きなテキスト入力）
    - 2カラムグループ
      - 左：アクション、オペレーションタイプ、ソースロケーション、宛先ロケーション
      - 右：アクション情報プレースホルダー（動的説明文）
  - 右側（1カラム幅）：設定セクション
    - パートナー住所（プッシュ以外で表示）
    - リードタイム
    - フィールドセット：適用範囲
      - ルート（ManageRules、RulesRelationManagerでは非表示）
      - 会社

## 入出力項目

| 項目名 | 項目種別 | 入力/出力 | 必須 | 説明 |
|--------|----------|-----------|------|------|
| ルール名 | テキスト | 入力 | はい | ルールの名前（最大255文字） |
| アクション | セレクト | 入力 | はい | PULL/PUSH/PULL_PUSH/BUY |
| オペレーションタイプ | セレクト | 入力 | はい | 関連するオペレーションタイプ |
| ソースロケーション | セレクト | 入力 | はい | 在庫の取得元ロケーション |
| 宛先ロケーション | セレクト | 入力 | はい | 在庫の配送先ロケーション |
| パートナー住所 | セレクト | 入力 | いいえ | パートナーの住所（プッシュ以外で表示） |
| リードタイム | 数値 | 入力 | いいえ | リードタイム（日数、0以上） |
| ルート | セレクト | 入力 | はい | 関連ルート（一部画面で非表示） |
| 会社 | セレクト | 入力 | いいえ | 所属会社 |

## 表示項目

| 項目名 | データ型 | 説明 | 備考 |
|--------|----------|------|------|
| アクション情報 | HTML | アクションに応じた動的な説明文 | プル/プッシュ/購買の動作説明 |

## イベント仕様

### 1-アクション変更時

アクションを変更すると、説明プレースホルダーの内容が動的に変更されます：
- プル：「宛先ロケーションで製品が必要になると、オペレーションタイプのオペレーションがソースロケーションから作成され、需要を満たします」
- プッシュ：「ソースロケーションに製品が到着すると、オペレーションタイプのオペレーションが宛先ロケーションに送られます」
- プルプッシュ：両方のメッセージを表示
- 購買：「宛先ロケーションで製品が必要になると、購入依頼が作成されます」

また、アクションがプッシュの場合はパートナー住所フィールドが非表示になります。

### 2-オペレーションタイプ変更時

オペレーションタイプを変更すると、そのオペレーションタイプに設定されているソースロケーションと宛先ロケーションが自動的にフォームに設定されます。

### 3-作成ボタン押下

フォームデータを検証し、以下の処理を行います：
- creator_idをログインユーザーIDに設定
- company_idをログインユーザーのデフォルト会社IDに設定
- データベースにINSERT
- 成功通知を表示
- 作成したレコードの詳細画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | inventories_rules | INSERT | ルールの新規登録 |

### テーブル別更新項目詳細

#### inventories_rules

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | action | フォーム選択値 | Enum値（PULL/PUSH/PULL_PUSH/BUY） |
| INSERT | operation_type_id | フォーム選択値 | オペレーションタイプリレーション |
| INSERT | source_location_id | フォーム選択値 | ロケーションリレーション |
| INSERT | destination_location_id | フォーム選択値 | ロケーションリレーション |
| INSERT | partner_address_id | フォーム選択値 | パートナーリレーション（任意） |
| INSERT | delay | フォーム入力値 | リードタイム（日数） |
| INSERT | route_id | フォーム選択値 | ルートリレーション |
| INSERT | company_id | Auth::user()->default_company_id | 自動設定 |
| INSERT | creator_id | Auth::id() | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | タイトル | 本文 | 表示条件 |
|-------------|---------------|---------|------|----------|
| MSG-001 | 成功 | 作成成功 | ルールが正常に作成されました | 作成成功時 |
| MSG-002 | エラー | 検証エラー | 必須項目を入力してください | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 必須項目未入力 | フォームバリデーションエラーを表示 |
| ルートが削除済み | 選択肢のラベルに「(Deleted)」を表示し、選択不可にする |

## 備考

- Filament ResourceのCreateRecordページを継承して実装されています。
- アクション選択によって表示されるフィールドと説明文が動的に変化します（liveバインディング使用）。
- オペレーションタイプ選択時に、ソースロケーションと宛先ロケーションが自動的に設定されます（afterStateUpdated）。
- ManageRulesまたはRulesRelationManagerから表示される場合、ルートフィールドは非表示になります（関連リソースから作成されるため、ルートは自動設定）。
- パートナー住所フィールドからは、PartnerResourceのフォームを使用して新規パートナーを作成することも可能です（createOptionForm）。
