# 画面設計書 127-ルール編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるルール編集画面の設計を定義します。

### 本画面の処理概要

ルール編集画面は、既存の補充ルール（プル/プッシュ/購買ルール）の設定を変更するための画面です。

**業務上の目的・背景**：在庫補充ルールの設定を、業務要件の変化に応じて適宜更新する必要があります。

**画面へのアクセス方法**：ルール一覧画面または詳細画面から「編集」アクションをクリックしてアクセスします。

**主要な操作・処理内容**：
1. ルールの基本情報の編集
2. アクション・オペレーションタイプの変更
3. ソースロケーション・宛先ロケーションの変更
4. 既存レコードの削除

**画面遷移**：保存成功後は同画面に留まります。削除後は一覧画面に戻ります。ヘッダーから詳細画面にも遷移可能です。

**権限による表示制御**：作成画面と同様に、アクションの選択によってフィールドの表示/非表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-026 | ルール管理 | 主機能 | ルールの編集・削除 |
| FN-INV-027 | ルート管理 | 関連機能 | ルートの選択 |
| FN-INV-024 | ロケーション管理 | 関連機能 | ソースロケーション・宛先ロケーションの選択 |
| FN-INV-025 | オペレーションタイプ管理 | 関連機能 | オペレーションタイプの選択 |

## 画面種別

更新

## URL/ルーティング

`/inventories/configurations/rules/{record}/edit`

## 画面構成

- ヘッダーアクション：詳細表示ボタン、削除ボタン
- サブナビゲーション：設定クラスタのコンポーネント
- メインフォーム（3カラムレイアウト）
  - 左側（2カラム幅）：一般セクション
    - ルール名入力（大きなテキスト入力）
    - 2カラムグループ
      - 左：アクション、オペレーションタイプ、ソースロケーション、宛先ロケーション
      - 右：アクション情報プレースホルダー（動的説明文）
  - 右側（1カラム幅）：設定セクション
    - パートナー住所（プッシュ以外で表示）
    - リードタイム
    - フィールドセット：適用範囲
      - ルート
      - 会社

## 入出力項目

| 項目名 | 項目種別 | 入力/出力 | 必須 | 説明 |
|--------|----------|-----------|------|------|
| ルール名 | テキスト | 入力 | はい | ルールの名前（最大255文字） |
| アクション | セレクト | 入力 | はい | PULL/PUSH/PULL_PUSH/BUY |
| オペレーションタイプ | セレクト | 入力 | はい | 関連するオペレーションタイプ |
| ソースロケーション | セレクト | 入力 | はい | 在庫の取得元ロケーション |
| 宛先ロケーション | セレクト | 入力 | はい | 在庫の配送先ロケーション |
| パートナー住所 | セレクト | 入力 | いいえ | パートナーの住所（プッシュ以外で表示） |
| リードタイム | 数値 | 入力 | いいえ | リードタイム（日数、0以上） |
| ルート | セレクト | 入力 | はい | 関連ルート |
| 会社 | セレクト | 入力 | いいえ | 所属会社 |

## 表示項目

| 項目名 | データ型 | 説明 | 備考 |
|--------|----------|------|------|
| アクション情報 | HTML | アクションに応じた動的な説明文 | プル/プッシュ/購買の動作説明 |

## イベント仕様

### 1-保存ボタン押下

フォームデータを検証し、以下の処理を行います：
- データベースをUPDATE
- 成功通知を表示
- 編集後は同画面に留まる

### 2-詳細表示ボタン押下

編集中のレコードの詳細画面に遷移します。

### 3-削除ボタン押下

確認ダイアログの後、選択したレコードをソフトデリートします。成功時には成功通知が表示され、一覧画面に戻ります。

### 4-アクション変更時

アクションを変更すると、作成画面と同様に説明プレースホルダーの内容が動的に変更されます。

### 5-オペレーションタイプ変更時

オペレーションタイプを変更すると、ソースロケーションと宛先ロケーションが自動的に更新されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_rules | UPDATE | ルールの更新 |
| 削除ボタン押下 | inventories_rules | UPDATE | deleted_atカラムにタイムスタンプを設定（ソフトデリート） |

### テーブル別更新項目詳細

#### inventories_rules

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | action | フォーム選択値 | Enum値 |
| UPDATE | operation_type_id | フォーム選択値 | オペレーションタイプリレーション |
| UPDATE | source_location_id | フォーム選択値 | ロケーションリレーション |
| UPDATE | destination_location_id | フォーム選択値 | ロケーションリレーション |
| UPDATE | partner_address_id | フォーム選択値 | パートナーリレーション（任意） |
| UPDATE | delay | フォーム入力値 | リードタイム（日数） |
| UPDATE | route_id | フォーム選択値 | ルートリレーション |
| UPDATE | company_id | フォーム選択値 | 会社リレーション |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| UPDATE | deleted_at | 現在日時 | ソフトデリート時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | タイトル | 本文 | 表示条件 |
|-------------|---------------|---------|------|----------|
| MSG-001 | 成功 | 更新成功 | ルールが正常に更新されました | 保存成功時 |
| MSG-002 | 成功 | 削除成功 | ルールが正常に削除されました | 削除成功時 |
| MSG-003 | エラー | 検証エラー | 必須項目を入力してください | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 必須項目未入力 | フォームバリデーションエラーを表示 |
| レコード未存在 | 404エラーページを表示 |
| ルートが削除済み | 選択肢のラベルに「(Deleted)」を表示し、選択不可にする |

## 備考

- Filament ResourceのEditRecordページを継承して実装されています。
- フォーム構成は作成画面と同一です（RuleResource::form()を共有）。
- サブナビゲーションでは、設定クラスタの他のコンポーネントにアクセス可能です。
- 削除済みのルートも選択肢に表示されますが、選択不可になります（既存の関連付けは保持）。
