# 画面設計書 128-ルール詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるルール詳細画面の設計を定義します。

### 本画面の処理概要

ルール詳細画面は、既存の補充ルールの設定内容を読み取り専用で表示するための画面です。

**業務上の目的・背景**：ルールの現在の設定を確認し、必要に応じて編集画面に遷移して変更を行うための参照画面として使用されます。

**画面へのアクセス方法**：ルール一覧画面から「表示」アクションをクリック、または作成・編集完了後の自動遷移先としてアクセスします。

**主要な操作・処理内容**：
1. ルールの基本情報の表示
2. アクション・オペレーションタイプの表示
3. ロケーション設定の表示
4. ルート・会社情報の表示
5. 編集画面への遷移

**画面遷移**：ヘッダーから編集画面に遷移可能です。サブナビゲーションでも画面切り替えが可能です。

**権限による表示制御**：読み取り専用画面のため特別な権限制御はありませんが、編集アクションは適切な権限がある場合のみ利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-026 | ルール管理 | 主機能 | ルールの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/configurations/rules/{record}`

## 画面構成

- ヘッダーアクション：編集ボタン
- サブナビゲーション：設定クラスタのコンポーネント
- メインコンテンツ（3カラムレイアウト）
  - 左側（2カラム幅）：一般情報セクション
    - セクション説明：アクションに応じた動的な説明文
    - 2カラムグループ
      - 左：ルール名、アクション、オペレーションタイプ、ソースロケーション、宛先ロケーション
      - 右：ルート、会社、パートナー住所、リードタイム
  - 右側（1カラム幅）：レコード情報セクション
    - 作成日時、作成者、最終更新日時

## 入出力項目

なし（詳細表示画面のため）

## 表示項目

| 項目名 | データ型 | 説明 | 備考 |
|--------|----------|------|------|
| ルール名 | 文字列 | ルールの名前 | 大きなテキスト、太字、アイコン付き |
| アクション | バッジ | ルールアクション（プル/プッシュ等） | アイコン付き |
| オペレーションタイプ | 文字列 | 関連オペレーションタイプ名 | アイコン付き |
| ソースロケーション | 文字列 | 在庫の取得元ロケーション名 | アイコン付き |
| 宛先ロケーション | 文字列 | 在庫の配送先ロケーション名 | アイコン付き |
| ルート | 文字列 | 関連ルート名 | アイコン付き |
| 会社 | 文字列 | 所属会社名 | アイコン付き |
| パートナー住所 | 文字列 | パートナーの住所 | アイコン付き、未設定時は「-」 |
| リードタイム | 数値 | リードタイム | 日数サフィックス付き、未設定時は「0」 |
| 作成日時 | 日時 | レコード作成日時 | カレンダーアイコン付き |
| 作成者 | 文字列 | レコード作成者名 | ユーザーアイコン付き |
| 最終更新日時 | 日時 | レコード最終更新日時 | カレンダーアイコン付き |

## イベント仕様

### 1-編集ボタン押下

編集画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

なし（読み取り専用画面のため）

## メッセージ仕様

なし（読み取り専用画面のため）

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコード未存在 | 404エラーページを表示 |

## 備考

- Filament ResourceのViewRecordページを継承して実装されています。
- infolist（情報リスト）メソッドを使用して読み取り専用表示を構成しています。
- セクション説明として、アクションに応じた動的な説明文が表示されます：
  - プル：「宛先ロケーションで製品が必要になると、オペレーションがソースロケーションから作成されます」
  - プッシュ：「ソースロケーションに製品が到着すると、オペレーションが宛先ロケーションに送られます」
  - プルプッシュ：両方のメッセージを表示
- 各テキストエントリにはHeroiconアイコンが付与され、視覚的なわかりやすさを向上させています。
- バッジスタイルのエントリ（アクション）はEnum値から自動的にラベルと色が設定されます。
- リードタイムには「days」サフィックスが付与されます。
- サブナビゲーションでは、設定クラスタの他のコンポーネントにアクセス可能です。
