# 画面設計書 129-ロケーション一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるロケーション一覧画面の設計を定義します。

### 本画面の処理概要

ロケーション一覧画面は、在庫管理における物理的・論理的なロケーション（保管場所）を一覧形式で表示・管理するための画面です。

**業務上の目的・背景**：在庫管理において、商品の保管場所を正確に把握し管理することは、効率的なピッキングや在庫追跡に不可欠です。ロケーションは倉庫内の棚や区画、仮想的なロケーション（顧客、仕入先、廃棄場所等）を表します。

**画面へのアクセス方法**：ダッシュボードから「在庫」モジュールを選択し、「設定」クラスタ内の「ロケーション」メニューをクリックしてアクセスします。この機能はロケーション設定（enable_locations）が有効な場合のみ表示されます。

**主要な操作・処理内容**：
1. ロケーションの一覧表示（ロケーション名、タイプ、ストレージカテゴリ、会社等）
2. タブ切り替えによるタイプ別絞り込み表示（すべて/内部/顧客/製造/仕入先/アーカイブ済み）
3. 検索・フィルタ機能による絞り込み
4. グループ化機能による倉庫別・タイプ別・日付別の表示切り替え
5. 新規ロケーションの作成
6. 既存ロケーションの編集・詳細表示・削除・復元・完全削除
7. バーコード印刷

**画面遷移**：この画面からロケーション作成画面、詳細画面、編集画面に遷移できます。

**権限による表示制御**：ログインユーザーの所属会社に基づいてデフォルトの会社IDが設定されます。削除されたレコードは「アーカイブ済み」タブでのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-024 | ロケーション管理 | 主機能 | ロケーションの一覧表示・作成・編集・削除 |
| FN-INV-023 | 倉庫管理 | 関連機能 | ロケーションと倉庫の紐付け |
| FN-INV-028 | ストレージカテゴリ管理 | 関連機能 | ロケーションとストレージカテゴリの紐付け |

## 画面種別

一覧

## URL/ルーティング

`/inventories/configurations/locations`

## 画面構成

- ヘッダーアクション：新規作成ボタン
- タブナビゲーション：「すべて」「内部」（デフォルト）「顧客」「製造」「仕入先」「アーカイブ済み」
- データテーブル：ロケーション一覧
- フィルタパネル：タイプ、ストレージカテゴリ、会社によるフィルタ
- グループ化オプション：倉庫別、タイプ別、作成日別、更新日別
- 行アクション：表示（モーダル6xl）、編集（モーダル6xl）、復元、削除、完全削除
- 一括アクション：印刷、一括復元、一括削除、一括完全削除
- 空状態アクション：新規作成

## 入出力項目

| 項目名 | 項目種別 | 入力/出力 | 必須 | 説明 |
|--------|----------|-----------|------|------|
| ロケーション名 | テキスト | 入力（作成モーダル） | はい | ロケーションの名前 |

## 表示項目

| 項目名 | データ型 | 説明 | 備考 |
|--------|----------|------|------|
| ロケーション | 文字列 | ロケーションのフルパス名 | 検索可能 |
| タイプ | 文字列 | ロケーションタイプ | 検索可能 |
| ストレージカテゴリ | 文字列 | 関連ストレージカテゴリ名 | リレーション、未設定時は「-」 |
| 会社 | 文字列 | 所属会社名 | リレーション |
| 削除日時 | 日時 | レコード削除日時 | デフォルト非表示、トグル可能 |
| 作成日時 | 日時 | レコード作成日時 | デフォルト非表示、トグル可能 |
| 更新日時 | 日時 | レコード更新日時 | デフォルト非表示、トグル可能 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「新規作成」ボタンをクリックすると、インラインで新規作成フォームが表示されます。作成者IDと会社IDはログインユーザーから自動設定されます。作成成功時には成功通知が表示され、一覧が更新されます。

### 2-タブ切り替え

以下のタブで絞り込み表示が可能です：
- 「すべて」：全ロケーション
- 「内部」（デフォルト）：内部ロケーションのみ
- 「顧客」：顧客ロケーションのみ
- 「製造」：製造ロケーションのみ
- 「仕入先」：仕入先ロケーションのみ
- 「アーカイブ済み」：削除済みのロケーションのみ

各タブにはレコード件数がバッジで表示されます。

### 3-表示アクション押下

選択したレコードの詳細を6xlサイズのモーダルで表示します。削除済みレコードでは非表示になります。

### 4-編集アクション押下

選択したレコードの編集フォームを6xlサイズのモーダルで表示します。削除済みレコードでは非表示になります。編集成功時には成功通知が表示されます。

### 5-削除アクション押下

選択したレコードをソフトデリートします。成功時には成功通知が表示されます。

### 6-復元アクション押下

削除済みのレコードを復元します。成功時には成功通知が表示されます。

### 7-完全削除アクション押下

選択したレコードをデータベースから完全に削除します。外部キー制約違反時にはエラー通知が表示され、操作がキャンセルされます。

### 8-印刷アクション押下

選択したロケーションのバーコードをPDFとして生成し、ダウンロードします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | inventories_locations | INSERT | ロケーションの新規登録 |
| 削除 | inventories_locations | UPDATE | deleted_atカラムにタイムスタンプを設定（ソフトデリート） |
| 復元 | inventories_locations | UPDATE | deleted_atカラムをNULLに設定 |
| 完全削除 | inventories_locations | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### inventories_locations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | ロケーション名 |
| INSERT | full_name | 自動計算 | 親ロケーションパス + 名前 |
| INSERT | parent_path | 自動計算 | 親ロケーションのパス + ID |
| INSERT | creator_id | Auth::user()->id | 作成者ID |
| INSERT | company_id | Auth::user()->defaultCompany?.id | 所属会社ID |
| INSERT | created_at | 現在日時 | 自動設定 |
| UPDATE | deleted_at | 現在日時/NULL | ソフトデリート/復元 |

## メッセージ仕様

| メッセージID | メッセージ種別 | タイトル | 本文 | 表示条件 |
|-------------|---------------|---------|------|----------|
| MSG-001 | 成功 | 作成成功 | ロケーションが正常に作成されました | 新規作成成功時 |
| MSG-002 | 成功 | 編集成功 | ロケーションが正常に更新されました | 編集成功時 |
| MSG-003 | 成功 | 復元成功 | ロケーションが正常に復元されました | 復元成功時 |
| MSG-004 | 成功 | 削除成功 | ロケーションが正常に削除されました | 削除成功時 |
| MSG-005 | 成功 | 完全削除成功 | ロケーションが完全に削除されました | 完全削除成功時 |
| MSG-006 | エラー | 完全削除エラー | このロケーションは使用中のため削除できません | 外部キー制約違反時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データ未存在 | 空状態表示と新規作成ボタンの表示 |
| 外部キー制約違反（完全削除時） | エラー通知を表示し、削除をキャンセル |
| ロケーション設定未有効 | 画面が非表示（isDiscovered()でfalseを返す） |

## 備考

- ロケーション機能はロケーション設定（enable_locations）が有効な場合のみ利用可能です。
- Filament ResourceのListRecordsページを継承して実装されています。
- ソフトデリート機能（SoftDeletes）が有効であり、削除されたレコードは「アーカイブ済み」タブで管理されます。
- デフォルトで「内部」タブがアクティブになります（getDefaultActiveTab()）。
- ロケーションは階層構造を持ち、親ロケーションを設定することで、full_nameとparent_pathが自動計算されます。
- 印刷機能ではbarryvdh/laravel-dompdfを使用してバーコードPDFを生成します。
- StorageCategoryResourceのManageLocationsページからもアクセスされる場合があり、その場合はストレージカテゴリカラムが非表示になります。
