# 画面設計書 13-現金丸め編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける「現金丸め編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

現金丸め編集画面は、会計モジュールにおいて既存の現金丸め設定を変更するための画面である。

**業務上の目的・背景**：企業の会計方針変更や取引先との契約条件変更に伴い、既存の現金丸め設定を修正する必要がある場合に使用する。丸め精度や丸め方法を変更することで、以降の請求書や支払処理に適用される端数処理ルールを更新できる。

**画面へのアクセス方法**：
1. 現金丸め一覧画面の各行の「編集」アクションから遷移
2. 現金丸め詳細画面のヘッダーの「編集」ボタンから遷移
3. URL直接入力でもアクセス可能

**主要な操作・処理内容**：
1. 既存の現金丸め設定の名前を編集
2. 丸め精度（rounding precision）を変更
3. 丸め戦略を変更
4. 丸め方法を変更
5. 保存ボタンで変更を確定
6. 削除ボタンでレコードを削除

**画面遷移**：
- 保存成功時：現金丸め詳細画面（ViewCashRounding）へ自動遷移
- 「表示」アクション：現金丸め詳細画面へ遷移
- 削除成功時：現金丸め一覧画面へ遷移

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、編集権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-015 | 現金端数処理管理 | 主機能 | 現金丸め設定の編集 |
| FN-ACC-028 | 現金端数処理管理 | 主機能 | 編集/削除処理 |

## 画面種別

編集

## URL/ルーティング

`/admin/accounts/cash-roundings/{record}/edit`

## 画面構成

1. **ヘッダーアクションエリア**
   - 「表示」ボタン（ViewAction）
   - 「削除」ボタン（DeleteAction）

2. **フォームセクション**
   - 2カラムレイアウトのGroupコンポーネント内にフォームフィールドを配置
   - 作成画面と同一のフォーム構成

3. **入力フィールドエリア**
   - 名前（TextInput）
   - 丸め精度（TextInput - 数値）
   - 丸め戦略（Select）
   - 丸め方法（Select）

4. **アクションエリア**
   - 保存ボタン（Filament標準）
   - キャンセルボタン（Filament標準）

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| 名前 | name | string | 必須 | 既存値 | 現金丸め設定の名称 |
| 丸め精度 | rounding | numeric | 必須 | 既存値 | 丸め精度（0〜99999999999） |
| 丸め戦略 | strategy | enum | 任意 | 既存値 | 丸め戦略の種類 |
| 丸め方法 | rounding_method | enum | 必須 | 既存値 | 丸め方法の種類 |

## 表示項目

該当なし（編集画面のため出力専用項目なし）

## イベント仕様

### 1-保存ボタン押下

フォームの入力内容をバリデーション後、データベースのレコードを更新する。更新成功時は成功通知を表示し、詳細画面へ遷移する。

### 2-表示アクション

ヘッダーの「表示」ボタン押下時、該当レコードの詳細画面（ViewCashRounding）へ遷移する。

### 3-削除アクション

ヘッダーの「削除」ボタン押下時、確認後にレコードを削除し、成功通知を表示して一覧画面へ遷移する。

### 4-キャンセル

入力内容を破棄し、元の画面へ戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_cash_roundings | UPDATE | 既存レコードの更新 |
| 削除アクション | accounts_cash_roundings | DELETE | レコードの削除 |

### テーブル別更新項目詳細

#### accounts_cash_roundings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | rounding | フォーム入力値 | - |
| UPDATE | strategy | フォーム選択値 | - |
| UPDATE | rounding_method | フォーム選択値 | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| DELETE | - | WHERE id = レコードID | 物理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 更新成功通知（タイトル・本文） | レコード更新成功時 |
| 成功 | 削除成功通知（タイトル・本文） | レコード削除成功時 |
| エラー | バリデーションエラー | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラー表示 |
| バリデーションエラー | エラーメッセージを該当フィールドに表示 |
| データベースエラー | Filament標準のエラー処理 |
| 権限不足 | アクセス拒否エラー表示 |

## 備考

- フォーム構成は作成画面（CreateCashRounding）と同一のformメソッドを使用
- 保存成功後のリダイレクト先は詳細画面（view）
- ヘッダーアクションにViewActionとDeleteActionが配置されている
- 削除時の成功通知は多言語対応キーで定義されている
