# 画面設計書 130-ロケーション作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるロケーション作成画面の設計を定義します。

### 本画面の処理概要

ロケーション作成画面は、新規のロケーション（保管場所）を登録するための画面です。

**業務上の目的・背景**：在庫管理において、商品を保管する新しい場所（倉庫内の棚、区画、または仮想的なロケーション）を定義するために使用されます。ロケーションは階層構造を持ち、親ロケーションの下に子ロケーションを作成できます。

**画面へのアクセス方法**：ロケーション一覧画面の「新規作成」ボタンをクリック、または一覧画面の空状態時の「新規作成」アクションからアクセスします。

**主要な操作・処理内容**：
1. ロケーションの基本情報（名前）の入力
2. 親ロケーションの選択（階層構造）
3. ロケーションタイプの選択
4. ストレージカテゴリの設定
5. スクラップ/ドック/補充フラグの設定
6. 棚卸頻度の設定

**画面遷移**：作成完了後はロケーション詳細画面に自動遷移します。キャンセル時は一覧画面に戻ります。

**権限による表示制御**：ログインユーザーのデフォルト会社が自動設定されます。ロケーションタイプによって一部のフィールドが表示/非表示になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-024 | ロケーション管理 | 主機能 | ロケーションの新規作成 |
| FN-INV-023 | 倉庫管理 | 関連機能 | 親ロケーションからの倉庫ID継承 |
| FN-INV-028 | ストレージカテゴリ管理 | 関連機能 | ストレージカテゴリの選択 |

## 画面種別

登録

## URL/ルーティング

`/inventories/configurations/locations/create`

## 画面構成

- サブナビゲーション位置：Start
- サブナビゲーション：設定クラスタのコンポーネント
- メインフォーム（3カラムレイアウト）
  - 左側（2カラム幅）：一般セクション
    - ロケーション名入力（大きなテキスト入力、プレースホルダー「例：Shelf A」）
    - 親ロケーション選択（ヒントアイコン付き）
    - 外部メモ（リッチエディタ）
  - 右側（1カラム幅）：設定セクション
    - ロケーションタイプ選択（内部/仕入先/顧客/在庫紛失/製造/トランジット/ビュー）
    - 会社選択
    - ストレージカテゴリ選択（内部タイプのみ表示、新規作成可能）
    - スクラップフラグ（内部/在庫紛失タイプのみ表示）
    - ドックフラグ
    - 補充フラグ（内部タイプのみ表示）
    - フィールドセット：棚卸カウント（内部/トランジットタイプのみ表示）
      - 棚卸頻度（日数）
      - 最終棚卸日（プレースホルダー）
      - 次回予定日（プレースホルダー）

## 入出力項目

| 項目名 | 項目種別 | 入力/出力 | 必須 | 説明 |
|--------|----------|-----------|------|------|
| ロケーション名 | テキスト | 入力 | はい | ロケーションの名前（最大255文字） |
| 親ロケーション | セレクト | 入力 | いいえ | 上位ロケーション（階層構造用） |
| 外部メモ | リッチテキスト | 入力 | いいえ | ロケーションの説明や注記 |
| ロケーションタイプ | セレクト | 入力 | はい | INTERNAL/SUPPLIER/CUSTOMER/INVENTORY/PRODUCTION/TRANSIT/VIEW |
| 会社 | セレクト | 入力 | いいえ | 所属会社（デフォルト：ログインユーザーのデフォルト会社） |
| ストレージカテゴリ | セレクト | 入力 | いいえ | 内部タイプのみ表示 |
| スクラップ | トグル | 入力 | いいえ | スクラップロケーションかどうか |
| ドック | トグル | 入力 | いいえ | ドック（入出荷場）かどうか |
| 補充 | トグル | 入力 | いいえ | 補充対象ロケーションかどうか |
| 棚卸頻度 | 数値 | 入力 | いいえ | 棚卸の間隔（日数） |

## 表示項目

| 項目名 | データ型 | 説明 | 備考 |
|--------|----------|------|------|
| 最終棚卸日 | 日時 | 最後に棚卸を行った日付 | プレースホルダー、未設定時は「-」 |
| 次回予定日 | 日時 | 次回棚卸予定日 | プレースホルダー、未設定時は「-」 |

## イベント仕様

### 1-ロケーションタイプ変更時

ロケーションタイプを変更すると、以下が自動更新されます：
- 内部/在庫紛失以外のタイプ：スクラップフラグをfalseに設定
- 内部以外のタイプ：ストレージカテゴリをnullに設定、補充フラグをfalseに設定

また、以下のフィールドの表示/非表示が切り替わります：
- ストレージカテゴリ：内部タイプのみ表示
- スクラップ：内部/在庫紛失タイプのみ表示
- 補充：内部タイプのみ表示
- 棚卸フィールドセット：内部/トランジットタイプのみ表示

### 2-作成ボタン押下

フォームデータを検証し、以下の処理を行います：
- creator_idをログインユーザーIDに設定
- 親ロケーションからwarehouse_idを継承
- 棚卸頻度が設定されている場合、next_inventory_dateを計算（現在日時 + 頻度日数）
- full_nameを自動計算（親ロケーションのfull_name + "/" + 名前）
- parent_pathを自動計算（親ロケーションのparent_path + ID + "/"）
- データベースにINSERT
- 成功通知を表示
- 作成したレコードの詳細画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | inventories_locations | INSERT | ロケーションの新規登録 |

### テーブル別更新項目詳細

#### inventories_locations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | full_name | 自動計算 | 親.full_name + "/" + name |
| INSERT | parent_path | 自動計算 | 親.parent_path + id + "/" |
| INSERT | description | フォーム入力値 | リッチテキスト |
| INSERT | parent_id | フォーム選択値 | 親ロケーションリレーション |
| INSERT | type | フォーム選択値 | Enum値（LocationType） |
| INSERT | company_id | フォーム選択値 | 会社リレーション |
| INSERT | storage_category_id | フォーム選択値 | ストレージカテゴリリレーション |
| INSERT | is_scrap | フォーム入力値 | ブール値 |
| INSERT | is_dock | フォーム入力値 | ブール値 |
| INSERT | is_replenish | フォーム入力値 | ブール値 |
| INSERT | cyclic_inventory_frequency | フォーム入力値 | 整数（日数） |
| INSERT | next_inventory_date | 自動計算 | now() + cyclic_inventory_frequency日 |
| INSERT | warehouse_id | 親ロケーションから継承 | 倉庫リレーション |
| INSERT | creator_id | Auth::id() | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | タイトル | 本文 | 表示条件 |
|-------------|---------------|---------|------|----------|
| MSG-001 | 成功 | 作成成功 | ロケーションが正常に作成されました | 作成成功時 |
| MSG-002 | エラー | 検証エラー | 必須項目を入力してください | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 必須項目未入力 | フォームバリデーションエラーを表示 |
| 親ロケーション未存在 | 通常のnullハンドリングで対応 |

## 備考

- Filament ResourceのCreateRecordページを継承して実装されています。
- ロケーションタイプ選択によって表示されるフィールドが動的に変化します（liveバインディング使用）。
- 親ロケーションを設定すると、full_nameとparent_pathが自動計算されます（Modelのbootメソッドで処理）。
- 親ロケーションからwarehouse_idを自動継承することで、倉庫との関連付けが維持されます。
- 棚卸頻度を設定すると、次回棚卸予定日が自動計算されます。
- サブナビゲーションの位置はStart（上部）に設定されています。
- ストレージカテゴリフィールドからは、StorageCategoryResourceのフォームを使用して新規ストレージカテゴリを作成することも可能です（createOptionForm）。
- StorageCategoryResourceのManageLocationsページからアクセスされる場合、ストレージカテゴリフィールドは非表示になります。
