# 画面設計書 131-ロケーション編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるロケーション編集画面の設計仕様を定義するものです。

### 本画面の処理概要

ロケーション編集画面は、倉庫内の保管場所（ロケーション）の情報を変更するための画面です。

**業務上の目的・背景**：倉庫管理において、ロケーション情報は在庫の正確な位置管理に不可欠です。業務拡大や倉庫レイアウトの変更に伴い、ロケーションの種別変更、保管カテゴリの割り当て変更、循環棚卸頻度の調整などが必要となります。本画面は、これらの変更を安全かつ効率的に行うことを目的としています。

**画面へのアクセス方法**：在庫モジュール > 設定 > ロケーション一覧画面からレコードを選択し、詳細画面の「編集」ボタンをクリック、またはテーブルの行アクションから「編集」を選択してアクセスします。

**主要な操作・処理内容**：
1. ロケーション名の変更
2. 親ロケーションの変更（階層構造の変更）
3. ロケーション種別（内部、顧客、仕入先、在庫調整、生産、トランジット、表示）の変更
4. 保管カテゴリの割り当て変更
5. 廃棄ロケーション、ドックロケーション、補充ロケーションフラグの設定
6. 循環棚卸頻度の設定
7. ロケーション情報のPDF印刷
8. ロケーションの削除

**画面遷移**：ロケーション一覧画面、ロケーション詳細画面から遷移。保存後はロケーション詳細画面へ遷移。削除時はロケーション一覧画面へ遷移。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。倉庫設定でロケーション機能が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-024 | ロケーション管理 | 主機能 | ロケーションの編集・更新処理 |
| FN-INV-028 | ストレージカテゴリ管理 | 補助機能 | 保管カテゴリの選択・割り当て |
| FN-INV-023 | 倉庫管理 | 遷移先機能 | 関連する倉庫情報の参照 |

## 画面種別

編集

## URL/ルーティング

`/inventories/configurations/locations/{record}/edit`

## 画面構成

- ヘッダーエリア
  - 印刷ボタン（PDF出力）
  - 削除ボタン
  - 詳細/編集タブナビゲーション
- メインコンテンツエリア（3カラムレイアウト）
  - 左側（2カラム幅）
    - 一般セクション
      - ロケーション名入力フィールド
      - 親ロケーション選択フィールド
      - 外部メモリッチエディタ
  - 右側（1カラム幅）
    - 設定セクション
      - ロケーション種別選択
      - 会社選択
      - 保管カテゴリ選択
      - 廃棄ロケーショントグル
      - ドックロケーショントグル
      - 補充ロケーショントグル
      - 循環棚卸フィールドセット
- フッターエリア
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| ロケーション名 | name | テキスト | ○ | 255 | 入力 | ロケーションの名称 |
| 親ロケーション | parent_id | 選択 | - | - | 入力 | 親となるロケーション |
| 外部メモ | description | リッチテキスト | - | - | 入力 | 外部向けの説明文 |
| ロケーション種別 | type | 選択 | ○ | - | 入力 | Internal/Customer/Supplier/Inventory/Production/Transit/View |
| 会社 | company_id | 選択 | - | - | 入力 | 所属会社 |
| 保管カテゴリ | storage_category_id | 選択 | - | - | 入力 | 割り当てる保管カテゴリ |
| 廃棄ロケーション | is_scrap | トグル | - | - | 入力 | 廃棄品保管場所フラグ |
| ドックロケーション | is_dock | トグル | - | - | 入力 | 入出荷ドックフラグ |
| 補充ロケーション | is_replenish | トグル | - | - | 入力 | 補充対象ロケーションフラグ |
| 棚卸頻度（日） | cyclic_inventory_frequency | 数値 | - | - | 入力 | 循環棚卸の間隔日数 |
| 最終棚卸日 | last_inventory_date | 日付 | - | - | 出力 | 最後に棚卸を実施した日付 |
| 次回棚卸予定日 | next_inventory_date | 日付 | - | - | 出力 | 次回棚卸予定日（自動計算） |

## 表示項目

| 項目名 | 表示位置 | 形式 | 説明 |
|--------|----------|------|------|
| 最終棚卸日 | 循環棚卸フィールドセット | 日付 | Placeholderとして表示 |
| 次回棚卸予定日 | 循環棚卸フィールドセット | 日付 | Placeholderとして表示 |

## イベント仕様

### 1-印刷ボタン押下

ヘッダーの印刷ボタンをクリックすると、現在のロケーション情報をPDF形式で出力し、`Location-{ロケーション名}.pdf`というファイル名でダウンロードします。

### 2-保存ボタン押下

フォームの入力内容を検証し、問題なければデータベースに保存します。保存成功時は成功通知を表示し、次回棚卸予定日を棚卸頻度から自動計算して更新します。

### 3-削除ボタン押下

確認ダイアログを表示し、確認後にロケーションをソフトデリートします。削除成功時は成功通知を表示し、一覧画面へリダイレクトします。

### 4-ロケーション種別変更

ロケーション種別を変更すると、関連するフィールドの表示/非表示が動的に切り替わります：
- Internal以外を選択：保管カテゴリ、補充ロケーションフラグが非表示
- Internal/Inventory以外を選択：廃棄ロケーションフラグが非表示
- Internal/Transit以外を選択：循環棚卸フィールドセットが非表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_locations | UPDATE | ロケーション情報の更新 |
| 削除ボタン押下 | inventories_locations | UPDATE (Soft Delete) | deleted_atカラムに日時を設定 |

### テーブル別更新項目詳細

#### inventories_locations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | |
| UPDATE | parent_id | フォーム入力値 | |
| UPDATE | description | フォーム入力値 | |
| UPDATE | type | フォーム入力値 | LocationType enum値 |
| UPDATE | company_id | フォーム入力値 | |
| UPDATE | storage_category_id | フォーム入力値 | type=Internal時のみ |
| UPDATE | is_scrap | フォーム入力値 | |
| UPDATE | is_dock | フォーム入力値 | |
| UPDATE | is_replenish | フォーム入力値 | |
| UPDATE | cyclic_inventory_frequency | フォーム入力値 | |
| UPDATE | next_inventory_date | 現在日+棚卸頻度日数 | 自動計算 |
| UPDATE | full_name | 自動計算 | 親ロケーション変更時に再計算 |
| UPDATE | parent_path | 自動計算 | 親ロケーション変更時に再計算 |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| UPDATE (Soft Delete) | deleted_at | 現在日時 | 削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Location updated successfully | 保存成功時 |
| MSG-002 | 成功 | Location deleted successfully | 削除成功時 |
| MSG-003 | エラー | Validation error | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| レコードが存在しない | 404エラーページ表示 | Record not found |
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| 子ロケーションが存在する状態での削除 | 削除処理中止 | Cannot delete location with children |
| 在庫が存在する状態での削除 | 削除処理中止 | Cannot delete location with inventory |

## 備考

- ロケーションの親子関係を変更すると、full_nameとparent_pathが自動的に再計算され、子ロケーションにも伝播します
- 棚卸頻度を設定すると、次回棚卸予定日が現在日から自動計算されます
- 保管カテゴリは新規作成オプションを備えており、モーダルから直接作成可能です
- ソフトデリート方式を採用しているため、削除後も復元が可能です
