# 画面設計書 132-ロケーション詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるロケーション詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

ロケーション詳細画面は、倉庫内の保管場所（ロケーション）の詳細情報を閲覧するための画面です。

**業務上の目的・背景**：倉庫管理において、各ロケーションの詳細情報（種別、設定、棚卸状況など）を把握することは、在庫配置の最適化や棚卸計画の策定に重要です。本画面は、ロケーションに関するすべての情報を一覧性高く表示し、必要に応じて印刷・編集・削除などの操作へスムーズに移行できることを目的としています。

**画面へのアクセス方法**：在庫モジュール > 設定 > ロケーション一覧画面からレコードを選択してアクセスします。または、テーブルの行アクションから「表示」を選択してアクセスします。

**主要な操作・処理内容**：
1. ロケーション情報の詳細表示
2. 親ロケーション情報の確認
3. 保管カテゴリの確認
4. 循環棚卸設定の確認（頻度、最終棚卸日、次回予定日）
5. ロケーション情報のPDF印刷
6. 編集画面への遷移
7. ロケーションの削除

**画面遷移**：ロケーション一覧画面から遷移。編集ボタンでロケーション編集画面へ遷移。削除時はロケーション一覧画面へ遷移。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。倉庫設定でロケーション機能が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-024 | ロケーション管理 | 主機能 | ロケーション情報の表示 |
| FN-INV-028 | ストレージカテゴリ管理 | 補助機能 | 保管カテゴリ情報の表示 |
| FN-INV-023 | 倉庫管理 | 遷移先機能 | 関連する倉庫情報の参照 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/configurations/locations/{record}`

## 画面構成

- ヘッダーエリア
  - 印刷ボタン（PDF出力）
  - 削除ボタン
  - 詳細/編集タブナビゲーション
- メインコンテンツエリア（3カラムレイアウト）
  - 左側（2カラム幅）
    - 一般セクション（2カラム構成）
      - ロケーション名（アイコン付き、大文字、太字）
      - 親ロケーション（アイコン付き）
      - 外部メモ（Markdown表示）
      - ロケーション種別（アイコン付き）
      - 会社名（アイコン付き）
      - 保管カテゴリ（アイコン付き）
    - 設定セクション（2カラム構成）
      - 廃棄ロケーションアイコン
      - ドックロケーションアイコン
      - 補充ロケーションアイコン
      - 循環棚卸フィールドセット
        - 棚卸頻度
        - 最終棚卸日
        - 次回棚卸予定日
  - 右側（1カラム幅）
    - レコード情報セクション
      - 作成日時
      - 作成者
      - 最終更新日時

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

| 項目名 | 表示位置 | 形式 | 説明 |
|--------|----------|------|------|
| ロケーション名 | 一般セクション | テキスト（大、太字） | map-pinアイコン付き |
| 親ロケーション | 一般セクション | テキスト | building-office-2アイコン付き |
| 外部メモ | 一般セクション | Markdown | プレースホルダー「—」 |
| ロケーション種別 | 一般セクション | Enum表示 | tagアイコン付き |
| 会社名 | 一般セクション | テキスト | building-officeアイコン付き |
| 保管カテゴリ | 一般セクション | テキスト | archive-boxアイコン付き |
| 廃棄ロケーション | 設定セクション | アイコン | Boolean表示 |
| ドックロケーション | 設定セクション | アイコン | Boolean表示 |
| 補充ロケーション | 設定セクション | アイコン | Boolean表示 |
| 棚卸頻度 | 循環棚卸フィールドセット | 数値 | clockアイコン付き |
| 最終棚卸日 | 循環棚卸フィールドセット | 日付 | calendarアイコン付き |
| 次回棚卸予定日 | 循環棚卸フィールドセット | 日付 | calendar-daysアイコン付き |
| 作成日時 | レコード情報セクション | 日時 | calendarアイコン付き |
| 作成者 | レコード情報セクション | テキスト | userアイコン付き |
| 最終更新日時 | レコード情報セクション | 日時 | calendar-daysアイコン付き |

## イベント仕様

### 1-印刷ボタン押下

ヘッダーの印刷ボタンをクリックすると、現在のロケーション情報をPDF形式で出力し、`Location-{ロケーション名}.pdf`というファイル名でダウンロードします。

### 2-削除ボタン押下

確認ダイアログを表示し、確認後にロケーションをソフトデリートします。削除成功時は成功通知を表示し、一覧画面へリダイレクトします。

### 3-編集タブクリック

ロケーション編集画面へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | inventories_locations | SELECT | ロケーション情報の取得 |
| 削除ボタン押下 | inventories_locations | UPDATE (Soft Delete) | deleted_atカラムに日時を設定 |

### テーブル別更新項目詳細

#### inventories_locations（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE (Soft Delete) | deleted_at | 現在日時 | 削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Location deleted successfully | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| レコードが存在しない | 404エラーページ表示 | Record not found |
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| 削除済みレコード | 詳細表示不可、一覧で削除済みとして表示 | - |

## 備考

- 詳細画面はViewRecordを継承しており、データは読み取り専用で表示されます
- HasRecordNavigationTabsトレイトを使用しており、詳細/編集タブ間をシームレスに移動できます
- 削除済みレコードへのアクセス時は適切にハンドリングされます
- ロケーション種別はLocationType enumを使用してラベル表示されます
- 保管カテゴリ情報はリレーションを通じて取得・表示されます
