# 画面設計書 133-パッケージング管理

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおけるパッケージング管理画面の設計仕様を定義するものです。

### 本画面の処理概要

パッケージング管理画面は、商品のパッケージング情報を一覧表示し、作成・編集・削除・印刷を行うための統合管理画面です。

**業務上の目的・背景**：在庫管理において、商品のパッケージング単位（ケース、パレット等）を適切に管理することは、入出荷作業の効率化、在庫数量の正確な把握、物流コストの最適化に不可欠です。本画面は、パッケージング情報の一元管理を実現し、商品とパッケージタイプ、配送ルートとの紐付けを可能にします。

**画面へのアクセス方法**：在庫モジュール > 設定 > パッケージングメニューからアクセスします。商品設定でパッケージング機能が有効な場合のみ表示されます。

**主要な操作・処理内容**：
1. パッケージング一覧の表示・検索・フィルタリング
2. 新規パッケージングの作成（モーダル）
3. 既存パッケージングの編集（モーダル）
4. パッケージングの削除（単体・一括）
5. パッケージングバーコードのPDF一括印刷
6. 商品・パッケージタイプ・ルートとの関連付け

**画面遷移**：在庫設定メニューから遷移。モーダルでの作成・編集・詳細表示のため、他画面への遷移は基本的にありません。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。パッケージタイプ選択はオペレーション設定でパッケージ機能が有効な場合のみ表示。ルート選択は倉庫設定でマルチステップルートが有効な場合のみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-026 | パッケージング管理 | 主機能 | パッケージングのCRUD操作 |
| FN-INV-029 | パッケージタイプ管理 | 補助機能 | パッケージタイプの選択・関連付け |
| FN-INV-026 | ルート管理 | 補助機能 | 配送ルートの選択・関連付け |
| FN-INV-020 | 在庫商品一覧 | 遷移先機能 | 関連商品情報の参照 |

## 画面種別

管理（ManageRecords）

## URL/ルーティング

`/inventories/configurations/packagings`

## 画面構成

- ヘッダーエリア
  - 新規作成ボタン
- テーブルエリア
  - データテーブル（列構成下記）
  - グループ化オプション
  - フィルタオプション
  - 行アクション（表示・編集・削除）
  - 一括アクション（印刷・削除）
- 空状態エリア（データなし時）
  - 新規作成ボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| パッケージング名 | name | テキスト | ○ | 255 | 入力 | パッケージングの名称 |
| バーコード | barcode | テキスト | - | 255 | 入力 | パッケージングのバーコード |
| 商品 | product_id | 選択 | ○ | - | 入力 | 対象商品（GOODS・非バリアント商品のみ） |
| 数量 | qty | 数値 | ○ | 11桁 | 入力 | パッケージ内数量 |
| 会社 | company_id | 選択 | - | - | 入力 | 所属会社 |
| パッケージタイプ | package_type_id | 選択 | - | - | 入力 | パッケージの種類 |
| ルート | routes | 複数選択 | - | - | 入力 | 関連配送ルート |

## 表示項目

| 項目名 | 表示位置 | 形式 | 説明 |
|--------|----------|------|------|
| パッケージング名 | テーブル列 | テキスト | 検索可能 |
| 商品名 | テーブル列 | テキスト | 検索・ソート可能 |
| 数量 | テーブル列 | 数値 | ソート可能 |
| バーコード | テーブル列 | テキスト | 検索可能 |
| 会社名 | テーブル列 | テキスト | ソート可能 |
| パッケージタイプ | テーブル列 | テキスト | ソート可能、パッケージ機能有効時のみ |
| 作成日時 | テーブル列 | 日時 | ソート可能、デフォルト非表示 |
| 更新日時 | テーブル列 | 日時 | ソート可能、デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

作成モーダルが開き、パッケージング情報を入力できます。保存時に作成者IDが自動設定され、成功通知が表示されます。作成後は編集画面へリダイレクトします。

### 2-編集アクション押下

編集モーダルが開き、既存のパッケージング情報を変更できます。保存成功時は成功通知が表示されます。

### 3-削除アクション押下

確認ダイアログを表示し、確認後にパッケージングを削除します。削除成功時は成功通知が表示されます。関連データ（ルートとの紐付け等）がある場合はエラーとなります。

### 4-印刷一括アクション

選択したパッケージングのバーコードをPDF形式で出力し、`Packaging-Barcode.pdf`というファイル名でダウンロードします。

### 5-削除一括アクション

選択した複数のパッケージングを一括削除します。関連データがある場合はエラーとなります。

### 6-フィルタ適用

商品でフィルタリングが可能です。パッケージ機能有効時はパッケージタイプでもフィルタリングできます。

### 7-グループ化

商品名、作成日、更新日でグループ化が可能です。各グループは折りたたみ可能です。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | products_packagings | INSERT | パッケージング情報の登録 |
| 新規作成（ルート設定時） | inventories_route_packagings | INSERT | ルート関連付けの登録 |
| 編集保存 | products_packagings | UPDATE | パッケージング情報の更新 |
| 編集保存（ルート変更時） | inventories_route_packagings | DELETE/INSERT | ルート関連付けの更新 |
| 削除 | products_packagings | DELETE | パッケージング情報の削除 |
| 削除 | inventories_route_packagings | DELETE | 関連ルート紐付けの削除 |

### テーブル別更新項目詳細

#### products_packagings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | |
| INSERT | barcode | フォーム入力値 | |
| INSERT | product_id | フォーム入力値 | |
| INSERT | qty | フォーム入力値 | |
| INSERT | company_id | フォーム入力値 | |
| INSERT | package_type_id | フォーム入力値 | パッケージ機能有効時のみ |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |
| UPDATE | 上記全項目 | フォーム入力値 | |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| DELETE | - | 対象レコード削除 | |

#### inventories_route_packagings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | packaging_id | パッケージングID | |
| INSERT | route_id | 選択されたルートID | 複数レコード挿入 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Packaging created successfully | 作成成功時 |
| MSG-002 | 成功 | Packaging updated successfully | 更新成功時 |
| MSG-003 | 成功 | Packaging deleted successfully | 削除成功時 |
| MSG-004 | 成功 | Packagings deleted successfully | 一括削除成功時 |
| MSG-005 | エラー | Cannot delete packaging with dependencies | 関連データあり削除時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| 削除済み商品との紐付け | 商品名に(Deleted)表示、選択不可 | - |
| 関連データがある状態での削除 | 削除処理中止、エラー通知 | Cannot delete packaging |

## 備考

- ManageRecordsパターンを使用しており、一覧・作成・編集・削除がすべて同一画面で完結します
- 商品選択はGOODSタイプかつ非バリアント商品のみがリストされます
- 削除済み商品は選択リストに表示されますが、(Deleted)マークが付き選択不可となります
- パッケージタイプ選択はオペレーション設定（enable_packages）に依存します
- ルート選択は倉庫設定（enable_multi_steps_routes）に依存します
- 印刷機能はbarryvdh/laravel-dompdfパッケージを使用しています
