# 画面設計書 134-商品属性一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける商品属性一覧画面の設計仕様を定義するものです。

### 本画面の処理概要

商品属性一覧画面は、商品バリエーションを構成する属性（サイズ、色など）を一覧表示し、管理するための画面です。

**業務上の目的・背景**：ECサイトや小売業において、同一商品の異なるバリエーション（サイズ違い、色違い等）を効率的に管理することは、在庫管理の精度向上と顧客体験の改善に直結します。商品属性は、これらのバリエーションを定義するためのマスターデータであり、属性と属性オプションの組み合わせにより商品バリエーションが生成されます。本画面は、これらの属性を一元管理するためのインターフェースを提供します。

**画面へのアクセス方法**：在庫モジュール > 設定 > 商品属性メニューからアクセスします。商品設定でバリアント機能が有効な場合のみ表示されます。

**主要な操作・処理内容**：
1. 商品属性一覧の表示・検索・フィルタリング
2. 属性タイプによるフィルタリング（Radio/Color/Select/Pills）
3. 属性タイプ・作成日・更新日によるグループ化
4. 新規属性作成画面への遷移
5. 既存属性の詳細・編集画面への遷移
6. 属性の削除（単体・一括）、復元、完全削除

**画面遷移**：在庫設定メニューから遷移。新規作成ボタンで作成画面へ、行クリックで詳細画面へ、編集アクションで編集画面へ遷移します。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。商品設定でバリアント機能（enable_variants）が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-018 | 属性一覧 | 主機能 | 商品属性の一覧表示 |
| FN-PRD-019 | 属性作成 | 遷移先機能 | 新規属性の作成 |
| FN-PRD-020 | 属性編集 | 遷移先機能 | 既存属性の編集 |
| FN-PRD-021 | 属性表示 | 遷移先機能 | 属性詳細の表示 |

## 画面種別

一覧

## URL/ルーティング

`/inventories/configurations/product-attributes`

## 画面構成

- ヘッダーエリア
  - 新規作成ボタン
- テーブルエリア
  - データテーブル（列構成下記）
  - グループ化オプション
  - フィルタオプション
  - 行アクション（表示・編集・復元・削除・完全削除）
  - 一括アクション（復元・削除・完全削除）
- 空状態エリア（データなし時）
  - 新規作成ボタン

## 入出力項目

本画面は一覧表示画面のため、直接の入力項目はありません。フィルタ・検索・グループ化の条件入力が可能です。

## 表示項目

| 項目名 | 表示位置 | 形式 | 説明 |
|--------|----------|------|------|
| 属性名 | テーブル列 | テキスト | 検索可能 |
| タイプ | テーブル列 | Enum表示 | ソート可能（Radio/Color/Select/Pills） |
| 作成日時 | テーブル列 | 日時 | ソート可能、デフォルト非表示 |
| 更新日時 | テーブル列 | 日時 | ソート可能、デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

商品属性作成画面（/inventories/configurations/product-attributes/create）へ遷移します。

### 2-テーブル行クリック

商品属性詳細画面（/inventories/configurations/product-attributes/{record}）へ遷移します。

### 3-表示アクション押下

商品属性詳細画面へ遷移します。削除済みレコードでは非表示となります。

### 4-編集アクション押下

商品属性編集画面（/inventories/configurations/product-attributes/{record}/edit）へ遷移します。削除済みレコードでは非表示となります。

### 5-削除アクション押下

確認ダイアログを表示し、確認後に属性をソフトデリートします。削除成功時は成功通知が表示されます。

### 6-復元アクション押下

ソフトデリートされた属性を復元します。削除されていないレコードでは非表示です。復元成功時は成功通知が表示されます。

### 7-完全削除アクション押下

確認ダイアログを表示し、確認後に属性を物理削除します。関連データ（属性オプション、商品バリエーション等）がある場合はエラーとなります。

### 8-フィルタ適用

属性タイプでフィルタリングが可能です。Radio/Color/Select/Pillsから選択できます。

### 9-グループ化

属性タイプ、作成日、更新日でグループ化が可能です。各グループは折りたたみ可能です。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | products_attributes | UPDATE (Soft Delete) | deleted_atカラムに日時を設定 |
| 復元アクション | products_attributes | UPDATE | deleted_atをNULLに設定 |
| 完全削除アクション | products_attributes | DELETE | レコードの物理削除 |
| 一括削除 | products_attributes | UPDATE (Soft Delete) | 複数レコードのソフトデリート |
| 一括復元 | products_attributes | UPDATE | 複数レコードの復元 |
| 一括完全削除 | products_attributes | DELETE | 複数レコードの物理削除 |

### テーブル別更新項目詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE (Soft Delete) | deleted_at | 現在日時 | 削除時 |
| UPDATE (Restore) | deleted_at | NULL | 復元時 |
| DELETE | - | 対象レコード削除 | 完全削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Attribute deleted successfully | 削除成功時 |
| MSG-002 | 成功 | Attribute restored successfully | 復元成功時 |
| MSG-003 | 成功 | Attribute permanently deleted | 完全削除成功時 |
| MSG-004 | 成功 | Attributes deleted successfully | 一括削除成功時 |
| MSG-005 | 成功 | Attributes restored successfully | 一括復元成功時 |
| MSG-006 | 成功 | Attributes permanently deleted | 一括完全削除成功時 |
| MSG-007 | エラー | Cannot delete attribute with dependencies | 関連データあり完全削除時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| バリアント機能無効 | ナビゲーションから非表示 | - |
| 関連データがある状態での完全削除 | 削除処理中止、エラー通知 | Cannot delete attribute |

## 備考

- 本画面はProductsモジュールのAttributeResourceを継承しており、在庫モジュール専用のカスタマイズを追加しています
- ソフトデリート方式を採用しているため、削除後も復元が可能です
- 完全削除は関連データ（属性オプション、商品への紐付け等）がある場合は制限されます
- 属性タイプによって、商品詳細画面でのオプション表示形式が変わります
  - Radio: ラジオボタン形式
  - Color: カラーピッカー形式
  - Select: ドロップダウン形式
  - Pills: ピル（タブ）形式
- グループ化された表示では、各グループが折りたたみ可能です
