# 画面設計書 135-商品属性作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける商品属性作成画面の設計仕様を定義するものです。

### 本画面の処理概要

商品属性作成画面は、商品バリエーションを構成する新しい属性（サイズ、色など）を登録するための画面です。

**業務上の目的・背景**：商品のバリエーション管理において、属性は商品の差異を表現するための基本要素です。例えば「サイズ」属性にはS/M/L/XLといったオプション、「色」属性には赤/青/緑といったオプションを設定します。本画面は、これらの属性とそのオプションを一括で登録できるインターフェースを提供します。

**画面へのアクセス方法**：在庫モジュール > 設定 > 商品属性一覧画面の「新規作成」ボタンからアクセスします。

**主要な操作・処理内容**：
1. 属性名の入力
2. 属性タイプの選択（Radio/Color/Select/Pills）
3. 属性オプションの登録（名前、色、追加価格）
4. 属性情報の保存

**画面遷移**：商品属性一覧画面から遷移。保存後は商品属性詳細画面へ遷移します。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。商品設定でバリアント機能（enable_variants）が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-019 | 属性作成 | 主機能 | 新規属性の作成 |
| FN-PRD-018 | 属性一覧 | 遷移元機能 | 一覧から作成画面への遷移 |
| FN-PRD-021 | 属性表示 | 遷移先機能 | 作成後の詳細画面への遷移 |

## 画面種別

作成

## URL/ルーティング

`/inventories/configurations/product-attributes/create`

## 画面構成

- ヘッダーエリア
  - サブナビゲーション（クラスターコンポーネント）
- メインコンテンツエリア
  - 一般セクション
    - 属性名入力フィールド
    - 属性タイプ選択（Radio）
  - オプションセクション
    - オプションリピーター
      - オプション名入力
      - 色選択（Colorタイプ時のみ表示）
      - 追加価格入力
- フッターエリア
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| 属性名 | name | テキスト | ○ | 255 | 入力 | 属性の名称（例：サイズ、色） |
| 属性タイプ | type | ラジオ | ○ | - | 入力 | Radio/Color/Select/Pills |
| オプション名 | options.*.name | テキスト | ○ | 255 | 入力 | オプションの名称（例：S, M, L） |
| オプション色 | options.*.color | 色 | - | - | 入力 | カラーコード（Colorタイプ時のみ） |
| 追加価格 | options.*.extra_price | 数値 | ○ | 11桁 | 入力 | このオプション選択時の追加価格 |

## 表示項目

本画面は作成画面のため、表示専用の項目はありません。

## イベント仕様

### 1-属性タイプ変更

属性タイプを変更すると、オプションセクションの色フィールドの表示/非表示が動的に切り替わります：
- Colorタイプを選択：色フィールドが表示
- その他のタイプを選択：色フィールドが非表示

### 2-オプション追加

リピーターの「追加」ボタンをクリックすると、新しいオプション入力行が追加されます。

### 3-オプション削除

リピーターの行にある「削除」ボタンをクリックすると、該当のオプション行が削除されます。

### 4-保存ボタン押下

フォームの入力内容を検証し、問題なければデータベースに保存します。属性とオプションは一括で保存されます。保存成功後は商品属性詳細画面へ遷移します。

### 5-キャンセルボタン押下

確認なしで商品属性一覧画面へ戻ります。入力内容は保存されません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | products_attributes | INSERT | 属性情報の登録 |
| 保存ボタン押下 | products_attribute_options | INSERT | 属性オプション情報の登録 |

### テーブル別更新項目詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | |
| INSERT | type | フォーム入力値 | AttributeType enum値 |
| INSERT | creator_id | ログインユーザーID | 自動設定（推定） |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

#### products_attribute_options

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | attribute_id | 親属性のID | リレーション |
| INSERT | name | フォーム入力値 | |
| INSERT | color | フォーム入力値 | Colorタイプ時のみ |
| INSERT | extra_price | フォーム入力値 | デフォルト0 |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Attribute created successfully | 作成成功時 |
| MSG-002 | エラー | Validation error | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| バリアント機能無効 | リダイレクト | - |
| 重複する属性名 | バリデーションエラー | The name has already been taken |

## 備考

- 本画面はProductsモジュールのCreateAttributeを継承しており、在庫モジュール専用のサブナビゲーションを追加しています
- オプションはリピーター形式で、複数のオプションを一括で登録できます
- 属性タイプは以下の4種類から選択できます：
  - **Radio**: ラジオボタン形式でオプションを表示
  - **Color**: カラーピッカー形式でオプションを表示（各オプションに色を設定可能）
  - **Select**: ドロップダウン形式でオプションを表示
  - **Pills**: ピル（タブ）形式でオプションを表示
- 追加価格は、該当オプションを選択した際に商品基本価格に加算される金額です
- オプションは3カラムレイアウトで表示されます
