# 画面設計書 136-商品属性編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける商品属性編集画面の設計仕様を定義するものです。

### 本画面の処理概要

商品属性編集画面は、既存の商品属性（サイズ、色など）の情報とそのオプションを変更するための画面です。

**業務上の目的・背景**：商品ラインナップの拡大や市場ニーズの変化に応じて、既存の属性オプションを追加・変更・削除する必要が生じます。例えば、サイズ属性にXXLを追加したり、色属性に新色を追加したりするケースです。本画面は、これらの変更を安全に行うためのインターフェースを提供します。

**画面へのアクセス方法**：在庫モジュール > 設定 > 商品属性一覧画面から対象レコードの「編集」アクションをクリック、または商品属性詳細画面の編集タブからアクセスします。

**主要な操作・処理内容**：
1. 属性名の変更
2. 属性タイプの変更（Radio/Color/Select/Pills）
3. 属性オプションの追加・編集・削除
4. 属性情報の保存

**画面遷移**：商品属性一覧画面または商品属性詳細画面から遷移。保存後は同画面に留まります。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。商品設定でバリアント機能（enable_variants）が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-020 | 属性編集 | 主機能 | 既存属性の編集 |
| FN-PRD-018 | 属性一覧 | 遷移元機能 | 一覧から編集画面への遷移 |
| FN-PRD-021 | 属性表示 | 遷移元機能 | 詳細から編集画面への遷移 |

## 画面種別

編集

## URL/ルーティング

`/inventories/configurations/product-attributes/{record}/edit`

## 画面構成

- ヘッダーエリア
  - サブナビゲーション（クラスターコンポーネント）
  - 詳細/編集タブナビゲーション
- メインコンテンツエリア
  - 一般セクション
    - 属性名入力フィールド
    - 属性タイプ選択（Radio）
  - オプションセクション
    - オプションリピーター
      - オプション名入力
      - 色選択（Colorタイプ時のみ表示）
      - 追加価格入力
- フッターエリア
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| 属性名 | name | テキスト | ○ | 255 | 入力 | 属性の名称（例：サイズ、色） |
| 属性タイプ | type | ラジオ | ○ | - | 入力 | Radio/Color/Select/Pills |
| オプション名 | options.*.name | テキスト | ○ | 255 | 入力 | オプションの名称（例：S, M, L） |
| オプション色 | options.*.color | 色 | - | - | 入力 | カラーコード（Colorタイプ時のみ） |
| 追加価格 | options.*.extra_price | 数値 | ○ | 11桁 | 入力 | このオプション選択時の追加価格 |

## 表示項目

本画面は編集画面のため、表示専用の項目はありません。既存データがフォームにプリロードされます。

## イベント仕様

### 1-属性タイプ変更

属性タイプを変更すると、オプションセクションの色フィールドの表示/非表示が動的に切り替わります：
- Colorタイプを選択：色フィールドが表示
- その他のタイプを選択：色フィールドが非表示

### 2-オプション追加

リピーターの「追加」ボタンをクリックすると、新しいオプション入力行が追加されます。

### 3-オプション削除

リピーターの行にある「削除」ボタンをクリックすると、該当のオプション行が削除されます。既存のオプションを削除すると、関連する商品バリエーションにも影響します。

### 4-保存ボタン押下

フォームの入力内容を検証し、問題なければデータベースに保存します。属性とオプションは一括で保存されます。オプションの追加・削除・変更もすべてこのタイミングで反映されます。

### 5-キャンセルボタン押下

確認なしで商品属性一覧画面へ戻ります。変更内容は保存されません。

### 6-詳細タブクリック

商品属性詳細画面へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | products_attributes | UPDATE | 属性情報の更新 |
| 保存ボタン押下（オプション追加時） | products_attribute_options | INSERT | 新規オプションの登録 |
| 保存ボタン押下（オプション変更時） | products_attribute_options | UPDATE | 既存オプションの更新 |
| 保存ボタン押下（オプション削除時） | products_attribute_options | DELETE | オプションの削除 |

### テーブル別更新項目詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | |
| UPDATE | type | フォーム入力値 | AttributeType enum値 |
| UPDATE | updated_at | 現在日時 | 自動設定 |

#### products_attribute_options

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | attribute_id | 親属性のID | リレーション |
| INSERT | name | フォーム入力値 | |
| INSERT | color | フォーム入力値 | Colorタイプ時のみ |
| INSERT | extra_price | フォーム入力値 | デフォルト0 |
| UPDATE | name | フォーム入力値 | |
| UPDATE | color | フォーム入力値 | |
| UPDATE | extra_price | フォーム入力値 | |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| DELETE | - | 対象レコード削除 | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Attribute updated successfully | 更新成功時 |
| MSG-002 | エラー | Validation error | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| レコードが存在しない | 404エラーページ表示 | Record not found |
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| 削除済みレコード | 編集不可、一覧へリダイレクト | - |
| 使用中オプションの削除 | バリデーションエラー | Cannot delete option in use |

## 備考

- 本画面はProductsモジュールのEditAttributeを継承しており、在庫モジュール専用のサブナビゲーションを追加しています
- オプションはリピーター形式で、既存のオプションが一覧表示されます
- オプションを削除する場合、そのオプションが商品バリエーションで使用されていると削除できない可能性があります
- 属性タイプを変更した場合、既存のColorオプションの色情報は保持されますが、Colorタイプ以外では表示されません
- リピーターはリレーションシップ型で、保存時に自動的に関連テーブルが更新されます
