# 画面設計書 137-商品属性詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける商品属性詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

商品属性詳細画面は、商品属性（サイズ、色など）の詳細情報を閲覧するための画面です。

**業務上の目的・背景**：商品属性の設定内容を確認し、商品バリエーション管理の参考情報として活用します。属性のタイプ、オプション一覧、作成者・更新日時などの情報を一覧性高く表示することで、マスターデータの管理効率を向上させます。

**画面へのアクセス方法**：在庫モジュール > 設定 > 商品属性一覧画面から対象レコードをクリック、または「表示」アクションを選択してアクセスします。

**主要な操作・処理内容**：
1. 属性基本情報の表示（名前、タイプ）
2. レコード情報の表示（作成者、作成日時、更新日時）
3. 編集画面への遷移

**画面遷移**：商品属性一覧画面から遷移。編集タブで商品属性編集画面へ遷移します。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。商品設定でバリアント機能（enable_variants）が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-021 | 属性表示 | 主機能 | 属性詳細の表示 |
| FN-PRD-018 | 属性一覧 | 遷移元機能 | 一覧から詳細画面への遷移 |
| FN-PRD-020 | 属性編集 | 遷移先機能 | 詳細から編集画面への遷移 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/configurations/product-attributes/{record}`

## 画面構成

- ヘッダーエリア
  - サブナビゲーション（クラスターコンポーネント）
  - 詳細/編集タブナビゲーション
- メインコンテンツエリア（3カラムレイアウト）
  - 左側（2カラム幅）
    - 一般セクション
      - 属性名（大文字、太字表示）
      - 属性タイプ
  - 右側（1カラム幅）
    - レコード情報セクション（折りたたみ可能）
      - 作成者（userアイコン付き）
      - 作成日時（calendarアイコン付き）
      - 更新日時（clockアイコン付き）

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

| 項目名 | 表示位置 | 形式 | 説明 |
|--------|----------|------|------|
| 属性名 | 一般セクション | テキスト（大、太字） | 属性の名称 |
| 属性タイプ | 一般セクション | Enum表示 | Radio/Color/Select/Pills |
| 作成者 | レコード情報セクション | テキスト | userアイコン付き、プレースホルダー「—」 |
| 作成日時 | レコード情報セクション | 日時 | calendarアイコン付き、プレースホルダー「—」 |
| 更新日時 | レコード情報セクション | 日時 | clockアイコン付き、プレースホルダー「—」 |

## イベント仕様

### 1-編集タブクリック

商品属性編集画面（/inventories/configurations/product-attributes/{record}/edit）へ遷移します。

### 2-レコード情報セクション折りたたみ

レコード情報セクションは折りたたみ可能で、クリックで展開/収納を切り替えられます。

## データベース更新仕様

### 操作別データベース影響一覧

本画面は表示専用のため、データベースの更新は行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products_attributes | SELECT | 属性情報の取得 |
| 画面表示 | users | SELECT | 作成者情報の取得 |

## メッセージ仕様

本画面では通知メッセージは表示されません。

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| レコードが存在しない | 404エラーページ表示 | Record not found |
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| 削除済みレコード | 詳細表示不可 | - |

## 備考

- 本画面はProductsモジュールのViewAttributeを継承しており、在庫モジュール専用のサブナビゲーションを追加しています
- 3カラムレイアウトを使用し、左側2カラムに主要情報、右側1カラムにメタ情報を配置しています
- レコード情報セクションは折りたたみ可能（collapsible）で、information-circleアイコンが付いています
- 属性名は大きなフォントサイズ（TextSize::Large）と太字（FontWeight::Bold）で目立つように表示されます
- プレースホルダー表示として「—」を使用し、値がない場合でも見栄えを保ちます
