# 画面設計書 138-保管カテゴリ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける保管カテゴリ一覧画面の設計仕様を定義するものです。

### 本画面の処理概要

保管カテゴリ一覧画面は、倉庫のロケーションに割り当てる保管カテゴリを一覧表示し、管理するための画面です。

**業務上の目的・背景**：倉庫管理において、保管カテゴリはロケーションの特性（最大重量、新商品の受け入れ可否など）を定義するためのマスターデータです。保管カテゴリを適切に設定することで、商品の最適な配置、倉庫スペースの効率的な利用、ピッキング効率の向上が実現できます。本画面は、これらの保管カテゴリを一元管理するためのインターフェースを提供します。

**画面へのアクセス方法**：在庫モジュール > 設定 > 保管カテゴリメニューからアクセスします。倉庫設定でロケーション機能が有効な場合のみ表示されます。

**主要な操作・処理内容**：
1. 保管カテゴリ一覧の表示・検索
2. 新商品受け入れ設定・作成日・更新日によるグループ化
3. 新規保管カテゴリ作成画面への遷移
4. 既存保管カテゴリの詳細・編集画面への遷移
5. 保管カテゴリの削除（単体・一括）

**画面遷移**：在庫設定メニューから遷移。新規作成ボタンで作成画面へ、行クリックで詳細画面へ、編集アクションで編集画面へ遷移します。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。倉庫設定でロケーション機能（enable_locations）が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-028 | ストレージカテゴリ管理 | 主機能 | 保管カテゴリの一覧表示 |
| FN-INV-024 | ロケーション管理 | 関連機能 | ロケーションへの割り当て |

## 画面種別

一覧

## URL/ルーティング

`/inventories/configurations/storage-categories`

## 画面構成

- ヘッダーエリア
  - 新規作成ボタン
- テーブルエリア
  - データテーブル（列構成下記）
  - グループ化オプション
  - 行アクション（表示・編集・削除）
  - 一括アクション（削除）
- 空状態エリア（データなし時）
  - 新規作成ボタン

## 入出力項目

本画面は一覧表示画面のため、直接の入力項目はありません。グループ化・ソートの条件入力が可能です。

## 表示項目

| 項目名 | 表示位置 | 形式 | 説明 |
|--------|----------|------|------|
| カテゴリ名 | テーブル列 | テキスト | 検索可能 |
| 新商品受け入れ | テーブル列 | Enum表示 | ソート可能（Empty/Same Product/Mixed） |
| 最大重量 | テーブル列 | 数値 | ソート可能 |
| 会社名 | テーブル列 | テキスト | ソート可能 |
| 作成日時 | テーブル列 | 日時 | ソート可能、デフォルト非表示 |
| 更新日時 | テーブル列 | 日時 | ソート可能、デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

保管カテゴリ作成画面（/inventories/configurations/storage-categories/create）へ遷移します。

### 2-テーブル行クリック

保管カテゴリ詳細画面（/inventories/configurations/storage-categories/{record}）へ遷移します。

### 3-表示アクション押下

保管カテゴリ詳細画面へ遷移します。

### 4-編集アクション押下

保管カテゴリ編集画面（/inventories/configurations/storage-categories/{record}/edit）へ遷移します。

### 5-削除アクション押下

確認ダイアログを表示し、確認後に保管カテゴリを削除します。削除成功時は成功通知が表示されます。関連データ（ロケーションとの紐付け等）がある場合はエラーとなります。

### 6-一括削除アクション

選択した複数の保管カテゴリを一括削除します。関連データがある場合はエラーとなります。

### 7-グループ化

新商品受け入れ設定、作成日、更新日でグループ化が可能です。各グループは折りたたみ可能です。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | inventories_storage_categories | DELETE | カテゴリの削除 |
| 一括削除 | inventories_storage_categories | DELETE | 複数カテゴリの削除 |

### テーブル別更新項目詳細

#### inventories_storage_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | 対象レコード削除 | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Storage category deleted successfully | 削除成功時 |
| MSG-002 | 成功 | Storage categories deleted successfully | 一括削除成功時 |
| MSG-003 | エラー | Cannot delete storage category with dependencies | 関連データあり削除時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| ロケーション機能無効 | ナビゲーションから非表示 | - |
| 関連データがある状態での削除 | 削除処理中止、エラー通知 | Cannot delete storage category |

## 備考

- 保管カテゴリはロケーションの特性を定義するためのマスターデータです
- 新商品受け入れ設定は以下の3種類から選択できます：
  - **Empty**: 空のロケーションにのみ商品を配置可能
  - **Same Product**: 同一商品が既にあるロケーションにのみ配置可能
  - **Mixed**: 異なる商品との混載可能
- 最大重量はロケーションに配置可能な総重量を制限します
- ソート順（sortカラム）によりドラッグ&ドロップでの並び替えが可能です（Spatie Sortable）
- 保管カテゴリには、パッケージタイプ別容量、商品別容量、関連ロケーションなどの関連データがあります
