# 画面設計書 139-保管カテゴリ作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける保管カテゴリ作成画面の設計仕様を定義するものです。

### 本画面の処理概要

保管カテゴリ作成画面は、倉庫のロケーションに割り当てる新しい保管カテゴリを登録するための画面です。

**業務上の目的・背景**：倉庫レイアウトの変更や新しい保管ルールの導入に伴い、新しい保管カテゴリを定義する必要が生じます。保管カテゴリには最大重量、新商品の受け入れポリシーなどを設定でき、これらの設定がロケーションへの商品配置ルールとして機能します。本画面は、これらの設定を簡単に登録できるインターフェースを提供します。

**画面へのアクセス方法**：在庫モジュール > 設定 > 保管カテゴリ一覧画面の「新規作成」ボタンからアクセスします。

**主要な操作・処理内容**：
1. カテゴリ名の入力
2. 最大重量の設定
3. 新商品受け入れポリシーの選択
4. 所属会社の選択
5. 保管カテゴリ情報の保存

**画面遷移**：保管カテゴリ一覧画面から遷移。保存後は保管カテゴリ詳細画面へ遷移します。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。倉庫設定でロケーション機能（enable_locations）が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-028 | ストレージカテゴリ管理 | 主機能 | 新規保管カテゴリの作成 |
| FN-INV-024 | ロケーション管理 | 関連機能 | ロケーションへの割り当て |

## 画面種別

作成

## URL/ルーティング

`/inventories/configurations/storage-categories/create`

## 画面構成

- ヘッダーエリア
  - サブナビゲーション（クラスターコンポーネント、Start位置）
- メインコンテンツエリア
  - 一般セクション（2カラム、全幅）
    - カテゴリ名入力フィールド
    - 最大重量入力フィールド
    - 新商品受け入れ選択フィールド
    - 会社選択フィールド
- フッターエリア
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| カテゴリ名 | name | テキスト | ○ | 255 | 入力 | 保管カテゴリの名称 |
| 最大重量 | max_weight | 数値 | - | 8桁 | 入力 | ロケーションの最大重量（kg） |
| 新商品受け入れ | allow_new_products | 選択 | ○ | - | 入力 | Empty/Same Product/Mixed |
| 会社 | company_id | 選択 | - | - | 入力 | 所属会社 |

## 表示項目

本画面は作成画面のため、表示専用の項目はありません。

## イベント仕様

### 1-保存ボタン押下

フォームの入力内容を検証し、問題なければデータベースに保存します。作成者IDはログインユーザーから自動設定されます。保存成功後は保管カテゴリ詳細画面へ遷移します。

### 2-キャンセルボタン押下

確認なしで保管カテゴリ一覧画面へ戻ります。入力内容は保存されません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_storage_categories | INSERT | 保管カテゴリ情報の登録 |

### テーブル別更新項目詳細

#### inventories_storage_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | |
| INSERT | max_weight | フォーム入力値 | デフォルト0 |
| INSERT | allow_new_products | フォーム入力値 | デフォルトMixed |
| INSERT | company_id | フォーム入力値 | |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | sort | 自動採番 | Spatie Sortable |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Storage category created successfully | 作成成功時 |
| MSG-002 | エラー | Validation error | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| ロケーション機能無効 | リダイレクト | - |

## 備考

- 最大重量のデフォルト値は0で、0の場合は重量制限なしを意味します
- 最大重量の有効範囲は0～99,999,999です
- 新商品受け入れ設定のデフォルトはMixedです
- 会社選択のデフォルト値はログインユーザーのデフォルト会社です
- 作成者IDは自動的にログインユーザーから設定されます
- ソート順（sort）はSpatie Sortableパッケージにより自動採番されます
- 作成後の遷移先は詳細画面（view）です
- サブナビゲーションはStart位置に表示されます
