# 画面設計書 14-現金丸め詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける「現金丸め詳細」画面の設計仕様を定義するものである。

### 本画面の処理概要

現金丸め詳細画面は、会計モジュールにおいて既存の現金丸め設定の詳細情報を表示するための画面である。

**業務上の目的・背景**：現金丸め設定の内容を確認する必要がある場合に使用する。設定内容（名前、丸め精度、丸め戦略、丸め方法）を読み取り専用で表示し、必要に応じて編集画面や削除操作へ遷移できる。請求書作成時などに適用される丸め設定を事前に確認するために利用される。

**画面へのアクセス方法**：
1. 現金丸め一覧画面の各行の「表示」アクションから遷移
2. 現金丸め作成画面で保存成功後に自動遷移
3. 現金丸め編集画面で保存成功後に自動遷移
4. URL直接入力でもアクセス可能

**主要な操作・処理内容**：
1. 現金丸め設定の詳細情報を表示（読み取り専用）
2. ヘッダーの「編集」ボタンで編集画面へ遷移
3. ヘッダーの「削除」ボタンでレコードを削除

**画面遷移**：
- 「編集」アクション：現金丸め編集画面へ遷移
- 削除成功時：現金丸め一覧画面へ遷移

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、表示権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-015 | 現金端数処理管理 | 主機能 | 現金丸め設定の詳細表示 |
| FN-ACC-028 | 現金端数処理管理 | 主機能 | 表示/削除処理 |

## 画面種別

詳細

## URL/ルーティング

`/admin/accounts/cash-roundings/{record}`

## 画面構成

1. **ヘッダーアクションエリア**
   - 「編集」ボタン（EditAction）
   - 「削除」ボタン（DeleteAction）

2. **情報表示セクション**
   - Sectionコンポーネント内にGroupを配置
   - 2カラムレイアウトで詳細情報を表示

3. **表示フィールドエリア**
   - 名前（TextEntry）- アイコン付き
   - 丸め精度（TextEntry）- アイコン付き、数値フォーマット
   - 丸め戦略（TextEntry）- アイコン付き
   - 丸め方法（TextEntry）- アイコン付き

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

| 項目名 | 物理名 | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 名前 | name | string | heroicon-o-document-text | 現金丸め設定の名称 |
| 丸め精度 | rounding | numeric | heroicon-o-calculator | 丸め精度（小数点2桁、カンマ区切り） |
| 丸め戦略 | strategy | enum | heroicon-o-cog | 丸め戦略のラベル表示 |
| 丸め方法 | rounding_method | enum | heroicon-o-adjustments-horizontal | 丸め方法のラベル表示 |

## イベント仕様

### 1-編集アクション

ヘッダーの「編集」ボタン押下時、該当レコードの編集画面（EditCashRounding）へ遷移する。

### 2-削除アクション

ヘッダーの「削除」ボタン押下時、確認後にレコードを削除し、成功通知を表示して一覧画面へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示時 | accounts_cash_roundings | SELECT | レコード情報の取得 |
| 削除アクション | accounts_cash_roundings | DELETE | レコードの削除 |

### テーブル別更新項目詳細

#### accounts_cash_roundings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | name, rounding, strategy, rounding_method | WHERE id = レコードID | 表示用データ取得 |
| DELETE | - | WHERE id = レコードID | 物理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 削除成功通知（タイトル・本文） | レコード削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラー表示 |
| 権限不足 | アクセス拒否エラー表示 |

## 備考

- 丸め精度は小数点2桁、小数点区切り「.」、千桁区切り「,」でフォーマット表示される
- 丸め戦略と丸め方法はEnumのoptions()メソッドでラベルに変換して表示される
- 各表示項目にはアイコンが付与され、視認性を向上させている
- infolistメソッドでViewRecordページ用のスキーマが定義されている
