# 画面設計書 140-保管カテゴリ編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける保管カテゴリ編集画面の設計仕様を定義するものです。

### 本画面の処理概要

保管カテゴリ編集画面は、既存の保管カテゴリ情報を変更するための画面です。

**業務上の目的・背景**：倉庫運用の見直しや業務要件の変更に伴い、保管カテゴリの設定（最大重量、新商品受け入れポリシー等）を変更する必要が生じます。本画面は、これらの変更を安全に行うためのインターフェースを提供します。

**画面へのアクセス方法**：在庫モジュール > 設定 > 保管カテゴリ一覧画面から対象レコードの「編集」アクションをクリック、または保管カテゴリ詳細画面の編集タブからアクセスします。

**主要な操作・処理内容**：
1. カテゴリ名の変更
2. 最大重量の変更
3. 新商品受け入れポリシーの変更
4. 所属会社の変更
5. 保管カテゴリ情報の保存
6. 保管カテゴリの削除

**画面遷移**：保管カテゴリ一覧画面または保管カテゴリ詳細画面から遷移。保存後は同画面に留まります。詳細タブで詳細画面へ、削除後は一覧画面へ遷移します。

**権限による表示制御**：在庫管理権限を持つユーザーのみがアクセス可能です。倉庫設定でロケーション機能（enable_locations）が有効な場合のみ画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-028 | ストレージカテゴリ管理 | 主機能 | 保管カテゴリの編集・更新 |
| FN-INV-024 | ロケーション管理 | 関連機能 | ロケーションへの割り当て |

## 画面種別

編集

## URL/ルーティング

`/inventories/configurations/storage-categories/{record}/edit`

## 画面構成

- ヘッダーエリア
  - 詳細表示ボタン
  - 削除ボタン
  - 詳細/編集/パッケージ容量/商品容量/ロケーションタブナビゲーション
- メインコンテンツエリア
  - 一般セクション（2カラム、全幅）
    - カテゴリ名入力フィールド
    - 最大重量入力フィールド
    - 新商品受け入れ選択フィールド
    - 会社選択フィールド
- フッターエリア
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| カテゴリ名 | name | テキスト | ○ | 255 | 入力 | 保管カテゴリの名称 |
| 最大重量 | max_weight | 数値 | - | 8桁 | 入力 | ロケーションの最大重量（kg） |
| 新商品受け入れ | allow_new_products | 選択 | ○ | - | 入力 | Empty/Same Product/Mixed |
| 会社 | company_id | 選択 | - | - | 入力 | 所属会社 |

## 表示項目

本画面は編集画面のため、表示専用の項目はありません。既存データがフォームにプリロードされます。

## イベント仕様

### 1-保存ボタン押下

フォームの入力内容を検証し、問題なければデータベースに保存します。保存成功後は同画面に留まり、成功通知が表示されます。

### 2-詳細表示ボタン押下

保管カテゴリ詳細画面（/inventories/configurations/storage-categories/{record}）へ遷移します。

### 3-削除ボタン押下

確認ダイアログを表示し、確認後に保管カテゴリを削除します。削除成功時は成功通知が表示され、一覧画面へリダイレクトします。関連データ（ロケーションとの紐付け、容量設定等）がある場合はエラーとなる可能性があります。

### 4-キャンセルボタン押下

確認なしで保管カテゴリ一覧画面へ戻ります。変更内容は保存されません。

### 5-タブナビゲーション

以下のタブで関連画面へ遷移できます：
- 詳細：詳細画面へ
- 編集：現在の画面
- パッケージ容量：パッケージタイプ別容量管理画面へ
- 商品容量：商品別容量管理画面へ
- ロケーション：関連ロケーション管理画面へ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_storage_categories | UPDATE | 保管カテゴリ情報の更新 |
| 削除ボタン押下 | inventories_storage_categories | DELETE | 保管カテゴリの削除 |

### テーブル別更新項目詳細

#### inventories_storage_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | |
| UPDATE | max_weight | フォーム入力値 | |
| UPDATE | allow_new_products | フォーム入力値 | |
| UPDATE | company_id | フォーム入力値 | |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| DELETE | - | 対象レコード削除 | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | Storage category updated successfully | 更新成功時 |
| MSG-002 | 成功 | Storage category deleted successfully | 削除成功時 |
| MSG-003 | エラー | Validation error | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|--------------|
| レコードが存在しない | 404エラーページ表示 | Record not found |
| 権限不足 | 403エラーページ表示 | Unauthorized access |
| 関連データがある状態での削除 | 削除処理中止 | Cannot delete storage category |

## 備考

- 本画面はHasRecordNavigationTabsトレイトを使用しており、複数の関連画面間をタブで移動できます
- 以下の関連画面がサブナビゲーションに表示されます：
  - 詳細表示（ViewStorageCategory）
  - 編集（EditStorageCategory）
  - パッケージ容量管理（ManageCapacityByPackages）
  - 商品容量管理（ManageCapacityByProducts）
  - ロケーション管理（ManageLocations）
- サブナビゲーション位置は一覧画面ではStart、詳細/編集画面ではTopに設定されています
- 詳細表示ボタン（ViewAction）がヘッダーアクションに含まれています
- 削除ボタン（DeleteAction）がヘッダーアクションに含まれています
- 保存成功通知はgetSavedNotificationメソッドで定義されています
