# 画面設計書 141-保管カテゴリ詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「保管カテゴリ詳細」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、保管カテゴリの詳細情報を表示するための画面です。倉庫内のロケーションにおける商品の保管ルールを定義した保管カテゴリの設定内容を確認することができます。

**業務上の目的・背景**：保管カテゴリは、倉庫のロケーションにおける商品の保管方法を制御するために使用されます。最大重量制限や新商品の受け入れポリシー（空のみ/同一商品のみ/混在許可）を設定することで、効率的な倉庫管理と在庫配置の最適化を実現します。本画面では、設定された保管カテゴリの詳細を確認し、編集画面への遷移や関連情報（パッケージ容量、商品容量、適用ロケーション）の管理画面へのアクセスを提供します。

**画面へのアクセス方法**：在庫管理モジュール → 設定（Configurations）クラスター → 保管カテゴリ一覧 → 対象レコードをクリック または 表示アクションを選択

**主要な操作・処理内容**：
1. 保管カテゴリ名の確認
2. 最大重量の確認
3. 新商品受け入れポリシーの確認
4. 所属会社の確認
5. レコード情報（作成日時、作成者、更新日時）の確認
6. 編集画面への遷移
7. パッケージ容量管理画面への遷移
8. 商品容量管理画面への遷移
9. ロケーション管理画面への遷移

**画面遷移**：
- 遷移元：保管カテゴリ一覧画面
- 遷移先：保管カテゴリ編集画面、パッケージ容量管理画面、商品容量管理画面、ロケーション管理画面

**権限による表示制御**：倉庫設定（enable_locations）が有効な場合のみ、本リソースが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-028 | ストレージカテゴリ管理 | 主機能 | 保管カテゴリの詳細表示 |
| FN-INV-028-1 | パッケージ容量管理 | 補助機能 | パッケージタイプ別の容量設定 |
| FN-INV-028-2 | 商品容量管理 | 補助機能 | 商品別の容量設定 |
| FN-INV-028-3 | ロケーション管理 | 補助機能 | 適用ロケーションの管理 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/configurations/storage-categories/{record}`

## 画面構成

- ヘッダーアクション
  - 編集ボタン（EditAction）
- サブナビゲーション（Top位置）
  - 詳細表示タブ
  - 編集タブ
  - パッケージ容量タブ
  - 商品容量タブ
  - ロケーションタブ
- メインコンテンツ（3カラムレイアウト）
  - 左側グループ（2カラム幅）
    - 一般セクション（2カラム）
  - 右側グループ（1カラム幅）
    - レコード情報セクション

## 入出力項目

該当なし（詳細画面のため入力項目はありません）

## 表示項目

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| 名前 | name | string | heroicon-o-tag | 保管カテゴリ名 |
| 最大重量 | max_weight | numeric | heroicon-o-scale | 最大重量制限値 |
| 新商品の許可 | allow_new_products | enum | heroicon-o-plus-circle | 新商品受け入れポリシー |
| 会社 | company.name | string | heroicon-o-building-office | 所属会社名 |
| 作成日時 | created_at | datetime | heroicon-m-calendar | レコード作成日時 |
| 作成者 | creator.name | string | heroicon-m-user | レコード作成者名 |
| 最終更新日時 | updated_at | datetime | heroicon-m-calendar-days | レコード最終更新日時 |

## イベント仕様

### 1-編集ボタン押下

ヘッダーの編集ボタン押下時、保管カテゴリ編集画面へ遷移します。

### 2-サブナビゲーションタブ選択

各タブ選択時、対応する管理画面へ遷移します。
- 詳細表示：現在の画面を維持
- 編集：編集画面へ遷移
- パッケージ容量：パッケージ容量管理画面へ遷移
- 商品容量：商品容量管理画面へ遷移
- ロケーション：ロケーション管理画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | inventories_storage_categories | SELECT | 保管カテゴリ情報の取得 |
| 詳細表示 | companies | SELECT | 関連会社情報の取得 |
| 詳細表示 | users | SELECT | 作成者情報の取得 |

### テーブル別更新項目詳細

#### inventories_storage_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | URL パラメータ {record} に一致 | 主キー |
| SELECT | name | - | 表示用 |
| SELECT | max_weight | - | 表示用 |
| SELECT | allow_new_products | - | Enum値で取得 |
| SELECT | company_id | - | 会社リレーション用 |
| SELECT | creator_id | - | 作成者リレーション用 |
| SELECT | created_at | - | 表示用 |
| SELECT | updated_at | - | 表示用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | 詳細画面のため特定のメッセージ表示なし |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| レコード未存在 | 404エラーページを表示 |
| 権限不足 | 403エラーページを表示、またはリダイレクト |
| 倉庫設定無効 | リソースが非表示となり、アクセス不可 |

## 備考

- 本画面はFilament PHPのViewRecordページを継承して実装されています
- HasRecordNavigationTabsトレイトを使用してレコード間のナビゲーションを提供します
- 倉庫設定（WarehouseSettings）のenable_locationsが有効な場合のみ、このリソースにアクセス可能です
- 関連マネージャーとしてCapacityByPackagesRelationManagerとCapacityByProductsRelationManagerが定義されています
