# 画面設計書 142-商品カテゴリ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「商品カテゴリ一覧」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、在庫管理で使用する商品カテゴリを一覧表示し、検索・フィルタリング・並び替え・グルーピングなどの操作を行うための画面です。商品カテゴリは階層構造を持ち、商品を論理的に分類・整理するために使用されます。

**業務上の目的・背景**：商品カテゴリは、在庫管理において商品を体系的に分類し、効率的な商品検索と在庫分析を可能にするための重要な機能です。親子関係を持つ階層構造により、大分類から小分類まで柔軟なカテゴリ体系を構築できます。また、物流ルートとの連携により、カテゴリ単位での配送ルール設定も可能です。本画面では、定義されたカテゴリの一覧表示と管理操作（作成・編集・削除）を提供します。

**画面へのアクセス方法**：在庫管理モジュール → 設定（Configurations）クラスター → 商品カテゴリ

**主要な操作・処理内容**：
1. 商品カテゴリの一覧表示（テーブル形式）
2. カテゴリ名、完全パス名、親パス、親カテゴリでの検索
3. 親カテゴリ、作成者でのフィルタリング
4. 親カテゴリ、作成者、作成日、更新日でのグルーピング
5. カラム表示/非表示の切り替え
6. カラムの並び替え（ドラッグ&ドロップ）
7. 新規カテゴリ作成画面への遷移
8. カテゴリ詳細画面への遷移
9. カテゴリ編集画面への遷移
10. カテゴリの削除（個別・一括）

**画面遷移**：
- 遷移元：在庫管理ダッシュボード、設定メニュー
- 遷移先：商品カテゴリ作成画面、商品カテゴリ詳細画面、商品カテゴリ編集画面

**権限による表示制御**：特になし（在庫管理モジュールへのアクセス権限に依存）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-029 | 商品カテゴリ管理 | 主機能 | カテゴリ一覧表示・検索・フィルタ |
| FN-PRD-013 | カテゴリ管理 | 補助機能 | 基底カテゴリ機能の継承 |

## 画面種別

一覧

## URL/ルーティング

`/inventories/configurations/product-categories`

## 画面構成

- サブナビゲーション（Start位置 - 一覧画面時）
  - Configurationsクラスターのコンポーネント一覧
- ヘッダーアクション
  - 新規作成ボタン
- テーブル
  - カラム管理機能
  - 並び替え可能なカラム
  - グルーピング機能
  - フィルター機能
  - 一括操作機能
- 空状態アクション
  - 新規作成ボタン

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | フィールド名 | データ型 | 検索可否 | ソート可否 | デフォルト表示 | 説明 |
|--------|-------------|---------|---------|-----------|--------------|------|
| 名前 | name | string | ○ | - | ○ | カテゴリ名 |
| 完全名 | full_name | string | ○ | - | ○ | 階層を含む完全パス名 |
| 親パス | parent_path | string | ○ | - | ○ | 親カテゴリのパス |
| 親カテゴリ | parent.name | string | - | ○ | ○ | 親カテゴリ名 |
| 作成者 | creator.name | string | - | ○ | ○ | 作成者名 |
| 作成日時 | created_at | datetime | - | ○ | × | レコード作成日時 |
| 更新日時 | updated_at | datetime | - | ○ | × | レコード更新日時 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーまたは空状態の新規作成ボタン押下時、商品カテゴリ作成画面へ遷移します。

### 2-行クリック（表示アクション）

テーブル行の表示アクション選択時、商品カテゴリ詳細画面へ遷移します。

### 3-編集アクション選択

行アクションの編集を選択時、商品カテゴリ編集画面へ遷移します。

### 4-削除アクション選択

行アクションの削除を選択時、削除確認ダイアログを表示し、確認後にレコードを削除します。外部キー制約違反時はエラー通知を表示します。

### 5-一括削除アクション

チェックボックスで選択した複数レコードを一括削除します。外部キー制約違反時はエラー通知を表示します。

### 6-フィルター適用

親カテゴリまたは作成者でのフィルタリングを適用し、テーブル表示を更新します。

### 7-グルーピング適用

選択したグループ基準（親カテゴリ、作成者、作成日、更新日）でテーブルをグルーピング表示します。折りたたみ可能です。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | products_categories | SELECT | カテゴリ情報の取得 |
| 一覧表示 | users | SELECT | 作成者情報の取得 |
| 削除アクション | products_categories | DELETE | カテゴリの削除 |
| 一括削除 | products_categories | DELETE | 複数カテゴリの削除 |

### テーブル別更新項目詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | - | 主キー |
| SELECT | name | - | 検索・表示用 |
| SELECT | full_name | - | 検索・表示用 |
| SELECT | parent_path | - | 検索・表示用 |
| SELECT | parent_id | - | 親カテゴリリレーション用 |
| SELECT | creator_id | - | 作成者リレーション用 |
| SELECT | created_at | - | 表示・ソート用 |
| SELECT | updated_at | - | 表示・ソート用 |
| DELETE | id | 選択されたレコードID | 削除対象 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-DEL-001 | 成功 | カテゴリが正常に削除されました | 削除成功時 |
| MSG-DEL-002 | エラー | このカテゴリは他のレコードで使用されているため削除できません | 外部キー制約違反時 |
| MSG-BULK-001 | 成功 | 選択したカテゴリが正常に削除されました | 一括削除成功時 |
| MSG-BULK-002 | エラー | 一部のカテゴリは他のレコードで使用されているため削除できません | 一括削除で制約違反時 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーページを表示、またはリダイレクト |
| 外部キー制約違反 | エラー通知を表示し、削除処理をキャンセル |
| データベース接続エラー | システムエラーページを表示 |

## 備考

- 本画面はWebkul\Product\Filament\Resources\CategoryResourceのListCategoriesを継承して実装されています
- ProductCategoryResourceはWebkul\Product\Filament\Resources\CategoryResourceを拡張しています
- テーブルカラムは並び替え可能（reorderableColumns）です
- 一覧ページではサブナビゲーションがStart位置に表示されます（getSubNavigationPosition）
- マルチステップルート設定（enable_multi_steps_routes）が有効な場合、インベントリセクションに物流ルートの選択フィールドが表示されます
