# 画面設計書 143-商品カテゴリ作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「商品カテゴリ作成」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、新しい商品カテゴリを作成するためのフォーム画面です。カテゴリ名と親カテゴリを設定することで、階層構造を持つ商品カテゴリを登録できます。また、マルチステップルート設定が有効な場合は、物流ルートの設定も可能です。

**業務上の目的・背景**：商品カテゴリは在庫管理における商品の分類体系の基盤となります。適切なカテゴリ階層を構築することで、商品検索の効率化、在庫レポートの集計、物流ルートの自動適用などが可能になります。新規カテゴリの作成時に親カテゴリを指定することで、親子関係による階層構造を形成し、完全パス名（full_name）が自動生成されます。

**画面へのアクセス方法**：在庫管理モジュール → 設定（Configurations）クラスター → 商品カテゴリ一覧 → 新規作成ボタン

**主要な操作・処理内容**：
1. カテゴリ名の入力（必須、255文字以内、一意制約）
2. 親カテゴリの選択（任意、検索・プリロード対応）
3. 物流ルートの選択（マルチステップルート有効時のみ表示）
4. 作成ボタン押下によるレコード保存
5. キャンセルによる一覧画面への戻り

**画面遷移**：
- 遷移元：商品カテゴリ一覧画面
- 遷移先：商品カテゴリ詳細画面（作成成功後）、商品カテゴリ一覧画面（キャンセル時）

**権限による表示制御**：特になし（在庫管理モジュールへのアクセス権限に依存）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-029 | 商品カテゴリ管理 | 主機能 | カテゴリ新規作成 |
| FN-PRD-013 | カテゴリ管理 | 補助機能 | 基底カテゴリフォームの継承 |

## 画面種別

登録

## URL/ルーティング

`/inventories/configurations/product-categories/create`

## 画面構成

- サブナビゲーション（Start位置）
  - Configurationsクラスターのコンポーネント一覧
- フォーム（1カラムレイアウト）
  - 左側グループ（2カラム幅）
    - 一般セクション
  - 右側グループ（1カラム幅）
    - 空（将来拡張用）
  - インベントリセクション（マルチステップルート有効時のみ）
    - 物流フィールドセット
- フッターアクション
  - 作成ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | フィールド名 | データ型 | 必須 | 最大長 | 入力形式 | バリデーション | 説明 |
|--------|-------------|---------|------|--------|---------|---------------|------|
| カテゴリ名 | name | string | ○ | 255 | テキスト入力（大きめスタイル） | required, max:255, unique | カテゴリ名称 |
| 親カテゴリ | parent_id | integer | - | - | Select（検索・プリロード） | exists:categories,id | 親カテゴリへのリレーション |
| 物流ルート | routes | array | - | - | Select（複数選択・検索・プリロード） | exists:routes,id | 適用する物流ルート（複数可） |

## 表示項目

該当なし（作成画面のため）

## イベント仕様

### 1-作成ボタン押下

入力値のバリデーション後、商品カテゴリレコードを作成します。
- 成功時：商品カテゴリ詳細画面へリダイレクト
- 失敗時：バリデーションエラーメッセージを表示

### 2-キャンセルボタン押下

入力内容を破棄し、商品カテゴリ一覧画面へ遷移します。

### 3-親カテゴリ選択

Selectコンポーネントで親カテゴリを検索・選択します。full_name（完全パス名）が表示されます。

### 4-物流ルート選択（マルチステップルート有効時）

複数の物流ルートを選択できます。カテゴリに紐づく商品に自動適用されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products_categories | SELECT | 親カテゴリ選択肢の取得 |
| 画面表示 | inventories_routes | SELECT | 物流ルート選択肢の取得 |
| 作成ボタン押下 | products_categories | INSERT | カテゴリレコードの作成 |
| 作成ボタン押下 | category_route | INSERT | カテゴリ-ルート中間テーブルへの挿入 |

### テーブル別更新項目詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | parent_id | フォーム選択値（null可） | 親カテゴリID |
| INSERT | full_name | 自動生成（親パス + 名前） | 階層パス |
| INSERT | parent_path | 自動生成（親のparent_path + 親ID） | 親パス |
| INSERT | creator_id | ログインユーザーID | 作成者 |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

#### category_route（中間テーブル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | category_id | 作成されたカテゴリID | 外部キー |
| INSERT | route_id | 選択されたルートID | 外部キー（複数可） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-CRT-001 | 成功 | カテゴリが正常に作成されました | 作成成功時 |
| MSG-VAL-001 | エラー | カテゴリ名は必須です | 名前未入力時 |
| MSG-VAL-002 | エラー | このカテゴリ名は既に使用されています | 一意制約違反時 |
| MSG-VAL-003 | エラー | カテゴリ名は255文字以内で入力してください | 最大長超過時 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーページを表示、またはリダイレクト |
| バリデーションエラー | フォーム上にエラーメッセージを表示 |
| データベースエラー | エラー通知を表示し、フォーム入力を維持 |
| 一意制約違反 | カテゴリ名フィールドにエラーを表示 |

## 備考

- 本画面はWebkul\Product\Filament\Resources\CategoryResource\Pages\CreateCategoryを継承して実装されています
- サブナビゲーション位置はStart（SubNavigationPosition::Start）に設定されています
- generateNavigationItemsメソッドでクラスター内コンポーネントのナビゲーションを生成します
- カテゴリ名の入力フィールドは大きめのスタイル（font-size: 1.5rem; height: 3rem）が適用されています
- インベントリセクションはWarehouseSettingsのenable_multi_steps_routesが有効な場合のみ表示されます
- 物流ルート（routes）はリレーションシップとして設定され、中間テーブルを介して多対多の関係を形成します
