# 画面設計書 144-商品カテゴリ編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「商品カテゴリ編集」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、既存の商品カテゴリ情報を編集するためのフォーム画面です。カテゴリ名と親カテゴリを変更することで、カテゴリの階層構造を更新できます。また、マルチステップルート設定が有効な場合は、物流ルートの設定変更も可能です。

**業務上の目的・背景**：商品カテゴリの編集は、組織体制の変更や商品ラインナップの再編成に伴い必要となります。カテゴリ名の変更は関連する商品の分類表示に影響し、親カテゴリの変更はカテゴリ階層全体に影響します。本画面では、既存カテゴリの属性を安全に変更し、関連する完全パス名（full_name）やサブカテゴリへの影響を適切に処理します。

**画面へのアクセス方法**：
- 商品カテゴリ一覧画面 → 行アクションの編集を選択
- 商品カテゴリ詳細画面 → サブナビゲーションの編集タブを選択

**主要な操作・処理内容**：
1. 現在のカテゴリ情報の表示（既存値のロード）
2. カテゴリ名の変更（必須、255文字以内、一意制約）
3. 親カテゴリの変更（任意、検索・プリロード対応）
4. 物流ルートの変更（マルチステップルート有効時のみ）
5. 保存ボタン押下によるレコード更新
6. 削除ボタン押下によるレコード削除
7. キャンセルによる詳細画面への戻り

**画面遷移**：
- 遷移元：商品カテゴリ一覧画面、商品カテゴリ詳細画面
- 遷移先：商品カテゴリ詳細画面（保存成功後）、商品カテゴリ一覧画面（削除成功後、キャンセル時）

**権限による表示制御**：特になし（在庫管理モジュールへのアクセス権限に依存）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-029 | 商品カテゴリ管理 | 主機能 | カテゴリ編集・削除 |
| FN-PRD-013 | カテゴリ管理 | 補助機能 | 基底カテゴリフォームの継承 |

## 画面種別

編集

## URL/ルーティング

`/inventories/configurations/product-categories/{record}/edit`

## 画面構成

- サブナビゲーション（Top位置）
  - 詳細表示タブ
  - 編集タブ（現在地）
  - 商品管理タブ
- ヘッダーアクション
  - 削除ボタン
- フォーム（1カラムレイアウト）
  - 左側グループ（2カラム幅）
    - 一般セクション
  - 右側グループ（1カラム幅）
    - 空（将来拡張用）
  - インベントリセクション（マルチステップルート有効時のみ）
    - 物流フィールドセット
- フッターアクション
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | フィールド名 | データ型 | 必須 | 最大長 | 入力形式 | バリデーション | 説明 |
|--------|-------------|---------|------|--------|---------|---------------|------|
| カテゴリ名 | name | string | ○ | 255 | テキスト入力（大きめスタイル） | required, max:255, unique:ignore_self | カテゴリ名称 |
| 親カテゴリ | parent_id | integer | - | - | Select（検索・プリロード） | exists:categories,id | 親カテゴリへのリレーション |
| 物流ルート | routes | array | - | - | Select（複数選択・検索・プリロード） | exists:routes,id | 適用する物流ルート（複数可） |

## 表示項目

該当なし（編集画面のため、入力項目が初期値としてロードされます）

## イベント仕様

### 1-保存ボタン押下

入力値のバリデーション後、商品カテゴリレコードを更新します。
- 成功時：商品カテゴリ詳細画面へリダイレクト
- 失敗時：バリデーションエラーメッセージを表示

### 2-削除ボタン押下

削除確認ダイアログを表示し、確認後にレコードを削除します。
- 成功時：商品カテゴリ一覧画面へリダイレクト
- 失敗時：外部キー制約違反エラーを表示

### 3-キャンセルボタン押下

入力内容の変更を破棄し、商品カテゴリ詳細画面へ遷移します。

### 4-親カテゴリ変更

親カテゴリを変更すると、保存時にfull_nameとparent_pathが再計算されます。子カテゴリがある場合は、それらのパスも連鎖的に更新されます。

### 5-物流ルート変更（マルチステップルート有効時）

物流ルートの追加・削除を行います。変更は保存時に中間テーブルに反映されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products_categories | SELECT | 編集対象カテゴリの取得 |
| 画面表示 | products_categories | SELECT | 親カテゴリ選択肢の取得 |
| 画面表示 | inventories_routes | SELECT | 物流ルート選択肢の取得 |
| 保存ボタン押下 | products_categories | UPDATE | カテゴリレコードの更新 |
| 保存ボタン押下 | category_route | DELETE/INSERT | ルート関連の同期 |
| 削除ボタン押下 | products_categories | DELETE | カテゴリの削除 |

### テーブル別更新項目詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | URL パラメータ {record} | 編集対象 |
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | parent_id | フォーム選択値（null可） | 親カテゴリID |
| UPDATE | full_name | 自動再計算 | 親変更時に更新 |
| UPDATE | parent_path | 自動再計算 | 親変更時に更新 |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| DELETE | id | 選択されたレコードID | 削除時 |

#### category_route（中間テーブル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | category_id | 編集対象カテゴリID | 既存関連を削除 |
| INSERT | category_id | 編集対象カテゴリID | 新規関連を挿入 |
| INSERT | route_id | 選択されたルートID | 複数可 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-UPD-001 | 成功 | カテゴリが正常に更新されました | 更新成功時 |
| MSG-DEL-001 | 成功 | カテゴリが正常に削除されました | 削除成功時 |
| MSG-DEL-002 | エラー | このカテゴリは他のレコードで使用されているため削除できません | 外部キー制約違反時 |
| MSG-VAL-001 | エラー | カテゴリ名は必須です | 名前未入力時 |
| MSG-VAL-002 | エラー | このカテゴリ名は既に使用されています | 一意制約違反時 |
| MSG-VAL-003 | エラー | カテゴリ名は255文字以内で入力してください | 最大長超過時 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| レコード未存在 | 404エラーページを表示 |
| 権限不足 | 403エラーページを表示、またはリダイレクト |
| バリデーションエラー | フォーム上にエラーメッセージを表示 |
| 外部キー制約違反（削除時） | エラー通知を表示し、削除処理をキャンセル |
| データベースエラー | エラー通知を表示し、フォーム入力を維持 |
| 一意制約違反 | カテゴリ名フィールドにエラーを表示 |

## 備考

- 本画面はWebkul\Product\Filament\Resources\CategoryResource\Pages\EditCategoryを継承して実装されています
- サブナビゲーション位置はTop（詳細・編集画面時）に設定されます
- 一意制約のバリデーションでは自身のレコードを除外します（ignoreRecord: true）
- 親カテゴリを変更した場合、子カテゴリのfull_name、parent_pathも連鎖的に更新される可能性があります（モデルのロジックに依存）
- インベントリセクションはWarehouseSettingsのenable_multi_steps_routesが有効な場合のみ表示されます
