# 画面設計書 145-商品カテゴリ詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「商品カテゴリ詳細」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、商品カテゴリの詳細情報を表示するための画面です。カテゴリ名、階層パス、親カテゴリ情報、物流ルート設定（マルチステップルート有効時）、レコード情報を確認することができます。

**業務上の目的・背景**：商品カテゴリ詳細画面は、カテゴリの設定内容を確認するために使用されます。階層構造を持つカテゴリの完全パス（full_name）や親パス（parent_path）を視覚的に確認することで、カテゴリ体系の整合性を検証できます。また、マルチステップルートが有効な場合は、カテゴリに適用される物流ルートの設定も確認できます。

**画面へのアクセス方法**：
- 商品カテゴリ一覧画面 → 対象行をクリック または 表示アクションを選択
- 商品カテゴリ編集画面 → サブナビゲーションの詳細タブを選択

**主要な操作・処理内容**：
1. カテゴリ名の確認
2. 親カテゴリの確認
3. 完全パス名（full_name）の確認
4. 親パス（parent_path）の確認
5. 物流ルートの確認（マルチステップルート有効時）
6. 作成者・作成日時・更新日時の確認
7. 編集画面への遷移
8. 商品管理画面への遷移

**画面遷移**：
- 遷移元：商品カテゴリ一覧画面、商品カテゴリ編集画面
- 遷移先：商品カテゴリ編集画面、商品管理画面

**権限による表示制御**：特になし（在庫管理モジュールへのアクセス権限に依存）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-029 | 商品カテゴリ管理 | 主機能 | カテゴリ詳細表示 |
| FN-PRD-013 | カテゴリ管理 | 補助機能 | 基底カテゴリinfolistの継承 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/configurations/product-categories/{record}`

## 画面構成

- サブナビゲーション（Top位置）
  - 詳細表示タブ（現在地）
  - 編集タブ
  - 商品管理タブ
- メインコンテンツ（3カラムレイアウト）
  - 左側グループ（2カラム幅）
    - 一般セクション
    - インベントリセクション（マルチステップルート有効時のみ）
      - 物流サブセクション
  - 右側グループ（1カラム幅）
    - レコード情報セクション

## 入出力項目

該当なし（詳細画面のため入力項目はありません）

## 表示項目

### 一般セクション

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| 名前 | name | string | heroicon-o-document-text | カテゴリ名（太字・大サイズ） |
| 親カテゴリ | parent.name | string | heroicon-o-folder | 親カテゴリ名 |
| 完全名 | full_name | string | heroicon-o-folder-open | 階層を含む完全パス名 |
| 親パス | parent_path | string | heroicon-o-arrows-right-left | 親カテゴリのパス |

### インベントリセクション（マルチステップルート有効時）

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| ルート名 | routes.name | array | heroicon-o-truck | 適用される物流ルート（リスト形式） |

### レコード情報セクション

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| 作成者 | creator.name | string | heroicon-o-user | レコード作成者名 |
| 作成日時 | created_at | datetime | heroicon-o-calendar | レコード作成日時 |
| 更新日時 | updated_at | datetime | heroicon-o-clock | レコード更新日時 |

## イベント仕様

### 1-サブナビゲーション編集タブ選択

編集タブ選択時、商品カテゴリ編集画面へ遷移します。

### 2-サブナビゲーション商品管理タブ選択

商品管理タブ選択時、このカテゴリに属する商品の管理画面へ遷移します。

### 3-ルートエントリクリック（マルチステップルート有効時）

各ルート名は表示のみで、クリックアクションは設定されていません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | products_categories | SELECT | カテゴリ情報の取得 |
| 詳細表示 | products_categories | SELECT | 親カテゴリ情報の取得 |
| 詳細表示 | users | SELECT | 作成者情報の取得 |
| 詳細表示 | inventories_routes | SELECT | 関連ルート情報の取得 |

### テーブル別更新項目詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | URL パラメータ {record} に一致 | 主キー |
| SELECT | name | - | 表示用 |
| SELECT | full_name | - | 表示用 |
| SELECT | parent_path | - | 表示用 |
| SELECT | parent_id | - | 親カテゴリリレーション用 |
| SELECT | creator_id | - | 作成者リレーション用 |
| SELECT | created_at | - | 表示用 |
| SELECT | updated_at | - | 表示用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | 詳細画面のため特定のメッセージ表示なし |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| レコード未存在 | 404エラーページを表示 |
| 権限不足 | 403エラーページを表示、またはリダイレクト |

## 備考

- 本画面はWebkul\Product\Filament\Resources\CategoryResource\Pages\ViewCategoryを継承して実装されています
- サブナビゲーション位置はTop（詳細画面時）に設定されます
- infolistは3カラムレイアウトで構成されています
- インベントリセクションはWarehouseSettingsのenable_multi_steps_routesが有効な場合のみ表示されます
- ルート情報はRepeatableEntryで表示され、各ルート名がリスト形式で表示されます
- レコード情報セクションは折りたたみ可能（collapsible）です
- 名前フィールドはFontWeight::BoldとTextSize::Largeスタイルが適用されています
