# 画面設計書 146-商品一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「商品一覧」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、在庫管理で使用する商品を一覧表示し、検索・フィルタリング・並び替え・グルーピングなどの操作を行うための画面です。在庫追跡対象の商品に特化したビュー（在庫管理タブ）も提供されます。

**業務上の目的・背景**：商品一覧は在庫管理業務の中心的な画面であり、在庫状況の確認、商品情報の検索、商品の登録・編集・削除などの基本的な商品マスタ管理を行います。在庫管理モジュールでは特に「在庫追跡対象（is_storable = true）」の商品を効率的に管理するためのプリセットビューが追加されています。商品にはお気に入り機能があり、頻繁に参照する商品をマークできます。

**画面へのアクセス方法**：在庫管理モジュール → 商品（Products）クラスター → 商品

**主要な操作・処理内容**：
1. 商品の一覧表示（テーブル形式）
2. 商品名、参照番号、バーコードでの検索
3. 高度なフィルタリング（QueryBuilder使用）
4. 種別、カテゴリ、作成日でのグルーピング
5. カラム表示/非表示の切り替え
6. カラムの並び替え（ドラッグ&ドロップ）
7. 表示順序の変更（sort列）
8. 在庫管理タブでの在庫追跡対象商品の絞り込み
9. 新規商品作成画面への遷移
10. 商品詳細画面への遷移
11. 商品編集画面への遷移
12. 商品の削除・復元・完全削除
13. バーコード印刷

**画面遷移**：
- 遷移元：在庫管理ダッシュボード、商品メニュー
- 遷移先：商品作成画面、商品詳細画面、商品編集画面

**権限による表示制御**：特になし（在庫管理モジュールへのアクセス権限に依存）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-020 | 在庫商品一覧 | 主機能 | 商品一覧表示・検索・フィルタ |
| FN-PRD-001 | 商品一覧 | 補助機能 | 基底商品機能の継承 |
| FN-PRD-009 | お気に入り | 補助機能 | 商品のお気に入り登録/解除 |
| FN-PRD-010 | 印刷 | 補助機能 | 商品バーコードの印刷 |

## 画面種別

一覧

## URL/ルーティング

`/inventories/products/products`

## 画面構成

- プリセットビュータブ
  - 在庫管理タブ（storable_products）：is_storable = true の商品のみ表示
- ヘッダーアクション
  - 新規作成ボタン
- テーブル
  - カラム管理機能（2列表示）
  - 並び替え可能なカラム
  - ソート列による表示順序制御
  - グルーピング機能
  - 高度なフィルター機能（モーダル・スライドオーバー形式）
  - 一括操作機能

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | フィールド名 | データ型 | 検索可否 | ソート可否 | デフォルト表示 | 説明 |
|--------|-------------|---------|---------|-----------|--------------|------|
| お気に入り | is_favorite | boolean | - | - | ○ | お気に入りアイコン（クリックで切替） |
| 画像 | images | array | - | - | ○ | 商品画像（円形・スタック・最大3枚） |
| 商品名 | name | string | ○ | ○ | ○ | 商品名称 |
| バリエーション数 | variants_count | integer | - | ○ | ○ | バリエーション件数 |
| 参照番号 | reference | string | ○ | ○ | ○ | 商品参照番号 |
| タグ | tags.name | array | - | - | ○ | 商品タグ（バッジ表示） |
| 担当者 | responsible.name | string | - | ○ | × | 担当者名 |
| バーコード | barcode | string | ○ | ○ | × | 商品バーコード |
| 会社 | company.name | string | - | ○ | × | 所属会社名 |
| 価格 | price | decimal | - | ○ | ○ | 販売価格 |
| 原価 | cost | decimal | - | ○ | ○ | 仕入原価 |
| カテゴリ | category.name | string | - | ○ | × | 商品カテゴリ名 |
| 種別 | type | enum | - | ○ | × | 商品種別 |
| 削除日時 | deleted_at | datetime | - | ○ | × | 論理削除日時 |
| 作成日時 | created_at | datetime | - | ○ | × | レコード作成日時 |
| 更新日時 | updated_at | datetime | - | ○ | × | レコード更新日時 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタン押下時、商品作成画面へ遷移します。

### 2-お気に入りアイコンクリック

お気に入り状態を切り替えます（is_favoriteを反転）。

### 3-行クリック（表示アクション）

テーブル行の表示アクション選択時、商品詳細画面へ遷移します。削除済み商品は非表示。

### 4-編集アクション選択

行アクションの編集を選択時、商品編集画面へ遷移します。削除済み商品は非表示。

### 5-削除アクション選択

行アクションの削除を選択時、論理削除を実行します。

### 6-復元アクション選択

削除済み商品の復元アクション選択時、論理削除を解除します。

### 7-完全削除アクション選択

削除済み商品の完全削除アクション選択時、物理削除を実行します。外部キー制約違反時はエラー通知を表示。

### 8-バーコード印刷

一括操作で選択した商品のバーコードをPDF形式で出力します。数量とフォーマットを指定可能。

### 9-在庫管理タブ選択

プリセットビューの在庫管理タブを選択時、is_storable = true の商品のみを表示します。

### 10-フィルター適用

高度なフィルター（QueryBuilder）を使用して、複雑な条件での絞り込みを適用します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | products | SELECT | 商品情報の取得 |
| 一覧表示 | products_categories | SELECT | カテゴリ情報の取得 |
| 一覧表示 | users | SELECT | 担当者・作成者情報の取得 |
| お気に入り切替 | products | UPDATE | is_favoriteの更新 |
| 削除アクション | products | UPDATE | deleted_atの設定（論理削除） |
| 復元アクション | products | UPDATE | deleted_atの解除 |
| 完全削除 | products | DELETE | 物理削除 |

### テーブル別更新項目詳細

#### products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | - | 主キー |
| SELECT | name | - | 検索・表示用 |
| SELECT | reference | - | 検索・表示用 |
| SELECT | barcode | - | 検索・表示用 |
| SELECT | is_favorite | - | 表示用 |
| SELECT | is_storable | - | プリセットビュー絞り込み |
| SELECT | images | - | 表示用（JSON） |
| SELECT | price | - | 表示用 |
| SELECT | cost | - | 表示用 |
| SELECT | type | - | 表示・グルーピング用 |
| SELECT | sort | - | 表示順序用 |
| UPDATE | is_favorite | 反転値 | お気に入り切替時 |
| UPDATE | deleted_at | 現在日時/NULL | 論理削除/復元時 |
| DELETE | id | 選択されたID | 完全削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-DEL-001 | 成功 | 商品が正常に削除されました | 削除成功時 |
| MSG-RST-001 | 成功 | 商品が正常に復元されました | 復元成功時 |
| MSG-FRC-001 | 成功 | 商品が完全に削除されました | 完全削除成功時 |
| MSG-FRC-002 | エラー | この商品は他のレコードで使用されているため削除できません | 外部キー制約違反時 |
| MSG-BULK-DEL-001 | 成功 | 選択した商品が正常に削除されました | 一括削除成功時 |
| MSG-BULK-RST-001 | 成功 | 選択した商品が正常に復元されました | 一括復元成功時 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーページを表示、またはリダイレクト |
| 外部キー制約違反 | エラー通知を表示し、削除処理をキャンセル |
| データベース接続エラー | システムエラーページを表示 |

## 備考

- 本画面はWebkul\Product\Filament\Resources\ProductResource\Pages\ListProductsを継承して実装されています
- 在庫管理モジュール固有のプリセットビュー「在庫管理」（storable_products）が追加されています
- テーブルはsort列で降順ソートされ、ドラッグ&ドロップによる並び替えが可能です
- フィルターはモーダル形式（FiltersLayout::Modal）でスライドオーバー表示されます
- 高度なフィルター（QueryBuilder）では、テキスト・数値・日付・ブール・リレーション等の多彩な条件指定が可能です
- 印刷機能では複数のフォーマット（dymo, 2x7_price, 4x7_price, 4x12, 4x12_price）が選択可能です
- 論理削除（SoftDeletes）に対応しており、deleted_at列で削除状態を管理します
