# 画面設計書 147-商品作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「商品作成」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、新しい商品を作成するためのフォーム画面です。商品の基本情報、画像、在庫追跡設定、物流情報、トレーサビリティ情報などを入力して商品マスタに登録できます。

**業務上の目的・背景**：商品マスタは在庫管理・販売・購買の基盤となる重要なマスタデータです。商品の種別（物品/サービス/コンボ）によって在庫追跡の要否が異なり、物品の場合は在庫数量の追跡、ロット/シリアル番号管理、有効期限管理などの詳細設定が可能です。また、物流ルートの設定により、商品ごとの入出庫フローを制御できます。

**画面へのアクセス方法**：在庫管理モジュール → 商品（Products）クラスター → 商品一覧 → 新規作成ボタン

**主要な操作・処理内容**：
1. 商品名の入力（必須）
2. 商品説明の入力（リッチエディタ）
3. 商品タグの選択・作成
4. 商品画像のアップロード（複数可）
5. 商品種別の選択（物品/サービス/コンボ）
6. 参照番号・バーコードの入力
7. カテゴリ・会社の選択
8. 価格・原価の入力
9. 在庫追跡設定（物品のみ）
10. 追跡方法（数量/ロット/シリアル番号）の選択
11. 物流ルートの選択
12. 重量・容積・販売リードタイムの入力
13. トレーサビリティ設定（有効期限使用時）
14. カスタムフィールドの入力（設定されている場合）

**画面遷移**：
- 遷移元：商品一覧画面
- 遷移先：商品詳細画面（作成成功後）、商品一覧画面（キャンセル時）

**権限による表示制御**：特になし（在庫管理モジュールへのアクセス権限に依存）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-020 | 在庫商品管理 | 主機能 | 商品新規作成 |
| FN-PRD-002 | 商品作成 | 補助機能 | 基底商品フォームの継承 |

## 画面種別

登録

## URL/ルーティング

`/inventories/products/products/create`

## 画面構成

- フォーム（3カラムレイアウト）
  - 左側グループ（2カラム幅）
    - 一般セクション（商品名、説明、タグ）
    - 画像セクション
    - インベントリセクション（物品のみ表示）
      - トラッキングフィールドセット
      - オペレーションフィールドセット
      - 物流フィールドセット
      - トレーサビリティフィールドセット（有効期限使用時）
    - 追加セクション（カスタムフィールド、設定時のみ）
  - 右側グループ（1カラム幅）
    - 設定セクション（種別、参照番号、バーコード、カテゴリ、会社）
    - 価格セクション（価格、原価）
- フッターアクション
  - 作成ボタン
  - キャンセルボタン

## 入出力項目

### 一般セクション

| 項目名 | フィールド名 | データ型 | 必須 | 最大長 | 入力形式 | バリデーション | 説明 |
|--------|-------------|---------|------|--------|---------|---------------|------|
| 商品名 | name | string | ○ | 255 | テキスト入力（大きめスタイル） | required, max:255 | 商品名称 |
| 説明 | description | text | - | - | RichEditor | - | 商品説明（HTML形式） |
| タグ | tags | array | - | - | Select（複数選択・検索・作成可） | - | 商品タグ |

### 画像セクション

| 項目名 | フィールド名 | データ型 | 必須 | 入力形式 | バリデーション | 説明 |
|--------|-------------|---------|------|---------|---------------|------|
| 画像 | images | array | - | FileUpload（複数可） | image | 商品画像 |

### 設定セクション

| 項目名 | フィールド名 | データ型 | 必須 | 入力形式 | バリデーション | 説明 |
|--------|-------------|---------|------|---------|---------------|------|
| 種別 | type | enum | ○ | Radio | required | 商品種別（GOODS/SERVICE/COMBO） |
| 参照番号 | reference | string | - | TextInput | max:255 | 商品参照番号 |
| バーコード | barcode | string | - | TextInput | max:255 | 商品バーコード |
| カテゴリ | category_id | integer | ○ | Select（検索・作成可） | required, exists | 商品カテゴリ |
| 会社 | company_id | integer | - | Select（検索） | exists | 所属会社 |

### 価格セクション

| 項目名 | フィールド名 | データ型 | 必須 | 入力形式 | バリデーション | 説明 |
|--------|-------------|---------|------|---------|---------------|------|
| 価格 | price | decimal | ○ | TextInput（数値） | required, min:0 | 販売価格 |
| 原価 | cost | decimal | - | TextInput（数値） | min:0 | 仕入原価 |

### インベントリセクション（物品のみ）

| 項目名 | フィールド名 | データ型 | 必須 | 入力形式 | バリデーション | 説明 |
|--------|-------------|---------|------|---------|---------------|------|
| 在庫追跡 | is_storable | boolean | - | Toggle | - | 在庫追跡対象フラグ |
| 追跡方法 | tracking | enum | - | Select | - | 追跡方法（QTY/LOT/SERIAL） |
| ルート | routes | array | - | CheckboxList | - | 物流ルート |
| 担当者 | responsible_id | integer | - | Select | exists | 担当者 |
| 重量 | weight | decimal | - | TextInput | min:0 | 重量 |
| 容積 | volume | decimal | - | TextInput | min:0 | 容積 |
| 販売リードタイム | sale_delay | integer | - | TextInput | min:0 | 販売リードタイム（日） |

### トレーサビリティセクション（有効期限使用時）

| 項目名 | フィールド名 | データ型 | 必須 | 入力形式 | バリデーション | 説明 |
|--------|-------------|---------|------|---------|---------------|------|
| 有効期限 | expiration_time | integer | - | TextInput | min:0 | 有効期限（日） |
| 賞味期限 | use_time | integer | - | TextInput | min:0 | 賞味期限（日） |
| 撤去期限 | removal_time | integer | - | TextInput | min:0 | 撤去期限（日） |
| アラート期限 | alert_time | integer | - | TextInput | min:0 | アラート期限（日） |

## 表示項目

該当なし（作成画面のため）

## イベント仕様

### 1-作成ボタン押下

入力値のバリデーション後、商品レコードを作成します。
- 成功時：商品詳細画面へリダイレクト
- 失敗時：バリデーションエラーメッセージを表示

### 2-キャンセルボタン押下

入力内容を破棄し、商品一覧画面へ遷移します。

### 3-種別変更

種別を「物品（GOODS）」に変更すると、インベントリセクションが表示されます。「サービス」「コンボ」の場合は非表示。

### 4-在庫追跡トグル変更

在庫追跡をOFFにすると、追跡方法が「数量」に設定され、有効期限使用がOFFになります。

### 5-追跡方法変更

追跡方法を「数量」に変更すると、有効期限使用がOFFになります。

### 6-タグ作成

新規タグを作成する場合、インラインでタグ名を入力して作成できます。

### 7-カテゴリ作成

新規カテゴリを作成する場合、インラインでカテゴリフォームが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products_categories | SELECT | カテゴリ選択肢の取得 |
| 画面表示 | companies | SELECT | 会社選択肢の取得 |
| 画面表示 | inventories_routes | SELECT | ルート選択肢の取得 |
| 画面表示 | users | SELECT | 担当者選択肢の取得 |
| 作成ボタン押下 | products | INSERT | 商品レコードの作成 |
| 作成ボタン押下 | products_tags | INSERT | タグ関連の挿入 |
| 作成ボタン押下 | product_route | INSERT | ルート関連の挿入 |

### テーブル別更新項目詳細

#### products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | description | フォーム入力値 | HTML形式 |
| INSERT | type | フォーム選択値 | Enum |
| INSERT | reference | フォーム入力値 | 任意 |
| INSERT | barcode | フォーム入力値 | 任意 |
| INSERT | category_id | フォーム選択値 | 必須 |
| INSERT | company_id | フォーム選択値またはデフォルト | ログインユーザーのデフォルト会社 |
| INSERT | price | フォーム入力値 | デフォルト0 |
| INSERT | cost | フォーム入力値 | デフォルト0 |
| INSERT | is_storable | フォーム選択値 | デフォルトtrue |
| INSERT | tracking | フォーム選択値 | デフォルトQTY |
| INSERT | responsible_id | フォーム選択値 | 任意 |
| INSERT | weight | フォーム入力値 | 任意 |
| INSERT | volume | フォーム入力値 | 任意 |
| INSERT | sale_delay | フォーム入力値 | 任意 |
| INSERT | expiration_time | フォーム入力値 | 任意 |
| INSERT | use_time | フォーム入力値 | 任意 |
| INSERT | removal_time | フォーム入力値 | 任意 |
| INSERT | alert_time | フォーム入力値 | 任意 |
| INSERT | images | フォーム入力値 | JSON形式 |
| INSERT | uom_id | デフォルトUOM ID | 隠しフィールド |
| INSERT | uom_po_id | デフォルトUOM ID | 隠しフィールド |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-CRT-001 | 成功 | 商品が正常に作成されました | 作成成功時 |
| MSG-VAL-001 | エラー | 商品名は必須です | 名前未入力時 |
| MSG-VAL-002 | エラー | 価格は必須です | 価格未入力時 |
| MSG-VAL-003 | エラー | カテゴリは必須です | カテゴリ未選択時 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーページを表示、またはリダイレクト |
| バリデーションエラー | フォーム上にエラーメッセージを表示 |
| ファイルアップロードエラー | 画像フィールドにエラーを表示 |
| データベースエラー | エラー通知を表示し、フォーム入力を維持 |

## 備考

- 本画面はWebkul\Product\Filament\Resources\ProductResource\Pages\CreateProductを継承して実装されています
- フォームは3カラムレイアウトで構成されています
- インベントリセクションは商品種別が「物品（GOODS）」の場合のみ表示されます
- 追跡方法の選択はTraceabilitySettingsのenable_lots_serial_numbersが有効で、かつis_storableがtrueの場合のみ表示されます
- トレーサビリティフィールドセットはuse_expiration_dateがtrueの場合のみ表示されます
- ルートのCheckboxListはproduct_selectableがtrueのルートのみが選択可能です
- uom_id、uom_po_idはHiddenフィールドとしてデフォルトUOMが設定されます
- HasCustomFieldsトレイトにより、カスタムフィールドが設定されている場合は追加セクションが表示されます
